% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{MaST}
\alias{MaST}
\title{Maximum Spanning Tree}
\usage{
MaST(data, binary = FALSE, weighted = TRUE)
}
\arguments{
\item{data}{Can be a dataset or a correlation matrix}

\item{binary}{Is dataset dichotomous? Defaults to FALSE. Set TRUE if dataset is dichotomous (tetrachoric correlations are computed)}

\item{weighted}{Should network be weighted? Defaults to TRUE. Set FALSE to produce an unweighted (binary) network}
}
\value{
A sparse association matrix
}
\description{
Applies the Maximum Spanning Tree (MaST) filtering method
}
\examples{
weighted_MaSTnetwork<-MaST(data)

weighted_binary_MaSTnetwork<-MaST(data,binary=TRUE)

unweighted_MaSTnetwork<-MaST(data,weighted=FALSE)

unweighted_binary_MaSTnetwork<-MaST(data,binary=TRUE,weighted=FALSE)
}
\references{
Adapted from: <https://www.mathworks.com/matlabcentral/fileexchange/23276-maximum-weight-spanning-tree--undirected>
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
