% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{LoGo}
\alias{LoGo}
\title{Local/Global Sparse Inverse Covariance Matrix}
\usage{
LoGo(data, separators = TMFG(data)$separators, cliques = TMFG(data)$cliques)
}
\arguments{
\item{data}{Must be a dataset}

\item{separators}{Defaults to separators obtained from the TMFG function. Requires a list of separators}

\item{cliques}{Defaults to cliques obtained from the TMFG function. Requires a list of cliques}
}
\value{
Returns a sparse TMFG-filtered matrix of the inverse covariance
}
\description{
Applies the Local/Global method to estimate the sparse inverse covariance matrix
}
\examples{

LoGonet<-LoGo(hex)

}
\references{
Barfuss, W., Massara, G. P., Di Matteo, T., & Aste, T. (2016).
Parsimonious modeling with information filtering networks.
\emph{Physical Review E}, \emph{94}(6), 062306.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
