% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootgen.R
\name{bootgen}
\alias{bootgen}
\title{Bootstrapped Network Generalization}
\usage{
bootgen(data, method = c("MaST", "TMFG", "LoGo", "threshold"),
  n = nrow(data), iter = 1000, normal = FALSE,
  na.data = c("pairwise", "listwise", "fiml", "none"), cores, ...)
}
\arguments{
\item{data}{A set of data}

\item{method}{A network filtering method.
Defaults to "TMFG"}

\item{n}{Number of people to use in the bootstrap.
Defaults to full sample size}

\item{iter}{Number of bootstrap iterations.
Defaults to 1000 iterations}

\item{normal}{Should data be transformed to a normal distribution?
Defaults to FALSE.
Data is not transformed to be normal.
Set to TRUE if data should be transformed to be normal
(computes correlations using the \link[qgraph]{cor_auto} function)}

\item{na.data}{How should missing data be handled?
For "listwise" deletion the \code{\link{na.omit}} function is applied.
Set to "fiml" for Full Information Maxmimum Likelihood (\link[psych]{corFiml}).
Full Information Maxmimum Likelihood is \strong{recommended} but time consuming}

\item{cores}{Number of computer processing cores to use for bootstrapping samples.
Defaults to \emph{n} - 1 total number of cores.
Set to any number between 1 and maxmimum amount of cores on your computer}

\item{...}{Additional arguments for filtering methods}
}
\value{
Returns a list that includes:

\item{orignet}{the original filtered network}

\item{bootmat}{correlation matrix of the mean bootstrapped network}

\item{netrel}{unfiltered reliabilities of all of the connections}
}
\description{
Bootstraps the sample to identify the most stable correlations.
Also produces a network that is penalizes low reliability edges.
This function is useful for overcoming the structural constraint of the IFN approach.
STILL BEING DEVELOPED
}
\examples{
\dontrun{
bootTMFG<-bootgen(neoOpen)

bootLoGo<-bootgen(neoOpen,method="LoGo")

bootMaST<-bootgen(neoOpen,method="MaST")

bootThreshold<-bootgen(neoOpen,method="threshold")
}

}
\references{
Musciotto, F., Marotta, L., Micciche, S., & Mantegna, R. N. (2018).
Bootstrap validation of links of a minimum spanning tree.
\emph{arXiv}, 1802.03395.
doi: \href{https://arxiv.org/pdf/1802.03395.pdf}{1802.03395}

Tumminello, M., Coronnello, C., Lillo, F., Micciche, S., & Mantegna, R. N. (2007).
Spanning trees and bootstrap reliability estimation in correlation-based networks.
\emph{International Journal of Bifurcation and Chaos}, \emph{17}, 2319-2329.
doi: \href{https://doi.org/10.1142/S0218127407018415}{10.1142/S0218127407018415}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
