% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comcat.R
\name{comcat}
\alias{comcat}
\title{Communicating Nodes}
\usage{
comcat(A, comm = c("walktrap", "louvain"), cent = c("strength",
  "degree"), absolute = TRUE, metric = c("across", "each"),
  diagonal = 0, ...)
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{comm}{Can be a vector of community assignments or community detection algorithms
(\code{"walktrap"} or \code{"louvain"}) can be used to determine the number of factors.
Defaults to \code{"walktrap"}.
Set to \code{"louvain"} for \code{\link[NetworkToolbox]{louvain}} community detection}

\item{cent}{Centrality measure to be used.
Defaults to \code{"strength"}.}

\item{absolute}{Should network use absolute weights?
Defaults to \code{TRUE}.
Set to \code{FALSE} for signed weights}

\item{metric}{Whether the metric should be compute for across all of the communities
(a single value) or for each community (a value for each community).
Defaults to \code{"across"}.
Set to \code{"each"} for values for each community}

\item{diagonal}{Sets the diagonal values of the \code{A} input.
Defaults to \code{0}}

\item{...}{Additional arguments for \code{\link[igraph]{cluster_walktrap}}
and \code{\link[NetworkToolbox]{louvain}} community detection algorithms}
}
\value{
A vector containing the between-community strength value for each node
}
\description{
Computes the between-community strength for each node in the network
}
\examples{
A <- TMFG(neoOpen)$A

communicating <- comcat(A, comm = "walktrap", cent = "strength", metric = "across")

}
\references{
Blanken, T. F., Deserno, M. K., Dalege, J., Borsboom, D., Blanken, P., Kerkhof, G. A., & Cramer, A. O. (2018).
The role of stabilizing and communicating symptoms given overlapping communities in psychopathology networks.
\emph{Scientific Reports}, \emph{8}, 5854.
doi: \href{https://doi.org/10.1038/s41598-018-24224-2}{10.1038/s41598-018-24224-2}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
