% Generated by roxygen2 (4.0.2): do not edit by hand
\name{neuralweights}
\alias{neuralweights}
\alias{neuralweights.mlp}
\alias{neuralweights.nn}
\alias{neuralweights.nnet}
\alias{neuralweights.numeric}
\title{Get weights for a neural network}
\usage{
neuralweights(mod_in, ...)

\method{neuralweights}{numeric}(mod_in, rel_rsc = NULL, struct, ...)

\method{neuralweights}{nnet}(mod_in, rel_rsc = NULL, ...)

\method{neuralweights}{mlp}(mod_in, rel_rsc = NULL, ...)

\method{neuralweights}{nn}(mod_in, rel_rsc = NULL, ...)
}
\arguments{
\item{mod_in}{input object for which an organized model list is desired.  The input can be an object of class \code{numeric}, \code{nnet}, \code{mlp}, or \code{nn}}

\item{...}{arguments passed to other methods}

\item{rel_rsc}{numeric value indicating maximum to rescale weights for plotting in a neural interpretation diagram. Default is \code{NULL} for no rescaling.}

\item{struct}{numeric vector equal in length to the number of layers in the network.  Each number indicates the number of nodes in each layer starting with the input and ending with the output.  An arbitrary number of hidden layers can be included.}
}
\value{
Returns a two-element list with the first element being a vector indicating the number of nodes in each layer of the neural network and the second element being a named list of weight values for the input model.
}
\description{
Get weights for a neural network in an organized list by extracting values from a neural network object.  This function is generally not called by itself.
}
\details{
Each element of the returned list is named using the construct 'layer node', e.g. 'out 1' is the first node of the output layer.  Hidden layers are named using three values for instances with more than one hidden layer, e.g., 'hidden 1 1' is the first node in the first hidden layer, 'hidden 1 2' is the second node in the first hidden layer, 'hidden 2 1' is the first node in the second hidden layer, etc.  The values in each element of the list represent the weights entering the specific node from the preceding layer in sequential order, starting with the bias layer if applicable.
}
\examples{
data(neuraldat)
set.seed(123)

## using numeric input

wts_in <- c(13.12, 1.49, 0.16, -0.11, -0.19, -0.16, 0.56, -0.52, 0.81)
struct <- c(2, 2, 1) #two inputs, two hidden, one output

neuralweights(wts_in, struct = struct)

## using nnet

library(nnet)

mod <- nnet(Y1 ~ X1 + X2 + X3, data = neuraldat, size = 5, linout = TRUE)

neuralweights(mod)

## using RSNNS, no bias layers

library(RSNNS)

x <- neuraldat[, c('X1', 'X2', 'X3')]
y <- neuraldat[, 'Y1']
mod <- mlp(x, y, size = 5, linOut = TRUE)

neuralweights(mod)

## using neuralnet

library(neuralnet)

mod <- neuralnet(Y1 ~ X1 + X2 + X3, data = neuraldat, hidden = 5)

neuralweights(mod)
}

