% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plotnet}
\alias{plotnet}
\alias{plotnet.mlp}
\alias{plotnet.nn}
\alias{plotnet.nnet}
\alias{plotnet.numeric}
\alias{plotnet.train}
\title{Plot a neural network model}
\usage{
plotnet(mod_in, ...)

\method{plotnet}{nnet}(mod_in, nid = TRUE, all_out = TRUE, all_in = TRUE,
  bias = TRUE, wts_only = FALSE, rel_rsc = 5, circle_cex = 5,
  node_labs = TRUE, var_labs = TRUE, x_lab = NULL, y_lab = NULL,
  line_stag = NULL, cex_val = 1, alpha_val = 1,
  circle_col = "lightblue", pos_col = "black", neg_col = "grey",
  bord_col = "lightblue", max_sp = FALSE, ...)

\method{plotnet}{numeric}(mod_in, struct, nid = TRUE, all_out = TRUE,
  all_in = TRUE, bias = TRUE, wts_only = FALSE, rel_rsc = 5,
  circle_cex = 5, node_labs = TRUE, var_labs = TRUE, x_lab = NULL,
  y_lab = NULL, line_stag = NULL, cex_val = 1, alpha_val = 1,
  circle_col = "lightblue", pos_col = "black", neg_col = "grey",
  bord_col = "lightblue", max_sp = FALSE, ...)

\method{plotnet}{mlp}(mod_in, nid = TRUE, all_out = TRUE, all_in = TRUE,
  wts_only = FALSE, rel_rsc = 5, circle_cex = 5, node_labs = TRUE,
  var_labs = TRUE, x_lab = NULL, y_lab = NULL, line_stag = NULL,
  cex_val = 1, alpha_val = 1, circle_col = "lightblue",
  pos_col = "black", neg_col = "grey", bord_col = "lightblue",
  max_sp = FALSE, ...)

\method{plotnet}{nn}(mod_in, nid = TRUE, all_out = TRUE, all_in = TRUE,
  bias = TRUE, wts_only = FALSE, rel_rsc = 5, circle_cex = 5,
  node_labs = TRUE, var_labs = TRUE, x_lab = NULL, y_lab = NULL,
  line_stag = NULL, cex_val = 1, alpha_val = 1,
  circle_col = "lightblue", pos_col = "black", neg_col = "grey",
  bord_col = "lightblue", max_sp = FALSE, ...)

\method{plotnet}{train}(mod_in, nid = TRUE, all_out = TRUE, all_in = TRUE,
  bias = TRUE, wts_only = FALSE, rel_rsc = 5, circle_cex = 5,
  node_labs = TRUE, var_labs = TRUE, x_lab = NULL, y_lab = NULL,
  line_stag = NULL, cex_val = 1, alpha_val = 1,
  circle_col = "lightblue", pos_col = "black", neg_col = "grey",
  bord_col = "lightblue", max_sp = FALSE, ...)
}
\arguments{
\item{mod_in}{neural network object or numeric vector of weights}

\item{...}{additional arguments passed to plot}

\item{nid}{logical value indicating if neural interpretation diagram is plotted, default \code{TRUE}}

\item{all_out}{chr string indicating names of response variables for which connections are plotted, default all}

\item{all_in}{chr string indicating names of input variables for which connections are plotted, default all}

\item{bias}{logical value indicating if bias nodes and connections are plotted, not applicable for networks from \code{\link[RSNNS]{mlp}} function, default \code{TRUE}}

\item{wts_only}{logical value indicating if connections weights are returned rather than a plot, default \code{FALSE}}

\item{rel_rsc}{numeric value indicating maximum width of connection lines, default 5}

\item{circle_cex}{numeric value indicating size of nodes, default 5}

\item{node_labs}{logical value indicating if labels are plotted directly on nodes, default \code{TRUE}}

\item{var_labs}{logical value indicating if variable names are plotted next to nodes, default \code{TRUE}}

\item{x_lab}{chr string indicating names for input variables, default from model object}

\item{y_lab}{chr string indicating names for output variables, default from model object}

\item{line_stag}{numeric value that specifies distance of connection weights from nodes}

\item{cex_val}{numeric value indicating size of text labels, default 1}

\item{alpha_val}{numeric value (0-1) indicating transparency of connections, default 1}

\item{circle_col}{chr string indicating color of nodes, default \code{'lightblue'}, or two element list with first element indicating color of input nodes and second indicating color of remaining nodes}

\item{pos_col}{chr string indicating color of positive connection weights, default \code{'black'}}

\item{neg_col}{chr string indicating color of negative connection weights, default \code{'grey'}}

\item{bord_col}{chr string indicating border color around nodes, default \code{'lightblue'}}

\item{max_sp}{logical value indicating if space between nodes in each layer is maximized, default \code{FALSE}}

\item{struct}{numeric vector equal in length to the number of layers in the network.  Each number indicates the number of nodes in each layer starting with the input and ending with the output.  An arbitrary number of hidden layers can be included.}
}
\value{
A graphics object unless \code{wts_only = TRUE}, then neural network weights from \code{\link{neuralweights}}.
}
\description{
Plot a neural interpretation diagram for a neural network object
}
\details{
This function plots a neural network as a neural interpretation diagram as in Ozesmi and Ozesmi (1999). Options to plot without color-coding or shading of weights are also provided.  The default settings plot positive weights between layers as black lines and negative weights as grey lines. Line thickness is in proportion to relative magnitude of each weight. The first layer includes only input variables with nodes labelled arbitrarily as I1 through In for n input variables.  One through many hidden layers are plotted with each node in each layer labelled as H1 through Hn.  The output layer is plotted last with nodes labeled as O1 through On.  Bias nodes connected to the hidden and output layers are also shown.  Neural networks created using \code{\link[RSNNS]{mlp}} do not show bias layers.
}
\examples{
## using numeric input

wts_in <- c(13.12, 1.49, 0.16, -0.11, -0.19, -0.16, 0.56, -0.52, 0.81)
struct <- c(2, 2, 1) #two inputs, two hidden, one output

plotnet(wts_in, struct = struct)

## using nnet

library(nnet)

data(neuraldat)
set.seed(123)

mod <- nnet(Y1 ~ X1 + X2 + X3, data = neuraldat, size = 5)

plotnet(mod)

## using RSNNS, no bias layers

library(RSNNS)

x <- neuraldat[, c('X1', 'X2', 'X3')]
y <- neuraldat[, 'Y1']
mod <- mlp(x, y, size = 5)

plotnet(mod)

## using neuralnet

library(neuralnet)

mod <- neuralnet(Y1 ~ X1 + X2 + X3, data = neuraldat, hidden = 5)

plotnet(mod)

## using caret

\dontrun{
library(caret)

mod <- train(Y1 ~ X1 + X2 + X3, method = 'nnet', data = neuraldat, linout = TRUE)

plotnet(mod)
}

## a more complicated network with categorical response
AND <- c(rep(0, 7), 1)
OR <- c(0, rep(1, 7))

binary_data <- data.frame(expand.grid(c(0, 1), c(0, 1), c(0, 1)), AND, OR)

mod <- neuralnet(AND + OR ~ Var1 + Var2 + Var3, binary_data,
 hidden = c(6, 12, 8), rep = 10, err.fct = 'ce', linear.output = FALSE)

plotnet(mod)

## color input nodes by relative importance
mod <- nnet(Y1 ~ X1 + X2 + X3, data = neuraldat, size = 5)

rel_imp <- garson(mod, 'Y1', bar_plot = FALSE)$rel_imp
cols <- colorRampPalette(c('lightgreen', 'darkgreen'))(3)[rank(rel_imp)]

plotnet(mod, circle_col = list(cols, 'lightblue'))
}
\references{
Ozesmi, S.L., Ozesmi, U. 1999. An artificial neural network approach to spatial habitat modeling with interspecific interaction. Ecological Modelling. 116:15-31.
}

