% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_binned_data.R
\name{create_binned_data}
\alias{create_binned_data}
\title{Convert data from raster format to binned format}
\usage{
create_binned_data(
  raster_dir_name,
  save_prefix_name,
  bin_width,
  sampling_interval,
  start_time = NULL,
  end_time = NULL,
  files_contain = "",
  num_parallel_cores = NULL
)
}
\arguments{
\item{raster_dir_name}{A string that contains the path to a directory that
has files in raster format. These files will be combined into binned format
data.}

\item{save_prefix_name}{A string with a prefix that will be used name of file
that contains the saved binned format data.}

\item{bin_width}{A number that has the number of data samples that data will
be averaged over.}

\item{sampling_interval}{A number that has the specifies the sampling
interval between successive binned data points.}

\item{start_time}{A number that specifies the time to start binning the data.
This needs to be set to one of the start times in the raster data; i.e., if
data columns are in the format time.XXX_YYY, then the start_time must be
one of the XXX values. By default, the start_time is the first
time in the raster data.}

\item{end_time}{A number that specifies the time to end the binning of the data.
This needs to be set to one of the end times in the raster data; i.e., if
data columns are in the format time.XXX_YYY, then the start_time must be
one of the YYY values. By default, the end_time is the last
time in the raster data.}

\item{files_contain}{A string that specifies that only raster files that
contain this string should be included in the binned format data.}

\item{num_parallel_cores}{An integer specifying the number of parallel cores
to use. The default (NULL) value is to use half of the cores detected on
the system. If this value is set to a value of less than 1, then the code
will be run serially.}
}
\value{
Returns a string with the name of the file that was created which has
the data in binnned format.
}
\description{
This function takes the name of a directory that contains files in raster
format and averages the data within a specified bin width at specified
sampling interval increments to create data in binned format used for
decoding.
}
\examples{
# create binned data with 150 ms bin sizes sampled at 10 ms intervals
raster_dir_name <- file.path(
  "..", "data-raw", "raster",
  "Zhang_Desimone_7objects_raster_data_rda", ""
)

raster_dir_name <- trimws(file.path(system.file("extdata", package = "NeuroDecodeR"), 
                          "Zhang_Desimone_7object_raster_data_small_rda", " "))

\donttest{
# The code could potentially run faster by using more parallel cores
# (e.g., by not setting the num_parallel_cores argument, half the cores available
#  will be used) 
binned_file_name <- create_binned_data(raster_dir_name, 
                                      file.path(tempdir(), "ZD"), 
                                      150, 50,
                                      num_parallel_cores = 2)
}

}
