% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlsy-links.R
\docType{package}
\name{NlsyLinks-package}
\alias{NlsyLinks-package}
\alias{NlsyLinks}
\title{Utilities and kinship information for Behavior Genetics and Developmental research using the NLSY.}
\description{
Utilities and kinship information for Behavior Genetics and Developmental research using the NLSY.
Researchers and grad students interested using the \href{https://www.nlsinfo.org/}{NLSY} for Behavior Genetics and family research, please start with our 2016 article,
'\href{https://link.springer.com/article/10.1007/s10519-016-9785-3}{\emph{The NLSY Kinship Links: Using the NLSY79 and NLSY-Children Data to Conduct Genetically-Informed and Family-Oriented Research}}.
}
\note{
This package considers both Gen1 and Gen2 subjects.  "Gen1" refers to
subjects in the original NLSY79 sample
(https://www.nlsinfo.org/content/cohorts/nlsy79).  "Gen2" subjects are the
biological children of the Gen1 females -ie, those in the NLSY79 Children
and Young Adults sample (https://www.nlsinfo.org/content/cohorts/nlsy79-children).

The release version is available through \href{https://cran.r-project.org/package=NlsyLinks}{CRAN} by
running \code{install.packages('NlsyLinks')}.
The most recent development version is available through \href{https://github.com/nlsy-links/NlsyLinks}{GitHub} by
running
\code{devtools::install_github} \code{(repo = 'nlsy-links/NlsyLinks')}
(make sure \href{https://cran.r-project.org/package=devtools}{devtools} is already installed).
If you're having trouble with the package, please install the development version.  If this doesn't solve
your problem, please create a \href{https://github.com/nlsy-links/NlsyLinks/issues}{new issue}, or email Will.
}
\examples{
library(NlsyLinks) # Load the package into the current R session.
summary(Links79Pair) # Summarize the five variables.
hist(Links79Pair$R) # Display a histogram of the Relatedness values.
table(Links79Pair$R) # Create a table of the Relatedness values for the whole sample.

\dontrun{
# Install/update NlsyLinks with the release version from CRAN.
install.packages("NlsyLinks")

# Install/update NlsyLinks with the development version from GitHub
# install.packages('devtools') #Uncomment if 'devtools' isn't installed already.
devtools::install_github("nlsy-links/NlsyLinks")
}
}
\references{
This package's development was largely supported by the NIH
Grant 1R01HD65865, \href{https://taggs.hhs.gov/Detail/AwardDetail?arg_awardNum=R01HD065865&arg_ProgOfficeCode=50}{"NLSY Kinship Links: Reliable and Valid Sibling Identification"}
(PI: Joe Rodgers).  A more complete list of research articles
using NLSY Kinship Links is maintained on our \href{https://nlsy-links.github.io/NlsyLinks/articles/publications.html}{package's website}.

Rodgers, Joseph Lee, & Kohler, Hans-Peter (2005).
\href{https://pubmed.ncbi.nlm.nih.gov/15685433/}{Reformulating and simplifying the DF analysis model}.
\emph{Behavior Genetics, 35} (2), 211-217.

Rodgers, J.L., Bard, D., Johnson, A., D'Onofrio, B., & Miller, W.B. (2008).
\href{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC2712575/}{The Cross-Generational Mother-Daughter-Aunt-Niece Design: Establishing Validity of the MDAN Design with NLSY Fertility Variables.}.
\emph{Behavior Genetics, 38}, 567-578.

D'Onofrio, B.M., Van Hulle, C.A., Waldman, I.D., Rodgers, J.L., Rathouz,
P.J., & Lahey, B.B. (2007). \href{https://pubmed.ncbi.nlm.nih.gov/17984398/}{Causal inferences regarding prenatal alcohol exposure and childhood externalizing problems.}.
\emph{Archives of General Psychiatry, 64}, 1296-1304.

Rodgers, J.L. & Doughty, D. (2000).  \href{https://link.springer.com/chapter/10.1007/978-1-4615-4467-8_6}{Genetic and environmental influences on fertility expectations and outcomes using NLSY kinship data.}
In J.L. Rodgers, D. Rowe, & W.B. Miller (Eds.)
\emph{Genetic influences on fertility and sexuality.} Boston: Kluwer Academic Press.

Cleveland, H.H., Wiebe, R.P., van den Oord, E.J.C.G., & Rowe, D.C. (2000).
\href{https://pubmed.ncbi.nlm.nih.gov/10953940/}{Behavior problems among children from different family structures: The influence of genetic self-selection.}
\emph{Child Development, 71}, 733-751.

Rodgers, J.L., Rowe, D.C., & Buster, M. (1999). \href{https://pubmed.ncbi.nlm.nih.gov/10081235/}{Nature, nurture, and first sexual intercourse in the USA: Fitting behavioural genetic models to NLSY kinship data}.
\emph{Journal of Biosocial Sciences, 31}.

Rodgers, J.L., Rowe, D.C., & Li, C. (1994). \href{https://psycnet.apa.org:443/journals/dev/30/3/374/}{Beyond nature versus nurture: DF analysis of nonshared influences on problem behaviors.}
\emph{Developmental Psychology, 30}, 374-384.
}
\author{
\href{http://scholar.google.com/citations?user=ffsJTC0AAAAJ}{William Howard Beasley} (Howard Live Oak LLC, Norman)

\href{https://www.vanderbilt.edu/psychological_sciences/bio/joe-rodgers}{Joseph Lee Rodgers} (Vanderbilt University, Nashville)

\href{https://medicine.ouhsc.edu/Academic-Departments/Pediatrics/Sections/Developmental-Behavioral-Pediatrics/Faculty/david-e-bard-phd}{David Bard} (University of Oklahoma Health Sciences Center, OKC)

\href{https://scholar.google.com/citations?user=TbTNHKwAAAAJ&hl=en}{Michael D. Hunter} (Pennsylvania State University)

Patrick O'Keefe (Oregon Health and Science University)

Kelly Meredith Williams (Oklahoma City University, OKC)

\href{https://scholar.google.com/citations?user=5to21boAAAAJ}{S. Mason Garrison} (Wake Forest University)

Maintainer: S. Mason Garrison \href{mailto:garrissm@wfu.edu}{garrissm@wfu.edu}
}
\keyword{package}
