% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/links-97-pair-doc.R
\docType{data}
\name{Links97Pair}
\alias{Links97Pair}
\title{Kinship linking file for pairs of relatives in the NLSY97}
\format{
A data frame with 2,519 observations on the following 5 variables.
There is one row per unique pair of subjects, irrespective of order.
\itemize{
\item \strong{ExtendedID} Identity of the extended family of the pair; it corresponds to the HHID in the NLSY97.  See References below.
\item \strong{SubjectTag_S1} Identity of the pair's first subject.  See Details below.
\item \strong{SubjectTag_S2} Identity of the pair's second subject.  See Details below.
\item \strong{R} The pair's Relatedness coefficient.  See Details below.
\item \strong{RelationshipPath} Specifies the relationship category of the pair.  This variable is a factor, with level \code{Housemates}=1.
}
}
\source{
Information comes from the Summer 2018 release of the
\href{https://www.nlsinfo.org/content/cohorts/nlsy97}{NLSY97 sample}.
Data were extracted with the NLS Investigator
(https://www.nlsinfo.org/investigator/).
}
\description{
This dataset specifies the relatedness coefficient (ie, '\code{R}') between
subjects in the same extended family.  Each row represents a unique
relationship pair.

NOTE: Two variable names changed in November 2013. \code{Subject1Tag} and \code{Subject2Tag} became \code{SubjectTag_S1} and \code{SubjectTag_S2}.
}
\details{
The variable \code{ExtendedID} corresponds to the NLSY97 variable \verb{[SIDCODE]}
(\emph{e.g.}, \href{https://www.nlsinfo.org/investigator/pages/search.jsp#R11930.00}{R11930.00}),
which uniquely identifies a \emph{household} that may contain multiple NLSY97 subjects.

The variables \code{SubjectTag_S1} and \code{SubjectTag_S2} uniquely identify
subjects.  It corresponds to the NLSY97 variable \verb{[PUBID]},
(\emph{e.g.}, \href{https://www.nlsinfo.org/investigator/pages/search.jsp#R00001.00}{R00001.00}).

The \code{RelationshipPath} variable is not useful with this dataset,
but is included to be consistent with the \link{Links97Pair} dataset.

An extended family with \eqn{k} subjects will have
\eqn{k}(\eqn{k}-1)/2 rows.  Typically, Subject1 is older while Subject2 is
younger.

MZ twins have \emph{R}=1.  DZ twins and full-siblings have \emph{R}=.5.
Half-siblings have \emph{R}=.25. Typical first cousins have \emph{R}=.125.
Unrelated subjects have \emph{R}=0 (this occasionally happens for
\code{Housemates}, but never for the other paths).
Other \emph{R} coefficients are possible.

There are several other uncommon possibilities, such as half-cousins (\emph{R}=.0625) and
ambiguous aunt-nieces (\emph{R}=.125, which is an average of 1/4 and 0/4).
The variable coding for genetic relatedness,\code{R}, in \code{\link{Links97Pair}} contains
only the common values of \emph{R} whose groups are likely to have stable estimates.
However the variable \code{RFull} in \code{\link{Links97PairExpanded}} contains all \emph{R} values.
We strongly recommend using \code{R} in this \link[base:data.frame]{base::data.frame}.  Move to
\code{RFull} (or some combination) only if you have a good reason, and are willing
to carefully monitor a variety of validity checks.  Some of these
excluded groups are too small to be estimated reliably.
}
\examples{
library(NlsyLinks) # Load the package into the current R session.
summary(Links97Pair) # Summarize the five variables.
hist(Links97Pair$R) # Display a histogram of the Relatedness coefficients.
table(Links97Pair$R) # Create a table of the Relatedness coefficients for the whole sample.

# Create a dataset of only monozygotic sibs.
mz_sibs <- subset(Links97Pair, R > .9)
summary(mz_sibs) # Create a table MZ sibs.

}
\references{
For more information on \emph{R} (\emph{ie}, the Relatedness coefficient), please see
Rodgers, Joseph Lee, & Kohler, Hans-Peter (2005).
\href{https://pubmed.ncbi.nlm.nih.gov/15685433/}{Reformulating and simplifying the DF analysis model.}
\emph{Behavior Genetics, 35} (2), 211-217.
}
\seealso{
The \code{LinksPair97} dataset contains columns necessary for a
basic BG analysis.  The \link{Links97PairExpanded} dataset contains
further information that might be useful in more complicated BG analyses.

A tutorial that produces a similar dataset is
http://www.nlsinfo.org/childya/nlsdocs/tutorials/linking_mothers_and_children/linking_mothers_and_children_tutorial.html.
It provides examples in SAS, SPSS, and STATA.

The current dataset (ie, \code{Links97Pair}) can be saved as a CSV file
(comma-separated file) and imported into in other programs and languages.
In the R console, type the following two lines of code:

\code{library(NlsyLinks)}
\code{write.csv(Links97Pair, "C:/BGDirectory/Links97Pair.csv")}

where \code{"C:/BGDirectory/"} is replaced by your preferred directory.
Remember to use forward slashes instead of backslashes; for instance, the
path \code{"C:\\BGDirectory\\Links97Pair.csv"} can be misinterpreted.

\strong{Download CSV}
If you're using the NlsyLinks package in R, the dataset is automatically available.
To use it in a different environment,
\href{https://github.com/nlsy-links/NlsyLinks/blob/master/outside-data/nlsy-97/links-2017-97.csv?raw=true}{download the csv},
which is readable by all statistical software.
\href{https://github.com/nlsy-links/NlsyLinks/blob/master/outside-data/nlsy-97/links-metadata-2017-97.yml}{links-metadata-2017-97.yml}
documents the dataset version information.
}
\author{
Will Beasley
}
\keyword{datasets}
