% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set-misc.R
\name{setequal_na}
\alias{setequal_na}
\title{Check if two vectors have the same elements}
\usage{
setequal_na(x, y, na.rm = FALSE)
}
\arguments{
\item{x, y}{Vectors (of the same mode) containing a sequence of items.}

\item{na.rm}{Boolean value indicating whether
\code{NA} should be omitted or not.}
}
\value{
A logical scalar that states the result.
}
\description{
Wrapper around \code{\link[base:sets]{setequal}} that adds extra parameter
  \code{na.rm}.
}
\examples{
setequal_na(c(2, 1, 3), c(1, 2, 3))
# returns TRUE

setequal_na(c(1, NA, 3), c(3, NA, 1), na.rm = TRUE)
# returns TRUE

setequal_na(c(NA, NA), c(NA), na.rm = TRUE)
# returns TRUE

setequal_na(c(NA, NA), c(NA))
# returns TRUE

setequal_na(c(1, 2, 3), c(1, 2, 3, NA))
# returns FALSE

}
