% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RNN.R
\name{RNN}
\alias{RNN}
\alias{RNN.default}
\alias{RNN.formula}
\title{Reduced Nearest Neighbors}
\usage{
\method{RNN}{formula}(formula, data, ...)

\method{RNN}{default}(x, classColumn = ncol(x), ...)
}
\arguments{
\item{formula}{A formula describing the classification variable and the attributes to be used.}

\item{data, x}{Data frame containing the tranining dataset to be filtered.}

\item{...}{Optional parameters to be passed to other methods.}

\item{classColumn}{positive integer indicating the column which contains the
(factor of) classes. By default, the last column is considered.}
}
\value{
An object of class \code{filter}, which is a list with seven components:
\itemize{
   \item \code{cleanData} is a data frame containing the filtered dataset.
   \item \code{remIdx} is a vector of integers indicating the indexes for
   removed instances (i.e. their row number with respect to the original data frame).
   \item \code{repIdx} is a vector of integers indicating the indexes for
   repaired/relabelled instances (i.e. their row number with respect to the original data frame).
   \item \code{repLab} is a factor containing the new labels for repaired instances.
   \item \code{parameters} is a list containing the argument values.
   \item \code{call} contains the original call to the filter.
   \item \code{extraInf} is a character that includes additional interesting
   information not covered by previous items.
}
}
\description{
Similarity-based method designed to select the most relevant instances for
subsequent classification with a \emph{nearest neighbor} rule. For more
information, see 'Details' and 'References' sections.
}
\details{
\code{RNN} is an extension of \code{\link{CNN}}. The latter provides a 'consistent subset', i.e. it is enough
for correctly classifying the rest of instances by means of 1-NN. Then, in the given order, \code{RNN} removes instances
as long as the remaining do not loss the property of being a 'consistent subset'.

Although \code{RNN} is not strictly a class noise filter, it is included here for completeness, since
the origins of noise filters are connected with instance selection algorithms.
}
\examples{
# Next example is not run in order to save time
\dontrun{
data(iris)
out <- RNN(Species~., data = iris)
print(out)
identical(out$cleanData, iris[setdiff(1:nrow(iris),out$remIdx),])
}
}
\references{
Gates G.W. (1972): The Reduced Nearest Neighbour Rule. \emph{IEEE Transactions on Information Theory}, 18:3  431-433.
}
\seealso{
\code{\link{CNN}}
}

