% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NonProbEst.R
\name{jackknife_variance}
\alias{jackknife_variance}
\title{Calculates Jackknife variance with reweighting}
\usage{
jackknife_variance(
  estimated_vars,
  convenience_sample,
  reference_sample,
  covariates,
  N = NULL,
  algorithm = "glm",
  smooth = FALSE,
  proc = NULL,
  trControl = trainControl(classProbs = TRUE),
  weighting.func = "sc",
  g = 5,
  calib = FALSE,
  calib_vars = NULL,
  totals = NULL,
  args.calib = NULL,
  ...
)
}
\arguments{
\item{estimated_vars}{A string vector specifying the variables for which the estimators' variance are to be estimated.}

\item{convenience_sample}{Data frame containing the non-probabilistic sample.}

\item{reference_sample}{Data frame containing the probabilistic sample.}

\item{covariates}{String vector specifying the common variables to use for training.}

\item{N}{Integer indicating the population size. Optional.}

\item{algorithm}{A string specifying which classification or regression model to use (same as caret's method). By default, its value is "glm" (logistic regression).}

\item{smooth}{A logical value; if TRUE, propensity estimates pi_i are smoothed applying the formula (1000*pi_i + 0.5)/1001}

\item{proc}{A string or vector of strings specifying if any of the data preprocessing techniques available in \link[caret]{train} function from `caret` package should be applied to data prior to the propensity estimation. By default, its value is NULL and no preprocessing is applied.}

\item{trControl}{A trainControl specifying the computational nuances of the \link[caret]{train} function.}

\item{weighting.func}{A string specifying which function should be used to compute weights from propensity scores. Available functions are the following: \itemize{ \item \code{sc} calls \link{sc_weights}. \item \code{valliant} calls \link{valliant_weights}. \item \code{lee} calls \link{lee_weights}. \item \code{vd} calls \link{vd_weights}. }}

\item{g}{If \code{weighting.func = "lee"} or \code{weighting.func = "vd"}, this element specifies the number of strata to use; by default, its value is 5.}

\item{calib}{A logical value; if TRUE, PSA weights are used as initial weights for calibration. By default, its value is FALSE.}

\item{calib_vars}{A string or vector of strings specifying the variables to be used for calibration. By default, its value is NULL.}

\item{totals}{A vector containing population totals for each column (class) of the calibration variables matrix. Ignored if \code{calib} is set to FALSE.}

\item{args.calib}{A list containing further arguments to be passed to the \link{calib_weights} function.}

\item{...}{Further parameters to be passed to the \link[caret]{train} function.}
}
\value{
The resulting variance.
}
\description{
Calculates the variance of a given estimator by Leave-One-Out Jackknife (Quenouille, 1956) with reweighting in each iteration.
}
\details{
The estimation of the variance requires a recalculation of the estimates in each iteration which might involve weighting adjustments, leading to an increase in computation time. It is expected that the estimated variance captures the weighting adjustments' variability and the estimator's variability.
}
\examples{
\donttest{
#A simple example without calibration and default parameters
covariates = c("education_primaria", "education_secundaria", "education_terciaria")
jackknife_variance("vote_pens",sampleNP, sampleP, covariates)

#An example with linear calibration and default parameters
covariates = c("education_primaria", "education_secundaria", "education_terciaria")
calib_vars = c("age", "sex")
totals = c(2544377, 24284)

jackknife_variance("vote_pens",sampleNP, sampleP, covariates,
calib = T, calib_vars, totals, args.calib = list(method = "linear"))
}
}
\references{
Quenouille, M. H. (1956). \emph{Notes on bias in estimation.} Biometrika, 43(3/4), 353-360.
}
