% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cuestas_Ordonez_2014_unit_root.R
\name{Cuestas_Ordonez_2014_unit_root}
\alias{Cuestas_Ordonez_2014_unit_root}
\title{Cuestas and Ordonez(2014) nonlinear unit root test function}
\usage{
Cuestas_Ordonez_2014_unit_root(x, max_lags)
}
\arguments{
\item{x}{series name,}

\item{max_lags}{maximum lag selected lag is determined by AIC}
}
\value{
"model" Estimated model

"Selected lag" the lag order

"Test Statistic" the value of the test statistic
}
\description{
This function allows you to make Cuestas and Ordonez(2014) nonlinear unit root test
}
\examples{

x <- rnorm(1000)
Cuestas_Ordonez_2014_unit_root(x, max_lags = 6)

y <- cumsum(rnorm(1000))
Cuestas_Ordonez_2014_unit_root(y, max_lags = 8)

data(IBM)
Cuestas_Ordonez_2014_unit_root(IBM, max_lags = 20)


}
\references{
Cuestas, J. C., & Ordóñez, J. (2014). Smooth transitions, asymmetric adjustment and unit roots. Applied Economics Letters, 21(14), 969-972.


Burak Guris, R Uygulamalı Dogrusal Olmayan Zaman Serileri Analizi, DER Yayinevi, 2020.
}
\keyword{nonlinear}
\keyword{root}
\keyword{test}
\keyword{unit}
