% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grass_age.R
\name{calc_grass_age}
\alias{calc_grass_age}
\title{Calculate the average age of the grass}
\usage{
calc_grass_age(ID, B_LU_BRP)
}
\arguments{
\item{ID}{(numeric) The ID of the field}

\item{B_LU_BRP}{(numeric) The crop code (gewascode) from the BRP}
}
\value{
The age of the grassland within a crop rotation plan. A numeric value.
}
\description{
This function calculates the average age of the grass
}
\details{
The function assumes that the order of crop codes are descending, so the latest year is on top.
}
\examples{
calc_grass_age(ID = rep(1,5), B_LU_BRP = c(1091,265,256,256,1091))
calc_grass_age(ID = rep(1,5), B_LU_BRP = c(265,265,265,265,1091))

}
