% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Compass.r
\name{opiInitialise_for_Compass}
\alias{opiInitialise_for_Compass}
\title{Implementation of opiInitialise for the ImoVifa machine.}
\arguments{
\item{ip}{IP address on which server is listening as a string}

\item{port}{Port number on which server is listening}

\item{...}{Could be used for fake compass, simulations, etc}
}
\value{
A list with elements:
\itemize{
\item \code{err} NULL if successful, not otherwise.
\item \code{prl} A pair giving the (x,y) in degrees of the Preferred Retinal
Locus detected in the initial alignment.
\item \code{onh} a pair giving the (x,y) in degrees of the ONH as selected by
the user.
\item \code{image} raw bytes being the JPEG compressed infra-red image acquired
during alignment.
}
}
\description{
This is for internal use only. Use \code{\link[=opiInitialise]{opiInitialise()}} with
these Arguments and you will get the Value back.
}
\details{
Warning: this returns a list, not a single error code.
}
\examples{
\dontrun{
  # Set up the Compass
  chooseOpi("Compass")
  result <- opiInitialize(ip = "192.168.1.7", port = 44965)
  if (is.null(result$err))
    print(result$prl)
}
}
