/*
 * Decompiled with CFR 0.152.
 */
package org.andwellness.xml.datagenerator.generator;

import org.andwellness.xml.datagenerator.generator.DownloadJSONGeneratorType;
import org.andwellness.xml.datagenerator.generator.JSONGeneratorType;
import org.andwellness.xml.datagenerator.generator.UploadJSONGeneratorType;

public class JSONGeneratorTypeFactory {
    private JSONGeneratorTypeFactory() {
    }

    public static JSONGeneratorType getGenerator(String generatorType) {
        if (generatorType == null) {
            throw new IllegalArgumentException("cannot create a JSONGeneratorType for a missing generator type.");
        }
        if (generatorType.equals("up") || generatorType.equals("upload")) {
            return new UploadJSONGeneratorType();
        }
        if (generatorType.equals("down") || generatorType.equals("download")) {
            return new DownloadJSONGeneratorType();
        }
        throw new IllegalArgumentException("Cannot create a JSONGeneratorType for type " + generatorType);
    }
}

