% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Olink_heatmap.R
\name{olink_heatmap_plot}
\alias{olink_heatmap_plot}
\title{Function to plot a heatmap of the NPX data}
\usage{
olink_heatmap_plot(
  df,
  variable_row_list = NULL,
  variable_col_list = NULL,
  center_scale = TRUE,
  cluster_rows = TRUE,
  cluster_cols = TRUE,
  show_rownames = TRUE,
  show_colnames = TRUE,
  annotation_legend = TRUE,
  fontsize = 10,
  na_col = "black",
  ...
)
}
\arguments{
\item{df}{Data frame in long format with SampleID, NPX, OlinkID, Assay and columns of choice for annotations.}

\item{variable_row_list}{Columns in \code{df} to be annotated for rows in the heatmap.}

\item{variable_col_list}{Columns in \code{df} to be annotated for columns in the heatmap.}

\item{center_scale}{Logical. If data should be centered and scaled across assays (default \code{TRUE}).}

\item{cluster_rows}{Logical. Determining if rows should be clustered (default \code{TRUE}).}

\item{cluster_cols}{Logical. Determining if columns should be clustered (default \code{TRUE}).}

\item{show_rownames}{Logical. Determining if row names are shown (default \code{TRUE}).}

\item{show_colnames}{Logical. Determining if column names are shown (default \code{TRUE}).}

\item{annotation_legend}{Logical. Determining if legend for annotations should be shown (default \code{TRUE}).}

\item{fontsize}{Fontsize (default 10)}

\item{na_col}{Color of cells with \code{NA} (default black)}

\item{...}{Additional arguments used in \code{pheatmap::pheatmap}}
}
\value{
An object of class \code{ggplot}, generated from the \code{gtable} returned by \code{pheatmap::pheatmap}.
}
\description{
Generates a heatmap using \code{pheatmap::pheatmap} of all samples from NPX data.
}
\details{
The values are by default scaled across and centered in the heatmap. Columns
and rows are by default sorted by by dendrogram.
Unique sample names are required.
}
\examples{
\donttest{
library(dplyr)
npx_data <- npx_data1 \%>\%
      filter(!stringr::str_detect(SampleID,'CONT'))

#Heatmap
olink_heatmap_plot(df=npx_data)

#Heatmap with annotation
olink_heatmap_plot(df=npx_data, variable_row_list = c('Time','Site'))

#Heatmap with calls from pheatmap
olink_heatmap_plot(df=npx_data, cutree_rows = 3)

}

}
\keyword{Heatmap}
\keyword{NPX}
