% Generated by roxygen2 (4.0.0): do not edit by hand
\name{okriging}
\alias{okriging}
\title{Run omic kriging on a set of correlation matrices and a given phenotype.}
\usage{
okriging(idtest, idtrain = NULL, corlist, H2vec, pheno, phenoname,
  Xcova = NULL)
}
\arguments{
\item{corlist}{A list of correlation matrices used in Kriging. rownames and colnames
of cor should be IID list and include idtest and idtrain.}

\item{H2vec}{has weights for each RM relatednes matrix}

\item{idtest}{A vector of sample IDs which constitute the test set.}

\item{idtrain}{A vector of sample IDs which constitute the training set.}

\item{pheno}{A data frame with rownames set as sample IDs and a column containing phenotype data.}

\item{phenoname}{The name of the column in pheno which contains phenotype data to test.}

\item{Xcova}{Data frame of covariates with rownames() set to sample IDs.}
}
\value{
A dataframe with three columns: sample ID, observed phenotype Ytest, and predicted phenotype Ypred
}
\description{
Universal kriging formula:
  lambda' = ( c + X m )' iSig
  m' = ( x - X' iSig c )' ( X' iSig X )^-1
  m' = ( t(x) - c' iSig X ) ( X' iSig X )^-1
  lambda' = (c' + m' X) iSig
  x: #covariates x ntest
  X: ntrain x #cov
  c: ntrain x ntest
}
\examples{
## load phenotype data used in vignette
  phenotypeFile <- system.file(package = "OmicKriging",
                               "doc/vignette_data/ig_pheno.txt")
  phenotypeData <- load_sample_data(phenotypeFile, 'igrowth')
  ## load GRM used in vignette
  binaryFile <- system.file(package = "OmicKriging",
                            "doc/vignette_data/ig_genotypes.grm.bin")
  binaryFileBase <- substr(binaryFile,1, nchar(binaryFile) - 4)
  grmMat <- read_GRMBin(binaryFileBase)
  ## pull a subset of samples to train the model
  trainingSet <- phenotypeData$IID[11:nrow(phenotypeData)]
  ## predict phenotype in the remaining samples
  testSet <- phenotypeData$IID[1:10]
  ## compute preducted values for a subset of samples
  prediction <- okriging(idtest=testSet,
                         idtrain=trainingSet,
                         corlist=list(grmMat),
                         H2vec=c(1),
                         pheno=phenotypeData,
                         phenoname='igrowth')
  ## summarize the prediction! (Note, that this is a toy example)
  summary(lm(prediction$Ypred ~ prediction$Ytest))
}
\references{
Cressie 1993 Statistics for Spatial Data p.154
}
\keyword{prediction}

