% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OmicsPLS_o2m.R
\name{o2m2}
\alias{o2m2}
\title{Perform O2-PLS with two-way orthogonal corrections}
\usage{
o2m2(X, Y, n, nx, ny, stripped = FALSE, tol = 1e-10,
  max_iterations = 100)
}
\arguments{
\item{X}{Numeric matrix. Vectors will be coerced to matrix with \code{as.matrix} (if this is possible)}

\item{Y}{Numeric matrix. Vectors will be coerced to matrix with \code{as.matrix} (if this is possible)}

\item{n}{Integer. Number of joint PLS components. Must be positive!}

\item{nx}{Integer. Number of orthogonal components in \eqn{X}. Negative values are interpreted as 0}

\item{ny}{Integer. Number of orthogonal components in \eqn{Y}. Negative values are interpreted as 0}

\item{stripped}{Logical. Use the stripped version of o2m (usually when cross-validating)?}

\item{tol}{double. Threshold for power method iteration}

\item{max_iterations}{Integer, Maximum number of iterations for power method}
}
\value{
A list containing
   \item{Tt}{Joint \eqn{X} scores}
   \item{W.}{Joint \eqn{X} loadings}
   \item{U}{Joint \eqn{Y} scores}
   \item{C.}{Joint \eqn{Y} loadings}
   \item{E}{Residuals in \eqn{X}}
   \item{Ff}{Residuals in \eqn{Y}}
   \item{T_Yosc}{Orthogonal \eqn{X} scores}
   \item{P_Yosc.}{Orthogonal \eqn{X} loadings}
   \item{W_Yosc}{Orthogonal \eqn{X} weights}
   \item{U_Xosc}{Orthogonal \eqn{Y} scores}
   \item{P_Xosc.}{Orthogonal \eqn{Y} loadings}
   \item{C_Xosc}{Orthogonal \eqn{Y} weights}
   \item{B_U}{Regression coefficient in \code{Tt} ~ \code{U}}
   \item{B_T.}{Regression coefficient in \code{U} ~ \code{Tt}}
   \item{H_TU}{Residuals in \code{Tt} in \code{Tt} ~ \code{U}}
   \item{H_UT}{Residuals in \code{U} in \code{U} ~ \code{Tt}}
   \item{X_hat}{Prediction of \eqn{X} with \eqn{Y}}
   \item{Y_hat}{Prediction of \eqn{Y} with \eqn{X}}
   \item{R2X}{Variation (measured with \code{\link{ssq}}) of the modeled part in \eqn{X} (defined by joint + orthogonal variation) as proportion of variation in \eqn{X}}
   \item{R2Y}{Variation (measured with \code{\link{ssq}}) of the modeled part in \eqn{Y} (defined by joint + orthogonal variation) as proportion of variation in \eqn{Y}}
   \item{R2Xcorr}{Variation (measured with \code{\link{ssq}}) of the joint part in \eqn{X} as proportion of variation in \eqn{X}}
   \item{R2Ycorr}{Variation (measured with \code{\link{ssq}}) of the joint part in \eqn{Y} as proportion of variation in \eqn{Y}}
   \item{R2X_YO}{Variation (measured with \code{\link{ssq}}) of the orthogonal part in \eqn{X} as proportion of variation in \eqn{X}}
   \item{R2Y_XO}{Variation (measured with \code{\link{ssq}}) of the orthogonal part in \eqn{Y} as proportion of variation in \eqn{Y}}
   \item{R2Xhat}{Variation (measured with \code{\link{ssq}}) of the predicted \eqn{X} as proportion of variation in \eqn{X}}
   \item{R2Yhat}{Variation (measured with \code{\link{ssq}}) of the predicted \eqn{Y} as proportion of variation in \eqn{Y}}
}
\description{
NOTE THAT THIS FUNCTION DOES NOT CENTER NOR SCALES THE MATRICES! Any normalization you will have to do yourself. It is best practice to at least center the variables though.
}
\details{
If both \code{nx} and \code{ny} are zero, \code{o2m2} is equivalent to PLS2 with orthonormal loadings.
This is a `slower' implementation of O2PLS, and is using \code{\link{svd}}. For cross-validation purposes, consider using \code{\link{o2m_stripped}}.
Note that in this function, a power-method based approach is used when the data dimensionality is larger than the sample size. E.g. for genomic data the covariance matrix might be too memory expensive.
}
\examples{
# This takes a couple of seconds on an intel i5
system.time(
             o2m2(matrix(rnorm(50*2000),50),matrix(rnorm(50*2000),50),1,0,0)
)

# This however takes 10 times as much...
# system.time(
#              o2m(matrix(rnorm(50*2000),50),matrix(rnorm(50*2000),50),1,0,0,
#              p_thresh = 1e4,q_thresh = 1e4)  # makes sure power method is not used
# )

}
\seealso{
\code{\link{o2m}}, \code{\link{ssq}}, \code{\link{summary.o2m}}
}
\keyword{internal}
