% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DFanalysis.R
\name{DFanalysis}
\alias{DFanalysis}
\title{DFanalysis}
\usage{
DFanalysis(
  data = NULL,
  proband,
  sibling,
  Rs,
  Ds = NULL,
  RK = T,
  robust = T,
  DE = T,
  betasonly = F,
  typicalSE = F
)
}
\arguments{
\item{data}{A dataframe. This is not necessary as the variables can be passed directly via the other arguments.}

\item{proband}{Called "proband" for historical reasons this is the variable on the left hand side of the regression.}

\item{sibling}{The right hand side version of proband. This would be the matched sibling scores.}

\item{Rs}{This is the vector of relatedness coefficients}

\item{Ds}{A vector of dominance coefficients. 1 for MZ twins, .25 for DZ twins and full siblings. The default is null, and no value should be provided if using the ACE model. This should only have a non-null value when fitting an ADE model. There is an RK version of this model, however it is not based on published work. The RK version uses double entered (and mean centered) data in order to drop the intercept term and the extraneous regression coefficient (both of which can be constrained to 0 when the phenotypic mean is 0). Initial simulations suggest that this formulation provides accurate parameter estimates, however the original formulation can be used by simply setting RK=F. It is assumed that, if RK=T, that DE=T (i.e., do NOT double enter data prior to analysis if using the ADE model).}

\item{RK}{Use the Rodgers and Kohler simplified version of the DF model (recommended). Data should not be double entered prior to analysis.}

\item{robust}{Use the Kohler and Rodgers robust standard errors (recommeneded when using double entered data)}

\item{DE}{Will the data need to be double entered?}

\item{betasonly}{If TRUE only the beta weights from the regression analysis will be returned.}

\item{typicalSE}{Should the typical regression standard errors be used? Default is false.}
}
\value{
The results from MyLM
}
\description{
There are three possible models to be fit. The default is the Rodgers and Kohler formulation of the DF model (Rodgers & Kohler, 2005). The non-default (if RK=F), is to fit the original DeFries-Fulker model. The third option is only used when dominance coefficients are provided, and is based on the formulation by Waller (Waller 1994).
}
\examples{
TwinData<-DFSimulated(2000,2000,.3,.3)
p<-TwinData[,1]
s<-TwinData[,2]
r<-TwinData[,3]
DFanalysis(data=NULL, p,s,r)
}
