% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/databaseCharacteristics.R
\name{databaseCharacteristics}
\alias{databaseCharacteristics}
\title{Summarise Database Characteristics for OMOP CDM}
\usage{
databaseCharacteristics(
  cdm,
  omopTableName = c("person", "observation_period", "visit_occurrence",
    "condition_occurrence", "drug_exposure", "procedure_occurrence", "device_exposure",
    "measurement", "observation", "death"),
  sex = FALSE,
  ageGroup = NULL,
  dateRange = NULL,
  interval = "overall",
  conceptIdCount = FALSE,
  ...
)
}
\arguments{
\item{cdm}{A \code{cdm_reference} object representing the Common Data Model (CDM) reference.}

\item{omopTableName}{A character vector specifying the OMOP tables from the CDM to include in the analysis.
If "person" is present, it will only be used for missing value summarisation.}

\item{sex}{Logical; whether to stratify results by sex (\code{TRUE}) or not (\code{FALSE}).}

\item{ageGroup}{A list of age groups to stratify the results by. Each element represents a specific age range.}

\item{dateRange}{A vector of two dates defining the desired study period.
Only the \code{start_date} column of the OMOP table is checked to ensure it falls within this range.
If \code{dateRange} is \code{NULL}, no restriction is applied.}

\item{interval}{Time interval to stratify by. It can either be "years", "quarters", "months" or "overall".}

\item{conceptIdCount}{Logical; whether to summarise concept ID counts (\code{TRUE}) or not (\code{FALSE}).}

\item{...}{additional arguments passed to the OmopSketch functions that are used internally.}
}
\value{
A \code{summarised_result} object containing the results of the characterisation.
}
\description{
Summarise Database Characteristics for OMOP CDM
}
\examples{
\donttest{
cdm <- mockOmopSketch(numberIndividuals = 100)

result <- databaseCharacteristics(cdm)

PatientProfiles::mockDisconnect(cdm)
}
}
