% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotInObservation.R
\name{plotInObservation}
\alias{plotInObservation}
\title{Create a ggplot2 plot from the output of summariseInObservation().}
\usage{
plotInObservation(result, facet = NULL, colour = NULL)
}
\arguments{
\item{result}{A summarised_result object (output of summariseInObservation).}

\item{facet}{Columns to face by. Formula format can be provided. See possible
columns to face by with: \code{visOmopResults::tidyColumns()}.}

\item{colour}{Columns to colour by. See possible columns to colour by with:
\code{visOmopResults::tidyColumns()}.}
}
\value{
A ggplot showing the table counts
}
\description{
Create a ggplot2 plot from the output of summariseInObservation().
}
\examples{
\donttest{
library(dplyr)

cdm <- mockOmopSketch()

result <- summariseInObservation(
  observationPeriod = cdm$observation_period,
  output = c("person-days","record"),
  ageGroup = list("<=40" = c(0, 40), ">40" = c(41, Inf)),
  sex = TRUE
)

result |>
  filter(variable_name == "Number person-days") |>
  plotInObservation(facet = "sex", colour = "age_group")

PatientProfiles::mockDisconnect(cdm)
}
}
