# IncidencePrevalence shiny

    Code
      cat(ui, sep = "\n")
    Output
      # Generated by OmopViewer 0.1.0
      # Be careful editing this file
      
      ui <- bslib::page_navbar(
        title = shiny::tags$span(
          shiny::tags$img(
            src = "ohdsi_logo.svg",
            width = "auto",
            height = "46px",
            class = "me-3",
            alt = "logo"
          ),
          ""
        ),
        bslib::nav_panel(
          title = "Background",
          icon = shiny::icon("disease"),
          OmopViewer::cardFromMd("background.md")
        ),
        bslib::nav_panel(
          title = "Summary",
          icon = shiny::icon("file-alt"),
          OmopViewer::cardSummary(data)
        ),
        bslib::nav_panel(
          title = "Incidence",
          icon = shiny::icon("chart-line"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "Settings",
                  shiny::selectizeInput(
                    inputId = "incidence_settings_analysis_outcome_washout",
                    label = "Analysis outcome washout",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_settings_analysis_repeated_events",
                    label = "Analysis repeated events",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_settings_analysis_interval",
                    label = "Analysis interval",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_settings_analysis_complete_database_intervals",
                    label = "Analysis complete database intervals",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_settings_denominator_age_group",
                    label = "Denominator age group",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_settings_denominator_sex",
                    label = "Denominator sex",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_settings_denominator_days_prior_observation",
                    label = "Denominator days prior observation",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_settings_denominator_start_date",
                    label = "Denominator start date",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_settings_denominator_end_date",
                    label = "Denominator end date",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_settings_denominator_time_at_risk",
                    label = "Denominator time at risk",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_settings_denominator_target_cohort_name",
                    label = "Denominator target cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_settings_outcome_cohort_name",
                    label = "Outcome cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "incidence_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_grouping_denominator_cohort_name",
                    label = "Denominator cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_grouping_incidence_start_date",
                    label = "Incidence start date",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_grouping_incidence_end_date",
                    label = "Incidence end date",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "incidence_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "incidence_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "incidence_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "incidence_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "incidence_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("incidence_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table incidence",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "incidence_gt_18_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "incidence_gt_18_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      sortable::bucket_list(
                        header = NULL,
                        sortable::add_rank_list(
                          text = "none",
                          labels = c("cdm_name", "denominator_cohort_name", "incidence_start_date", "incidence_end_date", "analysis_outcome_washout", "analysis_repeated_events", "analysis_interval", "analysis_complete_database_intervals", "denominator_age_group", "denominator_sex", "denominator_days_prior_observation", "denominator_start_date", "denominator_end_date", "denominator_time_at_risk", "denominator_target_cohort_name", "outcome_cohort_name", "variable_name", "variable_level"),
                          input_id = "incidence_gt_18_none"
                        ),
                        sortable::add_rank_list(
                          text = "header",
                          labels = "estimate_name",
                          input_id = "incidence_gt_18_header"
                        ),
                        sortable::add_rank_list(
                          text = "groupColumn",
                          labels = character(),
                          input_id = "incidence_gt_18_groupColumn"
                        ),
                        sortable::add_rank_list(
                          text = "hide",
                          labels = character(),
                          input_id = "incidence_gt_18_hide"
                        )
                      ),
                      position = "right"
                    ),
                    gt::gt_output("incidence_gt_18")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Plot incidence",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::numericInput(
                        inputId = "incidence_ggplot2_19_download_width",
                        label = "Width",
                        value = 15
                      ),
                      shiny::numericInput(
                        inputId = "incidence_ggplot2_19_download_height",
                        label = "Height",
                        value = 10
                      ),
                      shiny::selectizeInput(
                        inputId = "incidence_ggplot2_19_download_units",
                        label = "Units",
                        selected = "cm",
                        choices = c("px", "cm", "inch"),
                        multiple = FALSE
                      ),
                      shiny::numericInput(
                        inputId = "incidence_ggplot2_19_download_dpi",
                        label = "dpi",
                        value = 300
                      ),
                      shiny::downloadButton(outputId = "incidence_ggplot2_19_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "incidence_ggplot2_19_x",
                        label = "x",
                        selected = "incidence_start_date",
                        multiple = FALSE,
                        choices = c("cdm_name", "denominator_cohort_name", "incidence_start_date", "incidence_end_date", "analysis_outcome_washout", "analysis_repeated_events", "analysis_interval", "analysis_complete_database_intervals", "denominator_age_group", "denominator_sex", "denominator_days_prior_observation", "denominator_start_date", "denominator_end_date", "denominator_time_at_risk", "denominator_target_cohort_name", "outcome_cohort_name", "variable_name", "variable_level", "estimate_name"),
                        options = list(plugins = "remove_button")
                      ),
                      shiny::checkboxInput(
                        inputId = "incidence_ggplot2_19_ribbon",
                        label = "ribbon",
                        value = c(FALSE)
                      ),
                      shiny::selectizeInput(
                        inputId = "incidence_ggplot2_19_facet",
                        label = "facet",
                        selected = NULL,
                        multiple = TRUE,
                        choices = c("cdm_name", "denominator_cohort_name", "incidence_start_date", "incidence_end_date", "analysis_outcome_washout", "analysis_repeated_events", "analysis_interval", "analysis_complete_database_intervals", "denominator_age_group", "denominator_sex", "denominator_days_prior_observation", "denominator_start_date", "denominator_end_date", "denominator_time_at_risk", "denominator_target_cohort_name", "outcome_cohort_name", "variable_name", "variable_level", "estimate_name"),
                        options = list(plugins = "remove_button")
                      ),
                      shiny::selectizeInput(
                        inputId = "incidence_ggplot2_19_colour",
                        label = "colour",
                        selected = NULL,
                        multiple = TRUE,
                        choices = c("cdm_name", "denominator_cohort_name", "incidence_start_date", "incidence_end_date", "analysis_outcome_washout", "analysis_repeated_events", "analysis_interval", "analysis_complete_database_intervals", "denominator_age_group", "denominator_sex", "denominator_days_prior_observation", "denominator_start_date", "denominator_end_date", "denominator_time_at_risk", "denominator_target_cohort_name", "outcome_cohort_name", "variable_name", "variable_level", "estimate_name"),
                        options = list(plugins = "remove_button")
                      ),
                      position = "right"
                    ),
                    shiny::plotOutput("incidence_ggplot2_19")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_panel(
          title = "Incidence attrition",
          icon = shiny::icon("layer-group"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "Settings",
                  shiny::selectizeInput(
                    inputId = "incidence_attrition_settings_analysis_outcome_washout",
                    label = "Analysis outcome washout",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_attrition_settings_analysis_repeated_events",
                    label = "Analysis repeated events",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_attrition_settings_analysis_interval",
                    label = "Analysis interval",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_attrition_settings_analysis_complete_database_intervals",
                    label = "Analysis complete database intervals",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_attrition_settings_denominator_age_group",
                    label = "Denominator age group",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_attrition_settings_denominator_sex",
                    label = "Denominator sex",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_attrition_settings_denominator_days_prior_observation",
                    label = "Denominator days prior observation",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_attrition_settings_denominator_start_date",
                    label = "Denominator start date",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_attrition_settings_denominator_end_date",
                    label = "Denominator end date",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_attrition_settings_denominator_time_at_risk",
                    label = "Denominator time at risk",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_attrition_settings_denominator_target_cohort_name",
                    label = "Denominator target cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_attrition_settings_outcome_cohort_name",
                    label = "Outcome cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "incidence_attrition_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_attrition_grouping_denominator_cohort_name",
                    label = "Denominator cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_attrition_grouping_reason",
                    label = "Reason",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_attrition_grouping_reason_id",
                    label = "Reason id",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "incidence_attrition_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "incidence_attrition_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "incidence_attrition_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "incidence_attrition_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "incidence_attrition_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("incidence_attrition_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table incidence attrition",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "incidence_attrition_gt_22_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "incidence_attrition_gt_22_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      sortable::bucket_list(
                        header = NULL,
                        sortable::add_rank_list(
                          text = "none",
                          labels = c("denominator_cohort_name", "reason", "reason_id", "analysis_outcome_washout", "analysis_repeated_events", "analysis_interval", "analysis_complete_database_intervals", "denominator_age_group", "denominator_sex", "denominator_days_prior_observation", "denominator_start_date", "denominator_end_date", "denominator_time_at_risk", "denominator_target_cohort_name", "outcome_cohort_name"),
                          input_id = "incidence_attrition_gt_22_none"
                        ),
                        sortable::add_rank_list(
                          text = "header",
                          labels = "variable_name",
                          input_id = "incidence_attrition_gt_22_header"
                        ),
                        sortable::add_rank_list(
                          text = "groupColumn",
                          labels = c("cdm_name", "variable_level"),
                          input_id = "incidence_attrition_gt_22_groupColumn"
                        ),
                        sortable::add_rank_list(
                          text = "hide",
                          labels = "estimate_name",
                          input_id = "incidence_attrition_gt_22_hide"
                        )
                      ),
                      position = "right"
                    ),
                    gt::gt_output("incidence_attrition_gt_22")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_panel(
          title = "Prevalence",
          icon = shiny::icon("chart-line"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "Settings",
                  shiny::selectizeInput(
                    inputId = "prevalence_settings_analysis_interval",
                    label = "Analysis interval",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_settings_analysis_complete_database_intervals",
                    label = "Analysis complete database intervals",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_settings_denominator_age_group",
                    label = "Denominator age group",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_settings_denominator_sex",
                    label = "Denominator sex",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_settings_denominator_days_prior_observation",
                    label = "Denominator days prior observation",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_settings_denominator_start_date",
                    label = "Denominator start date",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_settings_denominator_end_date",
                    label = "Denominator end date",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_settings_denominator_time_at_risk",
                    label = "Denominator time at risk",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_settings_denominator_target_cohort_name",
                    label = "Denominator target cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_settings_analysis_type",
                    label = "Analysis type",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_settings_analysis_full_contribution",
                    label = "Analysis full contribution",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "prevalence_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_grouping_denominator_cohort_name",
                    label = "Denominator cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_grouping_prevalence_start_date",
                    label = "Prevalence start date",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_grouping_prevalence_end_date",
                    label = "Prevalence end date",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "prevalence_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "prevalence_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "prevalence_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "prevalence_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "prevalence_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("prevalence_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table prevalence",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "prevalence_gt_20_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "prevalence_gt_20_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      sortable::bucket_list(
                        header = NULL,
                        sortable::add_rank_list(
                          text = "none",
                          labels = c("cdm_name", "denominator_cohort_name", "prevalence_start_date", "prevalence_end_date", "analysis_interval", "analysis_complete_database_intervals", "denominator_age_group", "denominator_sex", "denominator_days_prior_observation", "denominator_start_date", "denominator_end_date", "denominator_time_at_risk", "denominator_target_cohort_name", "analysis_type", "analysis_full_contribution", "variable_name", "variable_level"),
                          input_id = "prevalence_gt_20_none"
                        ),
                        sortable::add_rank_list(
                          text = "header",
                          labels = "estimate_name",
                          input_id = "prevalence_gt_20_header"
                        ),
                        sortable::add_rank_list(
                          text = "groupColumn",
                          labels = character(),
                          input_id = "prevalence_gt_20_groupColumn"
                        ),
                        sortable::add_rank_list(
                          text = "hide",
                          labels = character(),
                          input_id = "prevalence_gt_20_hide"
                        )
                      ),
                      position = "right"
                    ),
                    gt::gt_output("prevalence_gt_20")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Plot prevalence",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::numericInput(
                        inputId = "prevalence_ggplot2_21_download_width",
                        label = "Width",
                        value = 15
                      ),
                      shiny::numericInput(
                        inputId = "prevalence_ggplot2_21_download_height",
                        label = "Height",
                        value = 10
                      ),
                      shiny::selectizeInput(
                        inputId = "prevalence_ggplot2_21_download_units",
                        label = "Units",
                        selected = "cm",
                        choices = c("px", "cm", "inch"),
                        multiple = FALSE
                      ),
                      shiny::numericInput(
                        inputId = "prevalence_ggplot2_21_download_dpi",
                        label = "dpi",
                        value = 300
                      ),
                      shiny::downloadButton(outputId = "prevalence_ggplot2_21_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "prevalence_ggplot2_21_x",
                        label = "x",
                        selected = "prevalence_start_date",
                        multiple = FALSE,
                        choices = c("cdm_name", "denominator_cohort_name", "prevalence_start_date", "prevalence_end_date", "analysis_interval", "analysis_complete_database_intervals", "denominator_age_group", "denominator_sex", "denominator_days_prior_observation", "denominator_start_date", "denominator_end_date", "denominator_time_at_risk", "denominator_target_cohort_name", "analysis_type", "analysis_full_contribution", "variable_name", "variable_level", "estimate_name"),
                        options = list(plugins = "remove_button")
                      ),
                      shiny::checkboxInput(
                        inputId = "prevalence_ggplot2_21_ribbon",
                        label = "ribbon",
                        value = c(FALSE)
                      ),
                      shiny::selectizeInput(
                        inputId = "prevalence_ggplot2_21_facet",
                        label = "facet",
                        selected = NULL,
                        multiple = TRUE,
                        choices = c("cdm_name", "denominator_cohort_name", "prevalence_start_date", "prevalence_end_date", "analysis_interval", "analysis_complete_database_intervals", "denominator_age_group", "denominator_sex", "denominator_days_prior_observation", "denominator_start_date", "denominator_end_date", "denominator_time_at_risk", "denominator_target_cohort_name", "analysis_type", "analysis_full_contribution", "variable_name", "variable_level", "estimate_name"),
                        options = list(plugins = "remove_button")
                      ),
                      shiny::selectizeInput(
                        inputId = "prevalence_ggplot2_21_colour",
                        label = "colour",
                        selected = NULL,
                        multiple = TRUE,
                        choices = c("cdm_name", "denominator_cohort_name", "prevalence_start_date", "prevalence_end_date", "analysis_interval", "analysis_complete_database_intervals", "denominator_age_group", "denominator_sex", "denominator_days_prior_observation", "denominator_start_date", "denominator_end_date", "denominator_time_at_risk", "denominator_target_cohort_name", "analysis_type", "analysis_full_contribution", "variable_name", "variable_level", "estimate_name"),
                        options = list(plugins = "remove_button")
                      ),
                      position = "right"
                    ),
                    shiny::plotOutput("prevalence_ggplot2_21")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_panel(
          title = "Prevalence attrition",
          icon = shiny::icon("layer-group"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "Settings",
                  shiny::selectizeInput(
                    inputId = "prevalence_attrition_settings_analysis_interval",
                    label = "Analysis interval",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_attrition_settings_analysis_complete_database_intervals",
                    label = "Analysis complete database intervals",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_attrition_settings_denominator_age_group",
                    label = "Denominator age group",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_attrition_settings_denominator_sex",
                    label = "Denominator sex",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_attrition_settings_denominator_days_prior_observation",
                    label = "Denominator days prior observation",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_attrition_settings_denominator_start_date",
                    label = "Denominator start date",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_attrition_settings_denominator_end_date",
                    label = "Denominator end date",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_attrition_settings_denominator_time_at_risk",
                    label = "Denominator time at risk",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_attrition_settings_denominator_target_cohort_name",
                    label = "Denominator target cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_attrition_settings_outcome_cohort_name",
                    label = "Outcome cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_attrition_settings_analysis_type",
                    label = "Analysis type",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_attrition_settings_analysis_full_contribution",
                    label = "Analysis full contribution",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "prevalence_attrition_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_attrition_grouping_denominator_cohort_name",
                    label = "Denominator cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_attrition_grouping_reason",
                    label = "Reason",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_attrition_grouping_reason_id",
                    label = "Reason id",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "prevalence_attrition_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "prevalence_attrition_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "prevalence_attrition_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "prevalence_attrition_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "prevalence_attrition_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("prevalence_attrition_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table prevalence attrition",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "prevalence_attrition_gt_23_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "prevalence_attrition_gt_23_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      sortable::bucket_list(
                        header = NULL,
                        sortable::add_rank_list(
                          text = "none",
                          labels = c("denominator_cohort_name", "reason", "reason_id", "analysis_interval", "analysis_complete_database_intervals", "denominator_age_group", "denominator_sex", "denominator_days_prior_observation", "denominator_start_date", "denominator_end_date", "denominator_time_at_risk", "denominator_target_cohort_name", "outcome_cohort_name", "analysis_type", "analysis_full_contribution"),
                          input_id = "prevalence_attrition_gt_23_none"
                        ),
                        sortable::add_rank_list(
                          text = "header",
                          labels = "variable_name",
                          input_id = "prevalence_attrition_gt_23_header"
                        ),
                        sortable::add_rank_list(
                          text = "groupColumn",
                          labels = c("cdm_name", "variable_level"),
                          input_id = "prevalence_attrition_gt_23_groupColumn"
                        ),
                        sortable::add_rank_list(
                          text = "hide",
                          labels = "estimate_name",
                          input_id = "prevalence_attrition_gt_23_hide"
                        )
                      ),
                      position = "right"
                    ),
                    gt::gt_output("prevalence_attrition_gt_23")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_spacer(),
        bslib::nav_item(
          bslib::popover(
            shiny::icon("download"),
            shiny::downloadButton(
              outputId = "download_raw",
              label = "Download raw data",
              icon = shiny::icon("download")
            )
          )
        ),
        bslib::nav_item(
          bslib::popover(
            shiny::icon("circle-info"),
            shiny::tags$img(
              src = "hds_logo.svg",
              class = "logo-img",
              alt = "Logo",
              height = "auto",
              width = "30%",
              style = "float:right"
            ),
            "This shiny app was generated with ",
            shiny::a(
              "OmopViewer",
              href = "https://github.com/OHDSI/OmopViewer",
              target = "_blank"
            ),
            shiny::strong("v0.1.0")
          )
        ),
        bslib::nav_item(bslib::input_dark_mode(id = "dark_mode", mode = "light"))
      )

---

    Code
      cat(server, sep = "\n")
    Output
      # Generated by OmopViewer 0.1.0
      # Be careful editing this file
      
      server <- function(input, output, session) {
        # download raw data -----
        output$download_raw <- shiny::downloadHandler(
          filename = "results.csv",
          content = function(file) {
            OmopViewer::exportSummarisedResult(data, fileName = file)
          }
        )
        # fill selectise variables ----
        shiny::observe({
          choices <- OmopViewer::getChoices(data, flatten = TRUE)
          for (k in seq_along(choices)) {
            shiny::updateSelectizeInput(
              session,
              inputId = names(choices)[k],
              choices = choices[[k]],
              selected = choices[[k]],
              server = TRUE
            )
          }
        })
        # incidence -----
        ## tidy incidence -----
        getTidyDataIncidence <- shiny::reactive({
          res <- data |>
            OmopViewer::filterData("incidence", input) |>
            OmopViewer::tidyData()
      
          # columns to eliminate
          colsEliminate <- colnames(res)
          colsEliminate <- colsEliminate[!colsEliminate %in% c(
            input$incidence_tidy_columns, "variable_name", "variable_level",
            "estimate_name", "estimate_type", "estimate_value"
          )]
      
          # pivot
          pivot <- input$incidence_tidy_pivot
          if (pivot != "none") {
            vars <- switch(pivot,
              "estimates" = "estimate_name",
              "estimates and variables" = c("variable_name", "variable_level", "estimate_name")
            )
            res <- res |>
              visOmopResults::pivotEstimates(pivotEstimatesBy = vars)
          }
      
          res |>
            dplyr::select(!dplyr::all_of(colsEliminate))
        })
        output$incidence_tidy <- DT::renderDT({
          DT::datatable(
            getTidyDataIncidence(),
            options = list(scrollX = TRUE),
            rownames = FALSE
          )
        })
        output$incidence_tidy_download <- shiny::downloadHandler(
          filename = "tidy_incidence.csv",
          content = function(file) {
            getTidyDataIncidence() |>
              readr::write_csv(file = file)
          }
        )
        ## output incidence -----
        ## output 18 -----
        createOutput18 <- shiny::reactive({
          result <- data |>
            OmopViewer::filterData("incidence", input)
          IncidencePrevalence::tableIncidence(
            result,
            header = input$incidence_gt_18_header,
            groupColumn = input$incidence_gt_18_groupColumn,
            hide = input$incidence_gt_18_hide
          )
        })
        output$incidence_gt_18 <- gt::render_gt({
          createOutput18()
        })
        output$incidence_gt_18_download <- shiny::downloadHandler(
          filename = paste0("output_gt_incidence.", input$incidence_gt_18_download_type),
          content = function(file) {
            obj <- createOutput18()
            gt::gtsave(data = obj, filename = file)
          }
        )
      
        ## output 19 -----
        createOutput19 <- shiny::reactive({
          result <- data |>
            OmopViewer::filterData("incidence", input)
          IncidencePrevalence::plotIncidence(
            result,
            x = input$incidence_ggplot2_19_x,
            ribbon = input$incidence_ggplot2_19_ribbon,
            facet = input$incidence_ggplot2_19_facet,
            colour = input$incidence_ggplot2_19_colour
          )
        })
        output$incidence_ggplot2_19 <- shiny::renderPlot({
          createOutput19()
        })
        output$incidence_ggplot2_19_download <- shiny::downloadHandler(
          filename = paste0("output_ggplot2_incidence.", "png"),
          content = function(file) {
            obj <- createOutput19()
            ggplot2::ggsave(
              filename = file,
              plot = obj,
              width = as.numeric(input$incidence_ggplot2_19_download_width),
              height = as.numeric(input$incidence_ggplot2_19_download_height),
              units = input$incidence_ggplot2_19_download_units,
              dpi = as.numeric(input$incidence_ggplot2_19_download_dpi)
            )
          }
        )
      
      
        # incidence_attrition -----
        ## tidy incidence_attrition -----
        getTidyDataIncidenceAttrition <- shiny::reactive({
          res <- data |>
            OmopViewer::filterData("incidence_attrition", input) |>
            OmopViewer::tidyData()
      
          # columns to eliminate
          colsEliminate <- colnames(res)
          colsEliminate <- colsEliminate[!colsEliminate %in% c(
            input$incidence_attrition_tidy_columns, "variable_name", "variable_level",
            "estimate_name", "estimate_type", "estimate_value"
          )]
      
          # pivot
          pivot <- input$incidence_attrition_tidy_pivot
          if (pivot != "none") {
            vars <- switch(pivot,
              "estimates" = "estimate_name",
              "estimates and variables" = c("variable_name", "variable_level", "estimate_name")
            )
            res <- res |>
              visOmopResults::pivotEstimates(pivotEstimatesBy = vars)
          }
      
          res |>
            dplyr::select(!dplyr::all_of(colsEliminate))
        })
        output$incidence_attrition_tidy <- DT::renderDT({
          DT::datatable(
            getTidyDataIncidenceAttrition(),
            options = list(scrollX = TRUE),
            rownames = FALSE
          )
        })
        output$incidence_attrition_tidy_download <- shiny::downloadHandler(
          filename = "tidy_incidence_attrition.csv",
          content = function(file) {
            getTidyDataIncidenceAttrition() |>
              readr::write_csv(file = file)
          }
        )
        ## output incidence_attrition -----
        ## output 22 -----
        createOutput22 <- shiny::reactive({
          result <- data |>
            OmopViewer::filterData("incidence_attrition", input)
          IncidencePrevalence::tableIncidenceAttrition(
            result,
            header = input$incidence_attrition_gt_22_header,
            groupColumn = input$incidence_attrition_gt_22_groupColumn,
            hide = input$incidence_attrition_gt_22_hide
          )
        })
        output$incidence_attrition_gt_22 <- gt::render_gt({
          createOutput22()
        })
        output$incidence_attrition_gt_22_download <- shiny::downloadHandler(
          filename = paste0("output_gt_incidence_attrition.", input$incidence_attrition_gt_22_download_type),
          content = function(file) {
            obj <- createOutput22()
            gt::gtsave(data = obj, filename = file)
          }
        )
      
      
        # prevalence -----
        ## tidy prevalence -----
        getTidyDataPrevalence <- shiny::reactive({
          res <- data |>
            OmopViewer::filterData("prevalence", input) |>
            OmopViewer::tidyData()
      
          # columns to eliminate
          colsEliminate <- colnames(res)
          colsEliminate <- colsEliminate[!colsEliminate %in% c(
            input$prevalence_tidy_columns, "variable_name", "variable_level",
            "estimate_name", "estimate_type", "estimate_value"
          )]
      
          # pivot
          pivot <- input$prevalence_tidy_pivot
          if (pivot != "none") {
            vars <- switch(pivot,
              "estimates" = "estimate_name",
              "estimates and variables" = c("variable_name", "variable_level", "estimate_name")
            )
            res <- res |>
              visOmopResults::pivotEstimates(pivotEstimatesBy = vars)
          }
      
          res |>
            dplyr::select(!dplyr::all_of(colsEliminate))
        })
        output$prevalence_tidy <- DT::renderDT({
          DT::datatable(
            getTidyDataPrevalence(),
            options = list(scrollX = TRUE),
            rownames = FALSE
          )
        })
        output$prevalence_tidy_download <- shiny::downloadHandler(
          filename = "tidy_prevalence.csv",
          content = function(file) {
            getTidyDataPrevalence() |>
              readr::write_csv(file = file)
          }
        )
        ## output prevalence -----
        ## output 20 -----
        createOutput20 <- shiny::reactive({
          result <- data |>
            OmopViewer::filterData("prevalence", input)
          IncidencePrevalence::tablePrevalence(
            result,
            header = input$prevalence_gt_20_header,
            groupColumn = input$prevalence_gt_20_groupColumn,
            hide = input$prevalence_gt_20_hide
          )
        })
        output$prevalence_gt_20 <- gt::render_gt({
          createOutput20()
        })
        output$prevalence_gt_20_download <- shiny::downloadHandler(
          filename = paste0("output_gt_prevalence.", input$prevalence_gt_20_download_type),
          content = function(file) {
            obj <- createOutput20()
            gt::gtsave(data = obj, filename = file)
          }
        )
      
        ## output 21 -----
        createOutput21 <- shiny::reactive({
          result <- data |>
            OmopViewer::filterData("prevalence", input)
          IncidencePrevalence::plotPrevalence(
            result,
            x = input$prevalence_ggplot2_21_x,
            ribbon = input$prevalence_ggplot2_21_ribbon,
            facet = input$prevalence_ggplot2_21_facet,
            colour = input$prevalence_ggplot2_21_colour
          )
        })
        output$prevalence_ggplot2_21 <- shiny::renderPlot({
          createOutput21()
        })
        output$prevalence_ggplot2_21_download <- shiny::downloadHandler(
          filename = paste0("output_ggplot2_prevalence.", "png"),
          content = function(file) {
            obj <- createOutput21()
            ggplot2::ggsave(
              filename = file,
              plot = obj,
              width = as.numeric(input$prevalence_ggplot2_21_download_width),
              height = as.numeric(input$prevalence_ggplot2_21_download_height),
              units = input$prevalence_ggplot2_21_download_units,
              dpi = as.numeric(input$prevalence_ggplot2_21_download_dpi)
            )
          }
        )
      
      
        # prevalence_attrition -----
        ## tidy prevalence_attrition -----
        getTidyDataPrevalenceAttrition <- shiny::reactive({
          res <- data |>
            OmopViewer::filterData("prevalence_attrition", input) |>
            OmopViewer::tidyData()
      
          # columns to eliminate
          colsEliminate <- colnames(res)
          colsEliminate <- colsEliminate[!colsEliminate %in% c(
            input$prevalence_attrition_tidy_columns, "variable_name", "variable_level",
            "estimate_name", "estimate_type", "estimate_value"
          )]
      
          # pivot
          pivot <- input$prevalence_attrition_tidy_pivot
          if (pivot != "none") {
            vars <- switch(pivot,
              "estimates" = "estimate_name",
              "estimates and variables" = c("variable_name", "variable_level", "estimate_name")
            )
            res <- res |>
              visOmopResults::pivotEstimates(pivotEstimatesBy = vars)
          }
      
          res |>
            dplyr::select(!dplyr::all_of(colsEliminate))
        })
        output$prevalence_attrition_tidy <- DT::renderDT({
          DT::datatable(
            getTidyDataPrevalenceAttrition(),
            options = list(scrollX = TRUE),
            rownames = FALSE
          )
        })
        output$prevalence_attrition_tidy_download <- shiny::downloadHandler(
          filename = "tidy_prevalence_attrition.csv",
          content = function(file) {
            getTidyDataPrevalenceAttrition() |>
              readr::write_csv(file = file)
          }
        )
        ## output prevalence_attrition -----
        ## output 23 -----
        createOutput23 <- shiny::reactive({
          result <- data |>
            OmopViewer::filterData("prevalence_attrition", input)
          IncidencePrevalence::tablePrevalenceAttrition(
            result,
            header = input$prevalence_attrition_gt_23_header,
            groupColumn = input$prevalence_attrition_gt_23_groupColumn,
            hide = input$prevalence_attrition_gt_23_hide
          )
        })
        output$prevalence_attrition_gt_23 <- gt::render_gt({
          createOutput23()
        })
        output$prevalence_attrition_gt_23_download <- shiny::downloadHandler(
          filename = paste0("output_gt_prevalence_attrition.", input$prevalence_attrition_gt_23_download_type),
          content = function(file) {
            obj <- createOutput23()
            gt::gtsave(data = obj, filename = file)
          }
        )
      }

---

    Code
      cat(global, sep = "\n")
    Output
      # Generated by OmopViewer 0.1.0
      # Be careful editing this file
      
      library(DT)
      library(IncidencePrevalence)
      library(OmopViewer)
      library(bslib)
      library(dplyr)
      library(ggplot2)
      library(gt)
      library(here)
      library(readr)
      library(shiny)
      library(sortable)
      library(visOmopResults)
      
      data <- OmopViewer::importSummarisedResult(here::here("data")) |>
        OmopViewer::correctSettings()

---

    Code
      cat(ui, sep = "\n")
    Output
      # Generated by OmopViewer 0.1.0
      # Be careful editing this file
      
      ui <- bslib::page_navbar(
        title = shiny::tags$span(
          shiny::tags$img(
            src = "ohdsi_logo.svg",
            width = "auto",
            height = "46px",
            class = "me-3",
            alt = "logo"
          ),
          ""
        ),
        bslib::nav_panel(
          title = "Background",
          icon = shiny::icon("disease"),
          OmopViewer::cardFromMd("background.md")
        ),
        bslib::nav_panel(
          title = "Incidence",
          icon = shiny::icon("chart-line"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "Settings",
                  shiny::selectizeInput(
                    inputId = "incidence_settings_analysis_outcome_washout",
                    label = "Analysis outcome washout",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_settings_analysis_repeated_events",
                    label = "Analysis repeated events",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_settings_analysis_interval",
                    label = "Analysis interval",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_settings_analysis_complete_database_intervals",
                    label = "Analysis complete database intervals",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_settings_denominator_age_group",
                    label = "Denominator age group",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_settings_denominator_sex",
                    label = "Denominator sex",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_settings_denominator_days_prior_observation",
                    label = "Denominator days prior observation",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_settings_denominator_start_date",
                    label = "Denominator start date",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_settings_denominator_end_date",
                    label = "Denominator end date",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_settings_denominator_time_at_risk",
                    label = "Denominator time at risk",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_settings_denominator_target_cohort_name",
                    label = "Denominator target cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_settings_outcome_cohort_name",
                    label = "Outcome cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "incidence_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_grouping_denominator_cohort_name",
                    label = "Denominator cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_grouping_incidence_start_date",
                    label = "Incidence start date",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_grouping_incidence_end_date",
                    label = "Incidence end date",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "incidence_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "incidence_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "incidence_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "incidence_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "incidence_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("incidence_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table incidence",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "incidence_gt_18_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "incidence_gt_18_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      sortable::bucket_list(
                        header = NULL,
                        sortable::add_rank_list(
                          text = "none",
                          labels = c("cdm_name", "denominator_cohort_name", "incidence_start_date", "incidence_end_date", "analysis_outcome_washout", "analysis_repeated_events", "analysis_interval", "analysis_complete_database_intervals", "denominator_age_group", "denominator_sex", "denominator_days_prior_observation", "denominator_start_date", "denominator_end_date", "denominator_time_at_risk", "denominator_target_cohort_name", "outcome_cohort_name", "variable_name", "variable_level"),
                          input_id = "incidence_gt_18_none"
                        ),
                        sortable::add_rank_list(
                          text = "header",
                          labels = "estimate_name",
                          input_id = "incidence_gt_18_header"
                        ),
                        sortable::add_rank_list(
                          text = "groupColumn",
                          labels = character(),
                          input_id = "incidence_gt_18_groupColumn"
                        ),
                        sortable::add_rank_list(
                          text = "hide",
                          labels = character(),
                          input_id = "incidence_gt_18_hide"
                        )
                      ),
                      position = "right"
                    ),
                    gt::gt_output("incidence_gt_18")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Plot incidence",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::numericInput(
                        inputId = "incidence_ggplot2_19_download_width",
                        label = "Width",
                        value = 15
                      ),
                      shiny::numericInput(
                        inputId = "incidence_ggplot2_19_download_height",
                        label = "Height",
                        value = 10
                      ),
                      shiny::selectizeInput(
                        inputId = "incidence_ggplot2_19_download_units",
                        label = "Units",
                        selected = "cm",
                        choices = c("px", "cm", "inch"),
                        multiple = FALSE
                      ),
                      shiny::numericInput(
                        inputId = "incidence_ggplot2_19_download_dpi",
                        label = "dpi",
                        value = 300
                      ),
                      shiny::downloadButton(outputId = "incidence_ggplot2_19_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "incidence_ggplot2_19_x",
                        label = "x",
                        selected = "incidence_start_date",
                        multiple = FALSE,
                        choices = c("cdm_name", "denominator_cohort_name", "incidence_start_date", "incidence_end_date", "analysis_outcome_washout", "analysis_repeated_events", "analysis_interval", "analysis_complete_database_intervals", "denominator_age_group", "denominator_sex", "denominator_days_prior_observation", "denominator_start_date", "denominator_end_date", "denominator_time_at_risk", "denominator_target_cohort_name", "outcome_cohort_name", "variable_name", "variable_level", "estimate_name"),
                        options = list(plugins = "remove_button")
                      ),
                      shiny::checkboxInput(
                        inputId = "incidence_ggplot2_19_ribbon",
                        label = "ribbon",
                        value = c(FALSE)
                      ),
                      shiny::selectizeInput(
                        inputId = "incidence_ggplot2_19_facet",
                        label = "facet",
                        selected = NULL,
                        multiple = TRUE,
                        choices = c("cdm_name", "denominator_cohort_name", "incidence_start_date", "incidence_end_date", "analysis_outcome_washout", "analysis_repeated_events", "analysis_interval", "analysis_complete_database_intervals", "denominator_age_group", "denominator_sex", "denominator_days_prior_observation", "denominator_start_date", "denominator_end_date", "denominator_time_at_risk", "denominator_target_cohort_name", "outcome_cohort_name", "variable_name", "variable_level", "estimate_name"),
                        options = list(plugins = "remove_button")
                      ),
                      shiny::selectizeInput(
                        inputId = "incidence_ggplot2_19_colour",
                        label = "colour",
                        selected = NULL,
                        multiple = TRUE,
                        choices = c("cdm_name", "denominator_cohort_name", "incidence_start_date", "incidence_end_date", "analysis_outcome_washout", "analysis_repeated_events", "analysis_interval", "analysis_complete_database_intervals", "denominator_age_group", "denominator_sex", "denominator_days_prior_observation", "denominator_start_date", "denominator_end_date", "denominator_time_at_risk", "denominator_target_cohort_name", "outcome_cohort_name", "variable_name", "variable_level", "estimate_name"),
                        options = list(plugins = "remove_button")
                      ),
                      position = "right"
                    ),
                    shiny::plotOutput("incidence_ggplot2_19")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_panel(
          title = "Incidence attrition",
          icon = shiny::icon("layer-group"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "Settings",
                  shiny::selectizeInput(
                    inputId = "incidence_attrition_settings_analysis_outcome_washout",
                    label = "Analysis outcome washout",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_attrition_settings_analysis_repeated_events",
                    label = "Analysis repeated events",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_attrition_settings_analysis_interval",
                    label = "Analysis interval",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_attrition_settings_analysis_complete_database_intervals",
                    label = "Analysis complete database intervals",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_attrition_settings_denominator_age_group",
                    label = "Denominator age group",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_attrition_settings_denominator_sex",
                    label = "Denominator sex",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_attrition_settings_denominator_days_prior_observation",
                    label = "Denominator days prior observation",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_attrition_settings_denominator_start_date",
                    label = "Denominator start date",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_attrition_settings_denominator_end_date",
                    label = "Denominator end date",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_attrition_settings_denominator_time_at_risk",
                    label = "Denominator time at risk",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_attrition_settings_denominator_target_cohort_name",
                    label = "Denominator target cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_attrition_settings_outcome_cohort_name",
                    label = "Outcome cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "incidence_attrition_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_attrition_grouping_denominator_cohort_name",
                    label = "Denominator cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_attrition_grouping_reason",
                    label = "Reason",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "incidence_attrition_grouping_reason_id",
                    label = "Reason id",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "incidence_attrition_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "incidence_attrition_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "incidence_attrition_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "incidence_attrition_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "incidence_attrition_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("incidence_attrition_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table incidence attrition",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "incidence_attrition_gt_22_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "incidence_attrition_gt_22_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      sortable::bucket_list(
                        header = NULL,
                        sortable::add_rank_list(
                          text = "none",
                          labels = c("denominator_cohort_name", "reason", "reason_id", "analysis_outcome_washout", "analysis_repeated_events", "analysis_interval", "analysis_complete_database_intervals", "denominator_age_group", "denominator_sex", "denominator_days_prior_observation", "denominator_start_date", "denominator_end_date", "denominator_time_at_risk", "denominator_target_cohort_name", "outcome_cohort_name"),
                          input_id = "incidence_attrition_gt_22_none"
                        ),
                        sortable::add_rank_list(
                          text = "header",
                          labels = "variable_name",
                          input_id = "incidence_attrition_gt_22_header"
                        ),
                        sortable::add_rank_list(
                          text = "groupColumn",
                          labels = c("cdm_name", "variable_level"),
                          input_id = "incidence_attrition_gt_22_groupColumn"
                        ),
                        sortable::add_rank_list(
                          text = "hide",
                          labels = "estimate_name",
                          input_id = "incidence_attrition_gt_22_hide"
                        )
                      ),
                      position = "right"
                    ),
                    gt::gt_output("incidence_attrition_gt_22")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_panel(
          title = "Prevalence",
          icon = shiny::icon("chart-line"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "Settings",
                  shiny::selectizeInput(
                    inputId = "prevalence_settings_analysis_interval",
                    label = "Analysis interval",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_settings_analysis_complete_database_intervals",
                    label = "Analysis complete database intervals",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_settings_denominator_age_group",
                    label = "Denominator age group",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_settings_denominator_sex",
                    label = "Denominator sex",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_settings_denominator_days_prior_observation",
                    label = "Denominator days prior observation",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_settings_denominator_start_date",
                    label = "Denominator start date",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_settings_denominator_end_date",
                    label = "Denominator end date",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_settings_denominator_time_at_risk",
                    label = "Denominator time at risk",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_settings_denominator_target_cohort_name",
                    label = "Denominator target cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_settings_analysis_type",
                    label = "Analysis type",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_settings_analysis_full_contribution",
                    label = "Analysis full contribution",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "prevalence_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_grouping_denominator_cohort_name",
                    label = "Denominator cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_grouping_prevalence_start_date",
                    label = "Prevalence start date",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_grouping_prevalence_end_date",
                    label = "Prevalence end date",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "prevalence_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "prevalence_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "prevalence_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "prevalence_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "prevalence_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("prevalence_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table prevalence",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "prevalence_gt_20_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "prevalence_gt_20_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      sortable::bucket_list(
                        header = NULL,
                        sortable::add_rank_list(
                          text = "none",
                          labels = c("cdm_name", "denominator_cohort_name", "prevalence_start_date", "prevalence_end_date", "analysis_interval", "analysis_complete_database_intervals", "denominator_age_group", "denominator_sex", "denominator_days_prior_observation", "denominator_start_date", "denominator_end_date", "denominator_time_at_risk", "denominator_target_cohort_name", "analysis_type", "analysis_full_contribution", "variable_name", "variable_level"),
                          input_id = "prevalence_gt_20_none"
                        ),
                        sortable::add_rank_list(
                          text = "header",
                          labels = "estimate_name",
                          input_id = "prevalence_gt_20_header"
                        ),
                        sortable::add_rank_list(
                          text = "groupColumn",
                          labels = character(),
                          input_id = "prevalence_gt_20_groupColumn"
                        ),
                        sortable::add_rank_list(
                          text = "hide",
                          labels = character(),
                          input_id = "prevalence_gt_20_hide"
                        )
                      ),
                      position = "right"
                    ),
                    gt::gt_output("prevalence_gt_20")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Plot prevalence",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::numericInput(
                        inputId = "prevalence_ggplot2_21_download_width",
                        label = "Width",
                        value = 15
                      ),
                      shiny::numericInput(
                        inputId = "prevalence_ggplot2_21_download_height",
                        label = "Height",
                        value = 10
                      ),
                      shiny::selectizeInput(
                        inputId = "prevalence_ggplot2_21_download_units",
                        label = "Units",
                        selected = "cm",
                        choices = c("px", "cm", "inch"),
                        multiple = FALSE
                      ),
                      shiny::numericInput(
                        inputId = "prevalence_ggplot2_21_download_dpi",
                        label = "dpi",
                        value = 300
                      ),
                      shiny::downloadButton(outputId = "prevalence_ggplot2_21_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "prevalence_ggplot2_21_x",
                        label = "x",
                        selected = "prevalence_start_date",
                        multiple = FALSE,
                        choices = c("cdm_name", "denominator_cohort_name", "prevalence_start_date", "prevalence_end_date", "analysis_interval", "analysis_complete_database_intervals", "denominator_age_group", "denominator_sex", "denominator_days_prior_observation", "denominator_start_date", "denominator_end_date", "denominator_time_at_risk", "denominator_target_cohort_name", "analysis_type", "analysis_full_contribution", "variable_name", "variable_level", "estimate_name"),
                        options = list(plugins = "remove_button")
                      ),
                      shiny::checkboxInput(
                        inputId = "prevalence_ggplot2_21_ribbon",
                        label = "ribbon",
                        value = c(FALSE)
                      ),
                      shiny::selectizeInput(
                        inputId = "prevalence_ggplot2_21_facet",
                        label = "facet",
                        selected = NULL,
                        multiple = TRUE,
                        choices = c("cdm_name", "denominator_cohort_name", "prevalence_start_date", "prevalence_end_date", "analysis_interval", "analysis_complete_database_intervals", "denominator_age_group", "denominator_sex", "denominator_days_prior_observation", "denominator_start_date", "denominator_end_date", "denominator_time_at_risk", "denominator_target_cohort_name", "analysis_type", "analysis_full_contribution", "variable_name", "variable_level", "estimate_name"),
                        options = list(plugins = "remove_button")
                      ),
                      shiny::selectizeInput(
                        inputId = "prevalence_ggplot2_21_colour",
                        label = "colour",
                        selected = NULL,
                        multiple = TRUE,
                        choices = c("cdm_name", "denominator_cohort_name", "prevalence_start_date", "prevalence_end_date", "analysis_interval", "analysis_complete_database_intervals", "denominator_age_group", "denominator_sex", "denominator_days_prior_observation", "denominator_start_date", "denominator_end_date", "denominator_time_at_risk", "denominator_target_cohort_name", "analysis_type", "analysis_full_contribution", "variable_name", "variable_level", "estimate_name"),
                        options = list(plugins = "remove_button")
                      ),
                      position = "right"
                    ),
                    shiny::plotOutput("prevalence_ggplot2_21")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_panel(
          title = "Prevalence attrition",
          icon = shiny::icon("layer-group"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "Settings",
                  shiny::selectizeInput(
                    inputId = "prevalence_attrition_settings_analysis_interval",
                    label = "Analysis interval",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_attrition_settings_analysis_complete_database_intervals",
                    label = "Analysis complete database intervals",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_attrition_settings_denominator_age_group",
                    label = "Denominator age group",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_attrition_settings_denominator_sex",
                    label = "Denominator sex",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_attrition_settings_denominator_days_prior_observation",
                    label = "Denominator days prior observation",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_attrition_settings_denominator_start_date",
                    label = "Denominator start date",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_attrition_settings_denominator_end_date",
                    label = "Denominator end date",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_attrition_settings_denominator_time_at_risk",
                    label = "Denominator time at risk",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_attrition_settings_denominator_target_cohort_name",
                    label = "Denominator target cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_attrition_settings_outcome_cohort_name",
                    label = "Outcome cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_attrition_settings_analysis_type",
                    label = "Analysis type",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_attrition_settings_analysis_full_contribution",
                    label = "Analysis full contribution",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "prevalence_attrition_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_attrition_grouping_denominator_cohort_name",
                    label = "Denominator cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_attrition_grouping_reason",
                    label = "Reason",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "prevalence_attrition_grouping_reason_id",
                    label = "Reason id",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "prevalence_attrition_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "prevalence_attrition_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "prevalence_attrition_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "prevalence_attrition_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "prevalence_attrition_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("prevalence_attrition_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table prevalence attrition",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "prevalence_attrition_gt_23_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "prevalence_attrition_gt_23_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      sortable::bucket_list(
                        header = NULL,
                        sortable::add_rank_list(
                          text = "none",
                          labels = c("denominator_cohort_name", "reason", "reason_id", "analysis_interval", "analysis_complete_database_intervals", "denominator_age_group", "denominator_sex", "denominator_days_prior_observation", "denominator_start_date", "denominator_end_date", "denominator_time_at_risk", "denominator_target_cohort_name", "outcome_cohort_name", "analysis_type", "analysis_full_contribution"),
                          input_id = "prevalence_attrition_gt_23_none"
                        ),
                        sortable::add_rank_list(
                          text = "header",
                          labels = "variable_name",
                          input_id = "prevalence_attrition_gt_23_header"
                        ),
                        sortable::add_rank_list(
                          text = "groupColumn",
                          labels = c("cdm_name", "variable_level"),
                          input_id = "prevalence_attrition_gt_23_groupColumn"
                        ),
                        sortable::add_rank_list(
                          text = "hide",
                          labels = "estimate_name",
                          input_id = "prevalence_attrition_gt_23_hide"
                        )
                      ),
                      position = "right"
                    ),
                    gt::gt_output("prevalence_attrition_gt_23")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_spacer(),
        bslib::nav_item(
          bslib::popover(
            shiny::icon("download"),
            shiny::downloadButton(
              outputId = "download_raw",
              label = "Download raw data",
              icon = shiny::icon("download")
            )
          )
        ),
        bslib::nav_item(
          bslib::popover(
            shiny::icon("circle-info"),
            shiny::tags$img(
              src = "hds_logo.svg",
              class = "logo-img",
              alt = "Logo",
              height = "auto",
              width = "30%",
              style = "float:right"
            ),
            "This shiny app was generated with ",
            shiny::a(
              "OmopViewer",
              href = "https://github.com/OHDSI/OmopViewer",
              target = "_blank"
            ),
            shiny::strong("v0.1.0")
          )
        ),
        bslib::nav_item(bslib::input_dark_mode(id = "dark_mode", mode = "light"))
      )

# DrugUtilisation shiny

    Code
      cat(ui, sep = "\n")
    Output
      # Generated by OmopViewer 0.1.0
      # Be careful editing this file
      
      ui <- bslib::page_navbar(
        title = shiny::tags$span(
          shiny::tags$img(
            src = "ohdsi_logo.svg",
            width = "auto",
            height = "46px",
            class = "me-3",
            alt = "logo"
          ),
          ""
        ),
        bslib::nav_panel(
          title = "Background",
          icon = shiny::icon("disease"),
          OmopViewer::cardFromMd("background.md")
        ),
        bslib::nav_panel(
          title = "Summary",
          icon = shiny::icon("file-alt"),
          OmopViewer::cardSummary(data)
        ),
        bslib::nav_panel(
          title = "Dose coverage",
          icon = shiny::icon("pills"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "summarise_dose_coverage_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_dose_coverage_grouping_ingredient_name",
                    label = "Ingredient name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_dose_coverage_grouping_unit",
                    label = "Unit",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_dose_coverage_grouping_route",
                    label = "Route",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_dose_coverage_grouping_pattern_id",
                    label = "Pattern id",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "summarise_dose_coverage_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "summarise_dose_coverage_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "summarise_dose_coverage_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_dose_coverage_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "summarise_dose_coverage_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("summarise_dose_coverage_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table dose coverage",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "summarise_dose_coverage_gt_24_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "summarise_dose_coverage_gt_24_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(,
                      position = "right"
                    ),
                    gt::gt_output("summarise_dose_coverage_gt_24")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_panel(
          title = "Drug restart",
          icon = shiny::icon("tablets"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "Settings",
                  shiny::selectizeInput(
                    inputId = "summarise_drug_restart_settings_restrict_to_first_discontinuation",
                    label = "Restrict to first discontinuation",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "summarise_drug_restart_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_drug_restart_grouping_cohort_name",
                    label = "Cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_drug_restart_grouping_age_group",
                    label = "Age group",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_drug_restart_grouping_sex",
                    label = "Sex",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "summarise_drug_restart_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "summarise_drug_restart_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "summarise_drug_restart_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_drug_restart_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "summarise_drug_restart_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("summarise_drug_restart_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table drug restart",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "summarise_drug_restart_gt_25_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "summarise_drug_restart_gt_25_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(,
                      position = "right"
                    ),
                    gt::gt_output("summarise_drug_restart_gt_25")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Plot drug restart",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::numericInput(
                        inputId = "summarise_drug_restart_ggplot2_26_download_width",
                        label = "Width",
                        value = 15
                      ),
                      shiny::numericInput(
                        inputId = "summarise_drug_restart_ggplot2_26_download_height",
                        label = "Height",
                        value = 10
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_drug_restart_ggplot2_26_download_units",
                        label = "Units",
                        selected = "cm",
                        choices = c("px", "cm", "inch"),
                        multiple = FALSE
                      ),
                      shiny::numericInput(
                        inputId = "summarise_drug_restart_ggplot2_26_download_dpi",
                        label = "dpi",
                        value = 300
                      ),
                      shiny::downloadButton(outputId = "summarise_drug_restart_ggplot2_26_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(,
                      position = "right"
                    ),
                    shiny::plotOutput("summarise_drug_restart_ggplot2_26")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_panel(
          title = "Drug utilisation",
          icon = shiny::icon("capsules"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "summarise_drug_utilisation_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_drug_utilisation_grouping_cohort_name",
                    label = "Cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_drug_utilisation_grouping_age_group",
                    label = "Age group",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_drug_utilisation_grouping_sex",
                    label = "Sex",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_drug_utilisation_grouping_concept_set",
                    label = "Concept set",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "summarise_drug_utilisation_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "summarise_drug_utilisation_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "summarise_drug_utilisation_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_drug_utilisation_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "summarise_drug_utilisation_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("summarise_drug_utilisation_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table drug utilisation",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "summarise_drug_utilisation_gt_27_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "summarise_drug_utilisation_gt_27_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(,
                      position = "right"
                    ),
                    gt::gt_output("summarise_drug_utilisation_gt_27")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_panel(
          title = "Indication",
          icon = shiny::icon("disease"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "summarise_indication_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_indication_grouping_cohort_name",
                    label = "Cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "summarise_indication_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "summarise_indication_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "summarise_indication_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_indication_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "summarise_indication_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("summarise_indication_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table indication",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "summarise_indication_gt_28_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "summarise_indication_gt_28_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(,
                      position = "right"
                    ),
                    gt::gt_output("summarise_indication_gt_28")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Plot indication",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::numericInput(
                        inputId = "summarise_indication_ggplot2_29_download_width",
                        label = "Width",
                        value = 15
                      ),
                      shiny::numericInput(
                        inputId = "summarise_indication_ggplot2_29_download_height",
                        label = "Height",
                        value = 10
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_indication_ggplot2_29_download_units",
                        label = "Units",
                        selected = "cm",
                        choices = c("px", "cm", "inch"),
                        multiple = FALSE
                      ),
                      shiny::numericInput(
                        inputId = "summarise_indication_ggplot2_29_download_dpi",
                        label = "dpi",
                        value = 300
                      ),
                      shiny::downloadButton(outputId = "summarise_indication_ggplot2_29_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(,
                      position = "right"
                    ),
                    shiny::plotOutput("summarise_indication_ggplot2_29")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_panel(
          title = "Proportion of patients covered",
          icon = shiny::icon("chart-gantt"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "summarise_proportion_of_patients_covered_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_proportion_of_patients_covered_grouping_cohort",
                    label = "Cohort",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_proportion_of_patients_covered_grouping_age_group",
                    label = "Age group",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_proportion_of_patients_covered_grouping_sex",
                    label = "Sex",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_proportion_of_patients_covered_grouping_time",
                    label = "Time",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "summarise_proportion_of_patients_covered_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "summarise_proportion_of_patients_covered_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "summarise_proportion_of_patients_covered_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_proportion_of_patients_covered_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "summarise_proportion_of_patients_covered_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("summarise_proportion_of_patients_covered_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table PPC",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "summarise_proportion_of_patients_covered_gt_30_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "summarise_proportion_of_patients_covered_gt_30_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(,
                      position = "right"
                    ),
                    gt::gt_output("summarise_proportion_of_patients_covered_gt_30")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Plot PPC",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::numericInput(
                        inputId = "summarise_proportion_of_patients_covered_ggplot2_31_download_width",
                        label = "Width",
                        value = 15
                      ),
                      shiny::numericInput(
                        inputId = "summarise_proportion_of_patients_covered_ggplot2_31_download_height",
                        label = "Height",
                        value = 10
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_proportion_of_patients_covered_ggplot2_31_download_units",
                        label = "Units",
                        selected = "cm",
                        choices = c("px", "cm", "inch"),
                        multiple = FALSE
                      ),
                      shiny::numericInput(
                        inputId = "summarise_proportion_of_patients_covered_ggplot2_31_download_dpi",
                        label = "dpi",
                        value = 300
                      ),
                      shiny::downloadButton(outputId = "summarise_proportion_of_patients_covered_ggplot2_31_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(,
                      position = "right"
                    ),
                    shiny::plotOutput("summarise_proportion_of_patients_covered_ggplot2_31")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_panel(
          title = "Alternative treatments",
          icon = shiny::icon("chart-bar"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "summarise_treatment_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_treatment_grouping_cohort_name",
                    label = "Cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_treatment_grouping_age_group",
                    label = "Age group",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_treatment_grouping_sex",
                    label = "Sex",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_treatment_grouping_window_name",
                    label = "Window name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "summarise_treatment_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "summarise_treatment_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "summarise_treatment_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_treatment_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "summarise_treatment_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("summarise_treatment_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table treatments",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "summarise_treatment_gt_32_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "summarise_treatment_gt_32_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(,
                      position = "right"
                    ),
                    gt::gt_output("summarise_treatment_gt_32")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Plot treatments",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::numericInput(
                        inputId = "summarise_treatment_ggplot2_33_download_width",
                        label = "Width",
                        value = 15
                      ),
                      shiny::numericInput(
                        inputId = "summarise_treatment_ggplot2_33_download_height",
                        label = "Height",
                        value = 10
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_treatment_ggplot2_33_download_units",
                        label = "Units",
                        selected = "cm",
                        choices = c("px", "cm", "inch"),
                        multiple = FALSE
                      ),
                      shiny::numericInput(
                        inputId = "summarise_treatment_ggplot2_33_download_dpi",
                        label = "dpi",
                        value = 300
                      ),
                      shiny::downloadButton(outputId = "summarise_treatment_ggplot2_33_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(,
                      position = "right"
                    ),
                    shiny::plotOutput("summarise_treatment_ggplot2_33")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_spacer(),
        bslib::nav_item(
          bslib::popover(
            shiny::icon("download"),
            shiny::downloadButton(
              outputId = "download_raw",
              label = "Download raw data",
              icon = shiny::icon("download")
            )
          )
        ),
        bslib::nav_item(
          bslib::popover(
            shiny::icon("circle-info"),
            shiny::tags$img(
              src = "hds_logo.svg",
              class = "logo-img",
              alt = "Logo",
              height = "auto",
              width = "30%",
              style = "float:right"
            ),
            "This shiny app was generated with ",
            shiny::a(
              "OmopViewer",
              href = "https://github.com/OHDSI/OmopViewer",
              target = "_blank"
            ),
            shiny::strong("v0.1.0")
          )
        ),
        bslib::nav_item(bslib::input_dark_mode(id = "dark_mode", mode = "light"))
      )

---

    Code
      cat(server, sep = "\n")
    Output
      # Generated by OmopViewer 0.1.0
      # Be careful editing this file
      
      server <- function(input, output, session) {
        # download raw data -----
        output$download_raw <- shiny::downloadHandler(
          filename = "results.csv",
          content = function(file) {
            OmopViewer::exportSummarisedResult(data, fileName = file)
          }
        )
        # fill selectise variables ----
        shiny::observe({
          choices <- OmopViewer::getChoices(data, flatten = TRUE)
          for (k in seq_along(choices)) {
            shiny::updateSelectizeInput(
              session,
              inputId = names(choices)[k],
              choices = choices[[k]],
              selected = choices[[k]],
              server = TRUE
            )
          }
        })
        # summarise_dose_coverage -----
        ## tidy summarise_dose_coverage -----
        getTidyDataSummariseDoseCoverage <- shiny::reactive({
          res <- data |>
            OmopViewer::filterData("summarise_dose_coverage", input) |>
            OmopViewer::tidyData()
      
          # columns to eliminate
          colsEliminate <- colnames(res)
          colsEliminate <- colsEliminate[!colsEliminate %in% c(
            input$summarise_dose_coverage_tidy_columns, "variable_name", "variable_level",
            "estimate_name", "estimate_type", "estimate_value"
          )]
      
          # pivot
          pivot <- input$summarise_dose_coverage_tidy_pivot
          if (pivot != "none") {
            vars <- switch(pivot,
              "estimates" = "estimate_name",
              "estimates and variables" = c("variable_name", "variable_level", "estimate_name")
            )
            res <- res |>
              visOmopResults::pivotEstimates(pivotEstimatesBy = vars)
          }
      
          res |>
            dplyr::select(!dplyr::all_of(colsEliminate))
        })
        output$summarise_dose_coverage_tidy <- DT::renderDT({
          DT::datatable(
            getTidyDataSummariseDoseCoverage(),
            options = list(scrollX = TRUE),
            rownames = FALSE
          )
        })
        output$summarise_dose_coverage_tidy_download <- shiny::downloadHandler(
          filename = "tidy_summarise_dose_coverage.csv",
          content = function(file) {
            getTidyDataSummariseDoseCoverage() |>
              readr::write_csv(file = file)
          }
        )
        ## output summarise_dose_coverage -----
        ## output 24 -----
        createOutput24 <- shiny::reactive({
          result <- data |>
            OmopViewer::filterData("summarise_dose_coverage", input)
          DrugUtilisation::tableDoseCoverage(
            result
          )
        })
        output$summarise_dose_coverage_gt_24 <- gt::render_gt({
          createOutput24()
        })
        output$summarise_dose_coverage_gt_24_download <- shiny::downloadHandler(
          filename = paste0("output_gt_summarise_dose_coverage.", input$summarise_dose_coverage_gt_24_download_type),
          content = function(file) {
            obj <- createOutput24()
            gt::gtsave(data = obj, filename = file)
          }
        )
      
      
        # summarise_drug_restart -----
        ## tidy summarise_drug_restart -----
        getTidyDataSummariseDrugRestart <- shiny::reactive({
          res <- data |>
            OmopViewer::filterData("summarise_drug_restart", input) |>
            OmopViewer::tidyData()
      
          # columns to eliminate
          colsEliminate <- colnames(res)
          colsEliminate <- colsEliminate[!colsEliminate %in% c(
            input$summarise_drug_restart_tidy_columns, "variable_name", "variable_level",
            "estimate_name", "estimate_type", "estimate_value"
          )]
      
          # pivot
          pivot <- input$summarise_drug_restart_tidy_pivot
          if (pivot != "none") {
            vars <- switch(pivot,
              "estimates" = "estimate_name",
              "estimates and variables" = c("variable_name", "variable_level", "estimate_name")
            )
            res <- res |>
              visOmopResults::pivotEstimates(pivotEstimatesBy = vars)
          }
      
          res |>
            dplyr::select(!dplyr::all_of(colsEliminate))
        })
        output$summarise_drug_restart_tidy <- DT::renderDT({
          DT::datatable(
            getTidyDataSummariseDrugRestart(),
            options = list(scrollX = TRUE),
            rownames = FALSE
          )
        })
        output$summarise_drug_restart_tidy_download <- shiny::downloadHandler(
          filename = "tidy_summarise_drug_restart.csv",
          content = function(file) {
            getTidyDataSummariseDrugRestart() |>
              readr::write_csv(file = file)
          }
        )
        ## output summarise_drug_restart -----
        ## output 25 -----
        createOutput25 <- shiny::reactive({
          result <- data |>
            OmopViewer::filterData("summarise_drug_restart", input)
          DrugUtilisation::tableDrugRestart(
            result
          )
        })
        output$summarise_drug_restart_gt_25 <- gt::render_gt({
          createOutput25()
        })
        output$summarise_drug_restart_gt_25_download <- shiny::downloadHandler(
          filename = paste0("output_gt_summarise_drug_restart.", input$summarise_drug_restart_gt_25_download_type),
          content = function(file) {
            obj <- createOutput25()
            gt::gtsave(data = obj, filename = file)
          }
        )
      
        ## output 26 -----
        createOutput26 <- shiny::reactive({
          result <- data |>
            OmopViewer::filterData("summarise_drug_restart", input)
          DrugUtilisation::plotDrugRestart(
            result
          )
        })
        output$summarise_drug_restart_ggplot2_26 <- shiny::renderPlot({
          createOutput26()
        })
        output$summarise_drug_restart_ggplot2_26_download <- shiny::downloadHandler(
          filename = paste0("output_ggplot2_summarise_drug_restart.", "png"),
          content = function(file) {
            obj <- createOutput26()
            ggplot2::ggsave(
              filename = file,
              plot = obj,
              width = as.numeric(input$summarise_drug_restart_ggplot2_26_download_width),
              height = as.numeric(input$summarise_drug_restart_ggplot2_26_download_height),
              units = input$summarise_drug_restart_ggplot2_26_download_units,
              dpi = as.numeric(input$summarise_drug_restart_ggplot2_26_download_dpi)
            )
          }
        )
      
      
        # summarise_drug_utilisation -----
        ## tidy summarise_drug_utilisation -----
        getTidyDataSummariseDrugUtilisation <- shiny::reactive({
          res <- data |>
            OmopViewer::filterData("summarise_drug_utilisation", input) |>
            OmopViewer::tidyData()
      
          # columns to eliminate
          colsEliminate <- colnames(res)
          colsEliminate <- colsEliminate[!colsEliminate %in% c(
            input$summarise_drug_utilisation_tidy_columns, "variable_name", "variable_level",
            "estimate_name", "estimate_type", "estimate_value"
          )]
      
          # pivot
          pivot <- input$summarise_drug_utilisation_tidy_pivot
          if (pivot != "none") {
            vars <- switch(pivot,
              "estimates" = "estimate_name",
              "estimates and variables" = c("variable_name", "variable_level", "estimate_name")
            )
            res <- res |>
              visOmopResults::pivotEstimates(pivotEstimatesBy = vars)
          }
      
          res |>
            dplyr::select(!dplyr::all_of(colsEliminate))
        })
        output$summarise_drug_utilisation_tidy <- DT::renderDT({
          DT::datatable(
            getTidyDataSummariseDrugUtilisation(),
            options = list(scrollX = TRUE),
            rownames = FALSE
          )
        })
        output$summarise_drug_utilisation_tidy_download <- shiny::downloadHandler(
          filename = "tidy_summarise_drug_utilisation.csv",
          content = function(file) {
            getTidyDataSummariseDrugUtilisation() |>
              readr::write_csv(file = file)
          }
        )
        ## output summarise_drug_utilisation -----
        ## output 27 -----
        createOutput27 <- shiny::reactive({
          result <- data |>
            OmopViewer::filterData("summarise_drug_utilisation", input)
          DrugUtilisation::tableDrugUtilisation(
            result
          )
        })
        output$summarise_drug_utilisation_gt_27 <- gt::render_gt({
          createOutput27()
        })
        output$summarise_drug_utilisation_gt_27_download <- shiny::downloadHandler(
          filename = paste0("output_gt_summarise_drug_utilisation.", input$summarise_drug_utilisation_gt_27_download_type),
          content = function(file) {
            obj <- createOutput27()
            gt::gtsave(data = obj, filename = file)
          }
        )
      
      
        # summarise_indication -----
        ## tidy summarise_indication -----
        getTidyDataSummariseIndication <- shiny::reactive({
          res <- data |>
            OmopViewer::filterData("summarise_indication", input) |>
            OmopViewer::tidyData()
      
          # columns to eliminate
          colsEliminate <- colnames(res)
          colsEliminate <- colsEliminate[!colsEliminate %in% c(
            input$summarise_indication_tidy_columns, "variable_name", "variable_level",
            "estimate_name", "estimate_type", "estimate_value"
          )]
      
          # pivot
          pivot <- input$summarise_indication_tidy_pivot
          if (pivot != "none") {
            vars <- switch(pivot,
              "estimates" = "estimate_name",
              "estimates and variables" = c("variable_name", "variable_level", "estimate_name")
            )
            res <- res |>
              visOmopResults::pivotEstimates(pivotEstimatesBy = vars)
          }
      
          res |>
            dplyr::select(!dplyr::all_of(colsEliminate))
        })
        output$summarise_indication_tidy <- DT::renderDT({
          DT::datatable(
            getTidyDataSummariseIndication(),
            options = list(scrollX = TRUE),
            rownames = FALSE
          )
        })
        output$summarise_indication_tidy_download <- shiny::downloadHandler(
          filename = "tidy_summarise_indication.csv",
          content = function(file) {
            getTidyDataSummariseIndication() |>
              readr::write_csv(file = file)
          }
        )
        ## output summarise_indication -----
        ## output 28 -----
        createOutput28 <- shiny::reactive({
          result <- data |>
            OmopViewer::filterData("summarise_indication", input)
          DrugUtilisation::tableIndication(
            result
          )
        })
        output$summarise_indication_gt_28 <- gt::render_gt({
          createOutput28()
        })
        output$summarise_indication_gt_28_download <- shiny::downloadHandler(
          filename = paste0("output_gt_summarise_indication.", input$summarise_indication_gt_28_download_type),
          content = function(file) {
            obj <- createOutput28()
            gt::gtsave(data = obj, filename = file)
          }
        )
      
        ## output 29 -----
        createOutput29 <- shiny::reactive({
          result <- data |>
            OmopViewer::filterData("summarise_indication", input)
          DrugUtilisation::plotIndication(
            result
          )
        })
        output$summarise_indication_ggplot2_29 <- shiny::renderPlot({
          createOutput29()
        })
        output$summarise_indication_ggplot2_29_download <- shiny::downloadHandler(
          filename = paste0("output_ggplot2_summarise_indication.", "png"),
          content = function(file) {
            obj <- createOutput29()
            ggplot2::ggsave(
              filename = file,
              plot = obj,
              width = as.numeric(input$summarise_indication_ggplot2_29_download_width),
              height = as.numeric(input$summarise_indication_ggplot2_29_download_height),
              units = input$summarise_indication_ggplot2_29_download_units,
              dpi = as.numeric(input$summarise_indication_ggplot2_29_download_dpi)
            )
          }
        )
      
      
        # summarise_proportion_of_patients_covered -----
        ## tidy summarise_proportion_of_patients_covered -----
        getTidyDataSummariseProportionOfPatientsCovered <- shiny::reactive({
          res <- data |>
            OmopViewer::filterData("summarise_proportion_of_patients_covered", input) |>
            OmopViewer::tidyData()
      
          # columns to eliminate
          colsEliminate <- colnames(res)
          colsEliminate <- colsEliminate[!colsEliminate %in% c(
            input$summarise_proportion_of_patients_covered_tidy_columns, "variable_name", "variable_level",
            "estimate_name", "estimate_type", "estimate_value"
          )]
      
          # pivot
          pivot <- input$summarise_proportion_of_patients_covered_tidy_pivot
          if (pivot != "none") {
            vars <- switch(pivot,
              "estimates" = "estimate_name",
              "estimates and variables" = c("variable_name", "variable_level", "estimate_name")
            )
            res <- res |>
              visOmopResults::pivotEstimates(pivotEstimatesBy = vars)
          }
      
          res |>
            dplyr::select(!dplyr::all_of(colsEliminate))
        })
        output$summarise_proportion_of_patients_covered_tidy <- DT::renderDT({
          DT::datatable(
            getTidyDataSummariseProportionOfPatientsCovered(),
            options = list(scrollX = TRUE),
            rownames = FALSE
          )
        })
        output$summarise_proportion_of_patients_covered_tidy_download <- shiny::downloadHandler(
          filename = "tidy_summarise_proportion_of_patients_covered.csv",
          content = function(file) {
            getTidyDataSummariseProportionOfPatientsCovered() |>
              readr::write_csv(file = file)
          }
        )
        ## output summarise_proportion_of_patients_covered -----
        ## output 30 -----
        createOutput30 <- shiny::reactive({
          result <- data |>
            OmopViewer::filterData("summarise_proportion_of_patients_covered", input)
          DrugUtilisation::tableProportionOfPatientsCovered(
            result
          )
        })
        output$summarise_proportion_of_patients_covered_gt_30 <- gt::render_gt({
          createOutput30()
        })
        output$summarise_proportion_of_patients_covered_gt_30_download <- shiny::downloadHandler(
          filename = paste0("output_gt_summarise_proportion_of_patients_covered.", input$summarise_proportion_of_patients_covered_gt_30_download_type),
          content = function(file) {
            obj <- createOutput30()
            gt::gtsave(data = obj, filename = file)
          }
        )
      
        ## output 31 -----
        createOutput31 <- shiny::reactive({
          result <- data |>
            OmopViewer::filterData("summarise_proportion_of_patients_covered", input)
          DrugUtilisation::plotProportionOfPatientsCovered(
            result
          )
        })
        output$summarise_proportion_of_patients_covered_ggplot2_31 <- shiny::renderPlot({
          createOutput31()
        })
        output$summarise_proportion_of_patients_covered_ggplot2_31_download <- shiny::downloadHandler(
          filename = paste0("output_ggplot2_summarise_proportion_of_patients_covered.", "png"),
          content = function(file) {
            obj <- createOutput31()
            ggplot2::ggsave(
              filename = file,
              plot = obj,
              width = as.numeric(input$summarise_proportion_of_patients_covered_ggplot2_31_download_width),
              height = as.numeric(input$summarise_proportion_of_patients_covered_ggplot2_31_download_height),
              units = input$summarise_proportion_of_patients_covered_ggplot2_31_download_units,
              dpi = as.numeric(input$summarise_proportion_of_patients_covered_ggplot2_31_download_dpi)
            )
          }
        )
      
      
        # summarise_treatment -----
        ## tidy summarise_treatment -----
        getTidyDataSummariseTreatment <- shiny::reactive({
          res <- data |>
            OmopViewer::filterData("summarise_treatment", input) |>
            OmopViewer::tidyData()
      
          # columns to eliminate
          colsEliminate <- colnames(res)
          colsEliminate <- colsEliminate[!colsEliminate %in% c(
            input$summarise_treatment_tidy_columns, "variable_name", "variable_level",
            "estimate_name", "estimate_type", "estimate_value"
          )]
      
          # pivot
          pivot <- input$summarise_treatment_tidy_pivot
          if (pivot != "none") {
            vars <- switch(pivot,
              "estimates" = "estimate_name",
              "estimates and variables" = c("variable_name", "variable_level", "estimate_name")
            )
            res <- res |>
              visOmopResults::pivotEstimates(pivotEstimatesBy = vars)
          }
      
          res |>
            dplyr::select(!dplyr::all_of(colsEliminate))
        })
        output$summarise_treatment_tidy <- DT::renderDT({
          DT::datatable(
            getTidyDataSummariseTreatment(),
            options = list(scrollX = TRUE),
            rownames = FALSE
          )
        })
        output$summarise_treatment_tidy_download <- shiny::downloadHandler(
          filename = "tidy_summarise_treatment.csv",
          content = function(file) {
            getTidyDataSummariseTreatment() |>
              readr::write_csv(file = file)
          }
        )
        ## output summarise_treatment -----
        ## output 32 -----
        createOutput32 <- shiny::reactive({
          result <- data |>
            OmopViewer::filterData("summarise_treatment", input)
          DrugUtilisation::tableTreatment(
            result
          )
        })
        output$summarise_treatment_gt_32 <- gt::render_gt({
          createOutput32()
        })
        output$summarise_treatment_gt_32_download <- shiny::downloadHandler(
          filename = paste0("output_gt_summarise_treatment.", input$summarise_treatment_gt_32_download_type),
          content = function(file) {
            obj <- createOutput32()
            gt::gtsave(data = obj, filename = file)
          }
        )
      
        ## output 33 -----
        createOutput33 <- shiny::reactive({
          result <- data |>
            OmopViewer::filterData("summarise_treatment", input)
          DrugUtilisation::plotTreatment(
            result
          )
        })
        output$summarise_treatment_ggplot2_33 <- shiny::renderPlot({
          createOutput33()
        })
        output$summarise_treatment_ggplot2_33_download <- shiny::downloadHandler(
          filename = paste0("output_ggplot2_summarise_treatment.", "png"),
          content = function(file) {
            obj <- createOutput33()
            ggplot2::ggsave(
              filename = file,
              plot = obj,
              width = as.numeric(input$summarise_treatment_ggplot2_33_download_width),
              height = as.numeric(input$summarise_treatment_ggplot2_33_download_height),
              units = input$summarise_treatment_ggplot2_33_download_units,
              dpi = as.numeric(input$summarise_treatment_ggplot2_33_download_dpi)
            )
          }
        )
      }

---

    Code
      cat(global, sep = "\n")
    Output
      # Generated by OmopViewer 0.1.0
      # Be careful editing this file
      
      library(DT)
      library(DrugUtilisation)
      library(OmopViewer)
      library(bslib)
      library(dplyr)
      library(ggplot2)
      library(gt)
      library(here)
      library(readr)
      library(shiny)
      library(visOmopResults)
      
      data <- OmopViewer::importSummarisedResult(here::here("data")) |>
        OmopViewer::correctSettings()

---

    Code
      cat(ui, sep = "\n")
    Output
      # Generated by OmopViewer 0.1.0
      # Be careful editing this file
      
      ui <- bslib::page_navbar(
        title = shiny::tags$span(
          shiny::tags$img(
            src = "ohdsi_logo.svg",
            width = "auto",
            height = "46px",
            class = "me-3",
            alt = "logo"
          ),
          ""
        ),
        bslib::nav_panel(
          title = "Background",
          icon = shiny::icon("disease"),
          OmopViewer::cardFromMd("background.md")
        ),
        bslib::nav_panel(
          title = "Dose coverage",
          icon = shiny::icon("pills"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "summarise_dose_coverage_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_dose_coverage_grouping_ingredient_name",
                    label = "Ingredient name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_dose_coverage_grouping_unit",
                    label = "Unit",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_dose_coverage_grouping_route",
                    label = "Route",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_dose_coverage_grouping_pattern_id",
                    label = "Pattern id",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "summarise_dose_coverage_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "summarise_dose_coverage_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "summarise_dose_coverage_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_dose_coverage_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "summarise_dose_coverage_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("summarise_dose_coverage_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table dose coverage",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "summarise_dose_coverage_gt_24_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "summarise_dose_coverage_gt_24_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(,
                      position = "right"
                    ),
                    gt::gt_output("summarise_dose_coverage_gt_24")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_panel(
          title = "Drug restart",
          icon = shiny::icon("tablets"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "Settings",
                  shiny::selectizeInput(
                    inputId = "summarise_drug_restart_settings_restrict_to_first_discontinuation",
                    label = "Restrict to first discontinuation",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "summarise_drug_restart_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_drug_restart_grouping_cohort_name",
                    label = "Cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_drug_restart_grouping_age_group",
                    label = "Age group",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_drug_restart_grouping_sex",
                    label = "Sex",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "summarise_drug_restart_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "summarise_drug_restart_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "summarise_drug_restart_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_drug_restart_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "summarise_drug_restart_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("summarise_drug_restart_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table drug restart",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "summarise_drug_restart_gt_25_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "summarise_drug_restart_gt_25_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(,
                      position = "right"
                    ),
                    gt::gt_output("summarise_drug_restart_gt_25")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Plot drug restart",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::numericInput(
                        inputId = "summarise_drug_restart_ggplot2_26_download_width",
                        label = "Width",
                        value = 15
                      ),
                      shiny::numericInput(
                        inputId = "summarise_drug_restart_ggplot2_26_download_height",
                        label = "Height",
                        value = 10
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_drug_restart_ggplot2_26_download_units",
                        label = "Units",
                        selected = "cm",
                        choices = c("px", "cm", "inch"),
                        multiple = FALSE
                      ),
                      shiny::numericInput(
                        inputId = "summarise_drug_restart_ggplot2_26_download_dpi",
                        label = "dpi",
                        value = 300
                      ),
                      shiny::downloadButton(outputId = "summarise_drug_restart_ggplot2_26_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(,
                      position = "right"
                    ),
                    shiny::plotOutput("summarise_drug_restart_ggplot2_26")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_panel(
          title = "Drug utilisation",
          icon = shiny::icon("capsules"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "summarise_drug_utilisation_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_drug_utilisation_grouping_cohort_name",
                    label = "Cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_drug_utilisation_grouping_age_group",
                    label = "Age group",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_drug_utilisation_grouping_sex",
                    label = "Sex",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_drug_utilisation_grouping_concept_set",
                    label = "Concept set",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "summarise_drug_utilisation_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "summarise_drug_utilisation_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "summarise_drug_utilisation_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_drug_utilisation_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "summarise_drug_utilisation_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("summarise_drug_utilisation_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table drug utilisation",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "summarise_drug_utilisation_gt_27_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "summarise_drug_utilisation_gt_27_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(,
                      position = "right"
                    ),
                    gt::gt_output("summarise_drug_utilisation_gt_27")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_panel(
          title = "Indication",
          icon = shiny::icon("disease"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "summarise_indication_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_indication_grouping_cohort_name",
                    label = "Cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "summarise_indication_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "summarise_indication_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "summarise_indication_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_indication_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "summarise_indication_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("summarise_indication_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table indication",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "summarise_indication_gt_28_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "summarise_indication_gt_28_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(,
                      position = "right"
                    ),
                    gt::gt_output("summarise_indication_gt_28")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Plot indication",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::numericInput(
                        inputId = "summarise_indication_ggplot2_29_download_width",
                        label = "Width",
                        value = 15
                      ),
                      shiny::numericInput(
                        inputId = "summarise_indication_ggplot2_29_download_height",
                        label = "Height",
                        value = 10
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_indication_ggplot2_29_download_units",
                        label = "Units",
                        selected = "cm",
                        choices = c("px", "cm", "inch"),
                        multiple = FALSE
                      ),
                      shiny::numericInput(
                        inputId = "summarise_indication_ggplot2_29_download_dpi",
                        label = "dpi",
                        value = 300
                      ),
                      shiny::downloadButton(outputId = "summarise_indication_ggplot2_29_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(,
                      position = "right"
                    ),
                    shiny::plotOutput("summarise_indication_ggplot2_29")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_panel(
          title = "Proportion of patients covered",
          icon = shiny::icon("chart-gantt"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "summarise_proportion_of_patients_covered_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_proportion_of_patients_covered_grouping_cohort",
                    label = "Cohort",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_proportion_of_patients_covered_grouping_age_group",
                    label = "Age group",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_proportion_of_patients_covered_grouping_sex",
                    label = "Sex",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_proportion_of_patients_covered_grouping_time",
                    label = "Time",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "summarise_proportion_of_patients_covered_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "summarise_proportion_of_patients_covered_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "summarise_proportion_of_patients_covered_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_proportion_of_patients_covered_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "summarise_proportion_of_patients_covered_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("summarise_proportion_of_patients_covered_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table PPC",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "summarise_proportion_of_patients_covered_gt_30_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "summarise_proportion_of_patients_covered_gt_30_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(,
                      position = "right"
                    ),
                    gt::gt_output("summarise_proportion_of_patients_covered_gt_30")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Plot PPC",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::numericInput(
                        inputId = "summarise_proportion_of_patients_covered_ggplot2_31_download_width",
                        label = "Width",
                        value = 15
                      ),
                      shiny::numericInput(
                        inputId = "summarise_proportion_of_patients_covered_ggplot2_31_download_height",
                        label = "Height",
                        value = 10
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_proportion_of_patients_covered_ggplot2_31_download_units",
                        label = "Units",
                        selected = "cm",
                        choices = c("px", "cm", "inch"),
                        multiple = FALSE
                      ),
                      shiny::numericInput(
                        inputId = "summarise_proportion_of_patients_covered_ggplot2_31_download_dpi",
                        label = "dpi",
                        value = 300
                      ),
                      shiny::downloadButton(outputId = "summarise_proportion_of_patients_covered_ggplot2_31_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(,
                      position = "right"
                    ),
                    shiny::plotOutput("summarise_proportion_of_patients_covered_ggplot2_31")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_panel(
          title = "Alternative treatments",
          icon = shiny::icon("chart-bar"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "summarise_treatment_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_treatment_grouping_cohort_name",
                    label = "Cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_treatment_grouping_age_group",
                    label = "Age group",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_treatment_grouping_sex",
                    label = "Sex",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_treatment_grouping_window_name",
                    label = "Window name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "summarise_treatment_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "summarise_treatment_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "summarise_treatment_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_treatment_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "summarise_treatment_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("summarise_treatment_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table treatments",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "summarise_treatment_gt_32_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "summarise_treatment_gt_32_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(,
                      position = "right"
                    ),
                    gt::gt_output("summarise_treatment_gt_32")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Plot treatments",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::numericInput(
                        inputId = "summarise_treatment_ggplot2_33_download_width",
                        label = "Width",
                        value = 15
                      ),
                      shiny::numericInput(
                        inputId = "summarise_treatment_ggplot2_33_download_height",
                        label = "Height",
                        value = 10
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_treatment_ggplot2_33_download_units",
                        label = "Units",
                        selected = "cm",
                        choices = c("px", "cm", "inch"),
                        multiple = FALSE
                      ),
                      shiny::numericInput(
                        inputId = "summarise_treatment_ggplot2_33_download_dpi",
                        label = "dpi",
                        value = 300
                      ),
                      shiny::downloadButton(outputId = "summarise_treatment_ggplot2_33_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(,
                      position = "right"
                    ),
                    shiny::plotOutput("summarise_treatment_ggplot2_33")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_spacer(),
        bslib::nav_item(
          bslib::popover(
            shiny::icon("download"),
            shiny::downloadButton(
              outputId = "download_raw",
              label = "Download raw data",
              icon = shiny::icon("download")
            )
          )
        ),
        bslib::nav_item(
          bslib::popover(
            shiny::icon("circle-info"),
            shiny::tags$img(
              src = "hds_logo.svg",
              class = "logo-img",
              alt = "Logo",
              height = "auto",
              width = "30%",
              style = "float:right"
            ),
            "This shiny app was generated with ",
            shiny::a(
              "OmopViewer",
              href = "https://github.com/OHDSI/OmopViewer",
              target = "_blank"
            ),
            shiny::strong("v0.1.0")
          )
        ),
        bslib::nav_item(bslib::input_dark_mode(id = "dark_mode", mode = "light"))
      )

# CohortCharacteristics shiny

    Code
      cat(ui, sep = "\n")
    Output
      # Generated by OmopViewer 0.1.0
      # Be careful editing this file
      
      ui <- bslib::page_navbar(
        title = shiny::tags$span(
          shiny::tags$img(
            src = "ohdsi_logo.svg",
            width = "auto",
            height = "46px",
            class = "me-3",
            alt = "logo"
          ),
          ""
        ),
        bslib::nav_panel(
          title = "Background",
          icon = shiny::icon("disease"),
          OmopViewer::cardFromMd("background.md")
        ),
        bslib::nav_panel(
          title = "Summary",
          icon = shiny::icon("file-alt"),
          OmopViewer::cardSummary(data)
        ),
        bslib::nav_panel(
          title = "Cohort characteristics",
          icon = shiny::icon("users-gear"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "Settings",
                  shiny::selectizeInput(
                    inputId = "summarise_characteristics_settings_table_name",
                    label = "Table name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "summarise_characteristics_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_characteristics_grouping_cohort_name",
                    label = "Cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "summarise_characteristics_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "summarise_characteristics_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "summarise_characteristics_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_characteristics_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "summarise_characteristics_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("summarise_characteristics_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table cohort characteristics",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "summarise_characteristics_gt_7_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "summarise_characteristics_gt_7_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      sortable::bucket_list(
                        header = NULL,
                        sortable::add_rank_list(
                          text = "none",
                          labels = c("variable_name", "variable_level", "estimate_name"),
                          input_id = "summarise_characteristics_gt_7_none"
                        ),
                        sortable::add_rank_list(
                          text = "header",
                          labels = c("cdm_name", "cohort_name"),
                          input_id = "summarise_characteristics_gt_7_header"
                        ),
                        sortable::add_rank_list(
                          text = "groupColumn",
                          labels = NULL,
                          input_id = "summarise_characteristics_gt_7_groupColumn"
                        ),
                        sortable::add_rank_list(
                          text = "hide",
                          labels = character(),
                          input_id = "summarise_characteristics_gt_7_hide"
                        )
                      ),
                      position = "right"
                    ),
                    gt::gt_output("summarise_characteristics_gt_7")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Plot characteristics",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::numericInput(
                        inputId = "summarise_characteristics_ggplot2_8_download_width",
                        label = "Width",
                        value = 15
                      ),
                      shiny::numericInput(
                        inputId = "summarise_characteristics_ggplot2_8_download_height",
                        label = "Height",
                        value = 10
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_characteristics_ggplot2_8_download_units",
                        label = "Units",
                        selected = "cm",
                        choices = c("px", "cm", "inch"),
                        multiple = FALSE
                      ),
                      shiny::numericInput(
                        inputId = "summarise_characteristics_ggplot2_8_download_dpi",
                        label = "dpi",
                        value = 300
                      ),
                      shiny::downloadButton(outputId = "summarise_characteristics_ggplot2_8_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_characteristics_ggplot2_8_plotType",
                        label = "plotType",
                        selected = NULL,
                        multiple = FALSE,
                        choices = c("boxplot", "barplot", "scatterplot"),
                        options = list(plugins = "remove_button")
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_characteristics_ggplot2_8_facet",
                        label = "facet",
                        selected = NULL,
                        multiple = TRUE,
                        choices = c("cdm_name", "cohort_name", "variable_name", "variable_level", "estimate_name", "table_name"),
                        options = list(plugins = "remove_button")
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_characteristics_ggplot2_8_colour",
                        label = "colour",
                        selected = NULL,
                        multiple = TRUE,
                        choices = c("cdm_name", "cohort_name", "variable_name", "variable_level", "estimate_name", "table_name"),
                        options = list(plugins = "remove_button")
                      ),
                      position = "right"
                    ),
                    shiny::plotOutput("summarise_characteristics_ggplot2_8")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_panel(
          title = "Cohort Attrition",
          icon = shiny::icon("layer-group"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "Settings",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_attrition_settings_table_name",
                    label = "Table name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_attrition_settings_cohort_definition_id",
                    label = "Cohort definition id",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_attrition_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_attrition_grouping_cohort_name",
                    label = "Cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_attrition_grouping_reason",
                    label = "Reason",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_attrition_grouping_reason_id",
                    label = "Reason id",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_attrition_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_attrition_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "summarise_cohort_attrition_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_attrition_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "summarise_cohort_attrition_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("summarise_cohort_attrition_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table cohort attrition",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_attrition_gt_3_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "summarise_cohort_attrition_gt_3_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      sortable::bucket_list(
                        header = NULL,
                        sortable::add_rank_list(
                          text = "none",
                          labels = "reason",
                          input_id = "summarise_cohort_attrition_gt_3_none"
                        ),
                        sortable::add_rank_list(
                          text = "header",
                          labels = "variable_name",
                          input_id = "summarise_cohort_attrition_gt_3_header"
                        ),
                        sortable::add_rank_list(
                          text = "groupColumn",
                          labels = c("cdm_name", "cohort_name"),
                          input_id = "summarise_cohort_attrition_gt_3_groupColumn"
                        ),
                        sortable::add_rank_list(
                          text = "hide",
                          labels = c("variable_level", "reason_id", "estimate_name"),
                          input_id = "summarise_cohort_attrition_gt_3_hide"
                        )
                      ),
                      position = "right"
                    ),
                    gt::gt_output("summarise_cohort_attrition_gt_3")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Diagram",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::numericInput(
                        inputId = "summarise_cohort_attrition_grViz_4_download_width",
                        label = "Width (px)",
                        value = 15
                      ),
                      shiny::numericInput(
                        inputId = "summarise_cohort_attrition_grViz_4_download_height",
                        label = "Height (px)",
                        value = 10
                      ),
                      shiny::downloadButton(outputId = "summarise_cohort_attrition_grViz_4_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(,
                      position = "right"
                    ),
                    DiagrammeR::grVizOutput("summarise_cohort_attrition_grViz_4")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_panel(
          title = "Cohort count",
          icon = shiny::icon("users"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "Settings",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_count_settings_table_name",
                    label = "Table name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_count_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_count_grouping_cohort_name",
                    label = "Cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_count_grouping_sex",
                    label = "Sex",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_count_grouping_age_group",
                    label = "Age group",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_count_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_count_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "summarise_cohort_count_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_count_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "summarise_cohort_count_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("summarise_cohort_count_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table cohort count",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_count_gt_9_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "summarise_cohort_count_gt_9_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      sortable::bucket_list(
                        header = NULL,
                        sortable::add_rank_list(
                          text = "none",
                          labels = c("cdm_name", "sex", "age_group", "variable_name", "estimate_name"),
                          input_id = "summarise_cohort_count_gt_9_none"
                        ),
                        sortable::add_rank_list(
                          text = "header",
                          labels = "cohort_name",
                          input_id = "summarise_cohort_count_gt_9_header"
                        ),
                        sortable::add_rank_list(
                          text = "groupColumn",
                          labels = NULL,
                          input_id = "summarise_cohort_count_gt_9_groupColumn"
                        ),
                        sortable::add_rank_list(
                          text = "hide",
                          labels = "variable_level",
                          input_id = "summarise_cohort_count_gt_9_hide"
                        )
                      ),
                      position = "right"
                    ),
                    gt::gt_output("summarise_cohort_count_gt_9")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Plot cohort count",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::numericInput(
                        inputId = "summarise_cohort_count_ggplot2_10_download_width",
                        label = "Width",
                        value = 15
                      ),
                      shiny::numericInput(
                        inputId = "summarise_cohort_count_ggplot2_10_download_height",
                        label = "Height",
                        value = 10
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_count_ggplot2_10_download_units",
                        label = "Units",
                        selected = "cm",
                        choices = c("px", "cm", "inch"),
                        multiple = FALSE
                      ),
                      shiny::numericInput(
                        inputId = "summarise_cohort_count_ggplot2_10_download_dpi",
                        label = "dpi",
                        value = 300
                      ),
                      shiny::downloadButton(outputId = "summarise_cohort_count_ggplot2_10_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_count_ggplot2_10_facet",
                        label = "facet",
                        selected = "cdm_name",
                        multiple = TRUE,
                        choices = c("cdm_name", "cohort_name", "sex", "age_group", "variable_name", "variable_level", "estimate_name"),
                        options = list(plugins = "remove_button")
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_count_ggplot2_10_colour",
                        label = "colour",
                        selected = NULL,
                        multiple = TRUE,
                        choices = c("cdm_name", "cohort_name", "sex", "age_group", "variable_name", "variable_level", "estimate_name"),
                        options = list(plugins = "remove_button")
                      ),
                      position = "right"
                    ),
                    shiny::plotOutput("summarise_cohort_count_ggplot2_10")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_panel(
          title = "Cohort overlap",
          icon = shiny::icon("circle-half-stroke"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("Cohort overlap shows the number of subjects that contribute to a pair of cohorts.")
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_overlap_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_overlap_grouping_cohort_name_reference",
                    label = "Cohort name reference",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_overlap_grouping_cohort_name_comparator",
                    label = "Cohort name comparator",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_overlap_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_overlap_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "summarise_cohort_overlap_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_overlap_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "summarise_cohort_overlap_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("summarise_cohort_overlap_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table cohort overlap",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_overlap_gt_1_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "summarise_cohort_overlap_gt_1_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      sortable::bucket_list(
                        header = NULL,
                        sortable::add_rank_list(
                          text = "none",
                          labels = c("cohort_name_reference", "cohort_name_comparator", "estimate_name"),
                          input_id = "summarise_cohort_overlap_gt_1_none"
                        ),
                        sortable::add_rank_list(
                          text = "header",
                          labels = "variable_name",
                          input_id = "summarise_cohort_overlap_gt_1_header"
                        ),
                        sortable::add_rank_list(
                          text = "groupColumn",
                          labels = "cdm_name",
                          input_id = "summarise_cohort_overlap_gt_1_groupColumn"
                        ),
                        sortable::add_rank_list(
                          text = "hide",
                          labels = "variable_level",
                          input_id = "summarise_cohort_overlap_gt_1_hide"
                        )
                      ),
                      shiny::checkboxInput(
                        inputId = "summarise_cohort_overlap_gt_1_uniqueCombinations",
                        label = "uniqueCombinations",
                        value = c(TRUE)
                      ),
                      position = "right"
                    ),
                    gt::gt_output("summarise_cohort_overlap_gt_1")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Plot cohort overlap",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::numericInput(
                        inputId = "summarise_cohort_overlap_ggplot2_2_download_width",
                        label = "Width",
                        value = 15
                      ),
                      shiny::numericInput(
                        inputId = "summarise_cohort_overlap_ggplot2_2_download_height",
                        label = "Height",
                        value = 10
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_overlap_ggplot2_2_download_units",
                        label = "Units",
                        selected = "cm",
                        choices = c("px", "cm", "inch"),
                        multiple = FALSE
                      ),
                      shiny::numericInput(
                        inputId = "summarise_cohort_overlap_ggplot2_2_download_dpi",
                        label = "dpi",
                        value = 300
                      ),
                      shiny::downloadButton(outputId = "summarise_cohort_overlap_ggplot2_2_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_overlap_ggplot2_2_facet",
                        label = "facet",
                        selected = c("cdm_name", "cohort_name_reference"),
                        multiple = TRUE,
                        choices = c("cdm_name", "cohort_name_reference", "cohort_name_comparator", "variable_name", "variable_level", "estimate_name"),
                        options = list(plugins = "remove_button")
                      ),
                      shiny::checkboxInput(
                        inputId = "summarise_cohort_overlap_ggplot2_2_uniqueCombinations",
                        label = "uniqueCombinations",
                        value = c(TRUE)
                      ),
                      position = "right"
                    ),
                    shiny::plotOutput("summarise_cohort_overlap_ggplot2_2")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_panel(
          title = "Cohort timing",
          icon = shiny::icon("chart-simple"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "Settings",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_timing_settings_restrict_to_first_entry",
                    label = "Restrict to first entry",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_timing_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_timing_grouping_cohort_name_reference",
                    label = "Cohort name reference",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_timing_grouping_cohort_name_comparator",
                    label = "Cohort name comparator",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_timing_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_timing_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "summarise_cohort_timing_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_timing_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "summarise_cohort_timing_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("summarise_cohort_timing_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table cohort timing",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_timing_gt_5_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "summarise_cohort_timing_gt_5_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      sortable::bucket_list(
                        header = NULL,
                        sortable::add_rank_list(
                          text = "none",
                          labels = c("cdm_name", "cohort_name_reference", "cohort_name_comparator", "variable_name", "estimate_name"),
                          input_id = "summarise_cohort_timing_gt_5_none"
                        ),
                        sortable::add_rank_list(
                          text = "header",
                          labels = character(),
                          input_id = "summarise_cohort_timing_gt_5_header"
                        ),
                        sortable::add_rank_list(
                          text = "groupColumn",
                          labels = NULL,
                          input_id = "summarise_cohort_timing_gt_5_groupColumn"
                        ),
                        sortable::add_rank_list(
                          text = "hide",
                          labels = "variable_level",
                          input_id = "summarise_cohort_timing_gt_5_hide"
                        )
                      ),
                      shiny::checkboxInput(
                        inputId = "summarise_cohort_timing_gt_5_uniqueCombinations",
                        label = "uniqueCombinations",
                        value = c(TRUE)
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_timing_gt_5_timeScale",
                        label = "timeScale",
                        selected = "days",
                        multiple = FALSE,
                        choices = c("days", "years"),
                        options = list(plugins = "remove_button")
                      ),
                      position = "right"
                    ),
                    gt::gt_output("summarise_cohort_timing_gt_5")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Plot cohort timing",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::numericInput(
                        inputId = "summarise_cohort_timing_ggplot2_6_download_width",
                        label = "Width",
                        value = 15
                      ),
                      shiny::numericInput(
                        inputId = "summarise_cohort_timing_ggplot2_6_download_height",
                        label = "Height",
                        value = 10
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_timing_ggplot2_6_download_units",
                        label = "Units",
                        selected = "cm",
                        choices = c("px", "cm", "inch"),
                        multiple = FALSE
                      ),
                      shiny::numericInput(
                        inputId = "summarise_cohort_timing_ggplot2_6_download_dpi",
                        label = "dpi",
                        value = 300
                      ),
                      shiny::downloadButton(outputId = "summarise_cohort_timing_ggplot2_6_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_timing_ggplot2_6_plotType",
                        label = "plotType",
                        selected = "boxplot",
                        multiple = FALSE,
                        choices = c("boxplot", "density"),
                        options = list(plugins = "remove_button")
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_timing_ggplot2_6_timeScale",
                        label = "timeScale",
                        selected = "days",
                        multiple = FALSE,
                        choices = c("days", "years"),
                        options = list(plugins = "remove_button")
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_timing_ggplot2_6_facet",
                        label = "facet",
                        selected = c("cdm_name", "cohort_name_reference"),
                        multiple = TRUE,
                        choices = c("cdm_name", "cohort_name_reference", "cohort_name_comparator", "variable_name", "variable_level", "estimate_name", "restrict_to_first_entry"),
                        options = list(plugins = "remove_button")
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_timing_ggplot2_6_colour",
                        label = "colour",
                        selected = "cohort_name_comparator",
                        multiple = TRUE,
                        choices = c("cdm_name", "cohort_name_reference", "cohort_name_comparator", "variable_name", "variable_level", "estimate_name", "restrict_to_first_entry"),
                        options = list(plugins = "remove_button")
                      ),
                      shiny::checkboxInput(
                        inputId = "summarise_cohort_timing_ggplot2_6_uniqueCombinations",
                        label = "uniqueCombinations",
                        value = c(TRUE)
                      ),
                      position = "right"
                    ),
                    shiny::plotOutput("summarise_cohort_timing_ggplot2_6")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_panel(
          title = "Large Scale Characteristics",
          icon = shiny::icon("arrow-up-right-dots"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "Settings",
                  shiny::selectizeInput(
                    inputId = "summarise_large_scale_characteristics_settings_table_name",
                    label = "Table name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_large_scale_characteristics_settings_type",
                    label = "Type",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_large_scale_characteristics_settings_analysis",
                    label = "Analysis",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "summarise_large_scale_characteristics_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_large_scale_characteristics_grouping_cohort_name",
                    label = "Cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_large_scale_characteristics_grouping_concept_id",
                    label = "Concept id",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "summarise_large_scale_characteristics_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "summarise_large_scale_characteristics_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "summarise_large_scale_characteristics_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_large_scale_characteristics_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "summarise_large_scale_characteristics_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("summarise_large_scale_characteristics_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Formatted",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "summarise_large_scale_characteristics_gt_0_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "summarise_large_scale_characteristics_gt_0_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      sortable::bucket_list(
                        header = NULL,
                        sortable::add_rank_list(
                          text = "none",
                          labels = c("concept_id", "variable_name", "variable_level", "estimate_name", "table_name", "type", "analysis"),
                          input_id = "summarise_large_scale_characteristics_gt_0_none"
                        ),
                        sortable::add_rank_list(
                          text = "header",
                          labels = "cdm_name",
                          input_id = "summarise_large_scale_characteristics_gt_0_header"
                        ),
                        sortable::add_rank_list(
                          text = "group",
                          labels = "cohort_name",
                          input_id = "summarise_large_scale_characteristics_gt_0_group"
                        ),
                        sortable::add_rank_list(
                          text = "hide",
                          labels = character(),
                          input_id = "summarise_large_scale_characteristics_gt_0_hide"
                        )
                      ),
                      position = "right"
                    ),
                    gt::gt_output("summarise_large_scale_characteristics_gt_0")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_spacer(),
        bslib::nav_item(
          bslib::popover(
            shiny::icon("download"),
            shiny::downloadButton(
              outputId = "download_raw",
              label = "Download raw data",
              icon = shiny::icon("download")
            )
          )
        ),
        bslib::nav_item(
          bslib::popover(
            shiny::icon("circle-info"),
            shiny::tags$img(
              src = "hds_logo.svg",
              class = "logo-img",
              alt = "Logo",
              height = "auto",
              width = "30%",
              style = "float:right"
            ),
            "This shiny app was generated with ",
            shiny::a(
              "OmopViewer",
              href = "https://github.com/OHDSI/OmopViewer",
              target = "_blank"
            ),
            shiny::strong("v0.1.0")
          )
        ),
        bslib::nav_item(bslib::input_dark_mode(id = "dark_mode", mode = "light"))
      )

---

    Code
      cat(server, sep = "\n")
    Output
      # Generated by OmopViewer 0.1.0
      # Be careful editing this file
      
      server <- function(input, output, session) {
        # download raw data -----
        output$download_raw <- shiny::downloadHandler(
          filename = "results.csv",
          content = function(file) {
            OmopViewer::exportSummarisedResult(data, fileName = file)
          }
        )
        # fill selectise variables ----
        shiny::observe({
          choices <- OmopViewer::getChoices(data, flatten = TRUE)
          for (k in seq_along(choices)) {
            shiny::updateSelectizeInput(
              session,
              inputId = names(choices)[k],
              choices = choices[[k]],
              selected = choices[[k]],
              server = TRUE
            )
          }
        })
        # summarise_characteristics -----
        ## tidy summarise_characteristics -----
        getTidyDataSummariseCharacteristics <- shiny::reactive({
          res <- data |>
            OmopViewer::filterData("summarise_characteristics", input) |>
            OmopViewer::tidyData()
      
          # columns to eliminate
          colsEliminate <- colnames(res)
          colsEliminate <- colsEliminate[!colsEliminate %in% c(
            input$summarise_characteristics_tidy_columns, "variable_name", "variable_level",
            "estimate_name", "estimate_type", "estimate_value"
          )]
      
          # pivot
          pivot <- input$summarise_characteristics_tidy_pivot
          if (pivot != "none") {
            vars <- switch(pivot,
              "estimates" = "estimate_name",
              "estimates and variables" = c("variable_name", "variable_level", "estimate_name")
            )
            res <- res |>
              visOmopResults::pivotEstimates(pivotEstimatesBy = vars)
          }
      
          res |>
            dplyr::select(!dplyr::all_of(colsEliminate))
        })
        output$summarise_characteristics_tidy <- DT::renderDT({
          DT::datatable(
            getTidyDataSummariseCharacteristics(),
            options = list(scrollX = TRUE),
            rownames = FALSE
          )
        })
        output$summarise_characteristics_tidy_download <- shiny::downloadHandler(
          filename = "tidy_summarise_characteristics.csv",
          content = function(file) {
            getTidyDataSummariseCharacteristics() |>
              readr::write_csv(file = file)
          }
        )
        ## output summarise_characteristics -----
        ## output 7 -----
        createOutput7 <- shiny::reactive({
          result <- data |>
            OmopViewer::filterData("summarise_characteristics", input)
          CohortCharacteristics::tableCharacteristics(
            result,
            header = input$summarise_characteristics_gt_7_header,
            groupColumn = input$summarise_characteristics_gt_7_groupColumn,
            hide = input$summarise_characteristics_gt_7_hide
          )
        })
        output$summarise_characteristics_gt_7 <- gt::render_gt({
          createOutput7()
        })
        output$summarise_characteristics_gt_7_download <- shiny::downloadHandler(
          filename = paste0("output_gt_summarise_characteristics.", input$summarise_characteristics_gt_7_download_type),
          content = function(file) {
            obj <- createOutput7()
            gt::gtsave(data = obj, filename = file)
          }
        )
      
        ## output 8 -----
        createOutput8 <- shiny::reactive({
          result <- data |>
            OmopViewer::filterData("summarise_characteristics", input)
          CohortCharacteristics::plotCharacteristics(
            result,
            plotType = input$summarise_characteristics_ggplot2_8_plotType,
            facet = input$summarise_characteristics_ggplot2_8_facet,
            colour = input$summarise_characteristics_ggplot2_8_colour
          )
        })
        output$summarise_characteristics_ggplot2_8 <- shiny::renderPlot({
          createOutput8()
        })
        output$summarise_characteristics_ggplot2_8_download <- shiny::downloadHandler(
          filename = paste0("output_ggplot2_summarise_characteristics.", "png"),
          content = function(file) {
            obj <- createOutput8()
            ggplot2::ggsave(
              filename = file,
              plot = obj,
              width = as.numeric(input$summarise_characteristics_ggplot2_8_download_width),
              height = as.numeric(input$summarise_characteristics_ggplot2_8_download_height),
              units = input$summarise_characteristics_ggplot2_8_download_units,
              dpi = as.numeric(input$summarise_characteristics_ggplot2_8_download_dpi)
            )
          }
        )
      
      
        # summarise_cohort_attrition -----
        ## tidy summarise_cohort_attrition -----
        getTidyDataSummariseCohortAttrition <- shiny::reactive({
          res <- data |>
            OmopViewer::filterData("summarise_cohort_attrition", input) |>
            OmopViewer::tidyData()
      
          # columns to eliminate
          colsEliminate <- colnames(res)
          colsEliminate <- colsEliminate[!colsEliminate %in% c(
            input$summarise_cohort_attrition_tidy_columns, "variable_name", "variable_level",
            "estimate_name", "estimate_type", "estimate_value"
          )]
      
          # pivot
          pivot <- input$summarise_cohort_attrition_tidy_pivot
          if (pivot != "none") {
            vars <- switch(pivot,
              "estimates" = "estimate_name",
              "estimates and variables" = c("variable_name", "variable_level", "estimate_name")
            )
            res <- res |>
              visOmopResults::pivotEstimates(pivotEstimatesBy = vars)
          }
      
          res |>
            dplyr::select(!dplyr::all_of(colsEliminate))
        })
        output$summarise_cohort_attrition_tidy <- DT::renderDT({
          DT::datatable(
            getTidyDataSummariseCohortAttrition(),
            options = list(scrollX = TRUE),
            rownames = FALSE
          )
        })
        output$summarise_cohort_attrition_tidy_download <- shiny::downloadHandler(
          filename = "tidy_summarise_cohort_attrition.csv",
          content = function(file) {
            getTidyDataSummariseCohortAttrition() |>
              readr::write_csv(file = file)
          }
        )
        ## output summarise_cohort_attrition -----
        ## output 3 -----
        createOutput3 <- shiny::reactive({
          result <- data |>
            OmopViewer::filterData("summarise_cohort_attrition", input)
          CohortCharacteristics::tableCohortAttrition(
            result,
            header = input$summarise_cohort_attrition_gt_3_header,
            groupColumn = input$summarise_cohort_attrition_gt_3_groupColumn,
            hide = input$summarise_cohort_attrition_gt_3_hide
          )
        })
        output$summarise_cohort_attrition_gt_3 <- gt::render_gt({
          createOutput3()
        })
        output$summarise_cohort_attrition_gt_3_download <- shiny::downloadHandler(
          filename = paste0("output_gt_summarise_cohort_attrition.", input$summarise_cohort_attrition_gt_3_download_type),
          content = function(file) {
            obj <- createOutput3()
            gt::gtsave(data = obj, filename = file)
          }
        )
      
        ## output 4 -----
        createOutput4 <- shiny::reactive({
          result <- data |>
            OmopViewer::filterData("summarise_cohort_attrition", input)
          CohortCharacteristics::plotCohortAttrition(
            result
          )
        })
        output$summarise_cohort_attrition_grViz_4 <- DiagrammeR::renderGrViz({
          createOutput4()
        })
        output$summarise_cohort_attrition_grViz_4_download <- shiny::downloadHandler(
          filename = paste0("output_grViz_summarise_cohort_attrition.", "png"),
          content = function(file) {
            obj <- createOutput4()
            DiagrammeR::export_graph(
              graph = obj,
              file_name = file,
              fily_type = "png",
              width = as.numeric(input$summarise_cohort_attrition_grViz_4_download_width),
              height = as.numeric(input$summarise_cohort_attrition_grViz_4_download_height)
            )
          }
        )
      
      
        # summarise_cohort_count -----
        ## tidy summarise_cohort_count -----
        getTidyDataSummariseCohortCount <- shiny::reactive({
          res <- data |>
            OmopViewer::filterData("summarise_cohort_count", input) |>
            OmopViewer::tidyData()
      
          # columns to eliminate
          colsEliminate <- colnames(res)
          colsEliminate <- colsEliminate[!colsEliminate %in% c(
            input$summarise_cohort_count_tidy_columns, "variable_name", "variable_level",
            "estimate_name", "estimate_type", "estimate_value"
          )]
      
          # pivot
          pivot <- input$summarise_cohort_count_tidy_pivot
          if (pivot != "none") {
            vars <- switch(pivot,
              "estimates" = "estimate_name",
              "estimates and variables" = c("variable_name", "variable_level", "estimate_name")
            )
            res <- res |>
              visOmopResults::pivotEstimates(pivotEstimatesBy = vars)
          }
      
          res |>
            dplyr::select(!dplyr::all_of(colsEliminate))
        })
        output$summarise_cohort_count_tidy <- DT::renderDT({
          DT::datatable(
            getTidyDataSummariseCohortCount(),
            options = list(scrollX = TRUE),
            rownames = FALSE
          )
        })
        output$summarise_cohort_count_tidy_download <- shiny::downloadHandler(
          filename = "tidy_summarise_cohort_count.csv",
          content = function(file) {
            getTidyDataSummariseCohortCount() |>
              readr::write_csv(file = file)
          }
        )
        ## output summarise_cohort_count -----
        ## output 9 -----
        createOutput9 <- shiny::reactive({
          result <- data |>
            OmopViewer::filterData("summarise_cohort_count", input)
          CohortCharacteristics::tableCohortCount(
            result,
            header = input$summarise_cohort_count_gt_9_header,
            groupColumn = input$summarise_cohort_count_gt_9_groupColumn,
            hide = input$summarise_cohort_count_gt_9_hide
          )
        })
        output$summarise_cohort_count_gt_9 <- gt::render_gt({
          createOutput9()
        })
        output$summarise_cohort_count_gt_9_download <- shiny::downloadHandler(
          filename = paste0("output_gt_summarise_cohort_count.", input$summarise_cohort_count_gt_9_download_type),
          content = function(file) {
            obj <- createOutput9()
            gt::gtsave(data = obj, filename = file)
          }
        )
      
        ## output 10 -----
        createOutput10 <- shiny::reactive({
          result <- data |>
            OmopViewer::filterData("summarise_cohort_count", input)
          CohortCharacteristics::plotCohortCount(
            result,
            facet = input$summarise_cohort_count_ggplot2_10_facet,
            colour = input$summarise_cohort_count_ggplot2_10_colour
          )
        })
        output$summarise_cohort_count_ggplot2_10 <- shiny::renderPlot({
          createOutput10()
        })
        output$summarise_cohort_count_ggplot2_10_download <- shiny::downloadHandler(
          filename = paste0("output_ggplot2_summarise_cohort_count.", "png"),
          content = function(file) {
            obj <- createOutput10()
            ggplot2::ggsave(
              filename = file,
              plot = obj,
              width = as.numeric(input$summarise_cohort_count_ggplot2_10_download_width),
              height = as.numeric(input$summarise_cohort_count_ggplot2_10_download_height),
              units = input$summarise_cohort_count_ggplot2_10_download_units,
              dpi = as.numeric(input$summarise_cohort_count_ggplot2_10_download_dpi)
            )
          }
        )
      
      
        # summarise_cohort_overlap -----
        ## tidy summarise_cohort_overlap -----
        getTidyDataSummariseCohortOverlap <- shiny::reactive({
          res <- data |>
            OmopViewer::filterData("summarise_cohort_overlap", input) |>
            OmopViewer::tidyData()
      
          # columns to eliminate
          colsEliminate <- colnames(res)
          colsEliminate <- colsEliminate[!colsEliminate %in% c(
            input$summarise_cohort_overlap_tidy_columns, "variable_name", "variable_level",
            "estimate_name", "estimate_type", "estimate_value"
          )]
      
          # pivot
          pivot <- input$summarise_cohort_overlap_tidy_pivot
          if (pivot != "none") {
            vars <- switch(pivot,
              "estimates" = "estimate_name",
              "estimates and variables" = c("variable_name", "variable_level", "estimate_name")
            )
            res <- res |>
              visOmopResults::pivotEstimates(pivotEstimatesBy = vars)
          }
      
          res |>
            dplyr::select(!dplyr::all_of(colsEliminate))
        })
        output$summarise_cohort_overlap_tidy <- DT::renderDT({
          DT::datatable(
            getTidyDataSummariseCohortOverlap(),
            options = list(scrollX = TRUE),
            rownames = FALSE
          )
        })
        output$summarise_cohort_overlap_tidy_download <- shiny::downloadHandler(
          filename = "tidy_summarise_cohort_overlap.csv",
          content = function(file) {
            getTidyDataSummariseCohortOverlap() |>
              readr::write_csv(file = file)
          }
        )
        ## output summarise_cohort_overlap -----
        ## output 1 -----
        createOutput1 <- shiny::reactive({
          result <- data |>
            OmopViewer::filterData("summarise_cohort_overlap", input)
          CohortCharacteristics::tableCohortOverlap(
            result,
            uniqueCombinations = input$summarise_cohort_overlap_gt_1_uniqueCombinations,
            header = input$summarise_cohort_overlap_gt_1_header,
            groupColumn = input$summarise_cohort_overlap_gt_1_groupColumn,
            hide = input$summarise_cohort_overlap_gt_1_hide
          )
        })
        output$summarise_cohort_overlap_gt_1 <- gt::render_gt({
          createOutput1()
        })
        output$summarise_cohort_overlap_gt_1_download <- shiny::downloadHandler(
          filename = paste0("output_gt_summarise_cohort_overlap.", input$summarise_cohort_overlap_gt_1_download_type),
          content = function(file) {
            obj <- createOutput1()
            gt::gtsave(data = obj, filename = file)
          }
        )
      
        ## output 2 -----
        createOutput2 <- shiny::reactive({
          result <- data |>
            OmopViewer::filterData("summarise_cohort_overlap", input)
          CohortCharacteristics::plotCohortOverlap(
            result,
            facet = input$summarise_cohort_overlap_ggplot2_2_facet,
            uniqueCombinations = input$summarise_cohort_overlap_ggplot2_2_uniqueCombinations
          )
        })
        output$summarise_cohort_overlap_ggplot2_2 <- shiny::renderPlot({
          createOutput2()
        })
        output$summarise_cohort_overlap_ggplot2_2_download <- shiny::downloadHandler(
          filename = paste0("output_ggplot2_summarise_cohort_overlap.", "png"),
          content = function(file) {
            obj <- createOutput2()
            ggplot2::ggsave(
              filename = file,
              plot = obj,
              width = as.numeric(input$summarise_cohort_overlap_ggplot2_2_download_width),
              height = as.numeric(input$summarise_cohort_overlap_ggplot2_2_download_height),
              units = input$summarise_cohort_overlap_ggplot2_2_download_units,
              dpi = as.numeric(input$summarise_cohort_overlap_ggplot2_2_download_dpi)
            )
          }
        )
      
      
        # summarise_cohort_timing -----
        ## tidy summarise_cohort_timing -----
        getTidyDataSummariseCohortTiming <- shiny::reactive({
          res <- data |>
            OmopViewer::filterData("summarise_cohort_timing", input) |>
            OmopViewer::tidyData()
      
          # columns to eliminate
          colsEliminate <- colnames(res)
          colsEliminate <- colsEliminate[!colsEliminate %in% c(
            input$summarise_cohort_timing_tidy_columns, "variable_name", "variable_level",
            "estimate_name", "estimate_type", "estimate_value"
          )]
      
          # pivot
          pivot <- input$summarise_cohort_timing_tidy_pivot
          if (pivot != "none") {
            vars <- switch(pivot,
              "estimates" = "estimate_name",
              "estimates and variables" = c("variable_name", "variable_level", "estimate_name")
            )
            res <- res |>
              visOmopResults::pivotEstimates(pivotEstimatesBy = vars)
          }
      
          res |>
            dplyr::select(!dplyr::all_of(colsEliminate))
        })
        output$summarise_cohort_timing_tidy <- DT::renderDT({
          DT::datatable(
            getTidyDataSummariseCohortTiming(),
            options = list(scrollX = TRUE),
            rownames = FALSE
          )
        })
        output$summarise_cohort_timing_tidy_download <- shiny::downloadHandler(
          filename = "tidy_summarise_cohort_timing.csv",
          content = function(file) {
            getTidyDataSummariseCohortTiming() |>
              readr::write_csv(file = file)
          }
        )
        ## output summarise_cohort_timing -----
        ## output 5 -----
        createOutput5 <- shiny::reactive({
          result <- data |>
            OmopViewer::filterData("summarise_cohort_timing", input)
          CohortCharacteristics::tableCohortTiming(
            result,
            uniqueCombinations = input$summarise_cohort_timing_gt_5_uniqueCombinations,
            timeScale = input$summarise_cohort_timing_gt_5_timeScale,
            header = input$summarise_cohort_timing_gt_5_header,
            groupColumn = input$summarise_cohort_timing_gt_5_groupColumn,
            hide = input$summarise_cohort_timing_gt_5_hide
          )
        })
        output$summarise_cohort_timing_gt_5 <- gt::render_gt({
          createOutput5()
        })
        output$summarise_cohort_timing_gt_5_download <- shiny::downloadHandler(
          filename = paste0("output_gt_summarise_cohort_timing.", input$summarise_cohort_timing_gt_5_download_type),
          content = function(file) {
            obj <- createOutput5()
            gt::gtsave(data = obj, filename = file)
          }
        )
      
        ## output 6 -----
        createOutput6 <- shiny::reactive({
          result <- data |>
            OmopViewer::filterData("summarise_cohort_timing", input)
          CohortCharacteristics::plotCohortTiming(
            result,
            plotType = input$summarise_cohort_timing_ggplot2_6_plotType,
            timeScale = input$summarise_cohort_timing_ggplot2_6_timeScale,
            facet = input$summarise_cohort_timing_ggplot2_6_facet,
            colour = input$summarise_cohort_timing_ggplot2_6_colour,
            uniqueCombinations = input$summarise_cohort_timing_ggplot2_6_uniqueCombinations
          )
        })
        output$summarise_cohort_timing_ggplot2_6 <- shiny::renderPlot({
          createOutput6()
        })
        output$summarise_cohort_timing_ggplot2_6_download <- shiny::downloadHandler(
          filename = paste0("output_ggplot2_summarise_cohort_timing.", "png"),
          content = function(file) {
            obj <- createOutput6()
            ggplot2::ggsave(
              filename = file,
              plot = obj,
              width = as.numeric(input$summarise_cohort_timing_ggplot2_6_download_width),
              height = as.numeric(input$summarise_cohort_timing_ggplot2_6_download_height),
              units = input$summarise_cohort_timing_ggplot2_6_download_units,
              dpi = as.numeric(input$summarise_cohort_timing_ggplot2_6_download_dpi)
            )
          }
        )
      
      
        # summarise_large_scale_characteristics -----
        ## tidy summarise_large_scale_characteristics -----
        getTidyDataSummariseLargeScaleCharacteristics <- shiny::reactive({
          res <- data |>
            OmopViewer::filterData("summarise_large_scale_characteristics", input) |>
            OmopViewer::tidyData()
      
          # columns to eliminate
          colsEliminate <- colnames(res)
          colsEliminate <- colsEliminate[!colsEliminate %in% c(
            input$summarise_large_scale_characteristics_tidy_columns, "variable_name", "variable_level",
            "estimate_name", "estimate_type", "estimate_value"
          )]
      
          # pivot
          pivot <- input$summarise_large_scale_characteristics_tidy_pivot
          if (pivot != "none") {
            vars <- switch(pivot,
              "estimates" = "estimate_name",
              "estimates and variables" = c("variable_name", "variable_level", "estimate_name")
            )
            res <- res |>
              visOmopResults::pivotEstimates(pivotEstimatesBy = vars)
          }
      
          res |>
            dplyr::select(!dplyr::all_of(colsEliminate))
        })
        output$summarise_large_scale_characteristics_tidy <- DT::renderDT({
          DT::datatable(
            getTidyDataSummariseLargeScaleCharacteristics(),
            options = list(scrollX = TRUE),
            rownames = FALSE
          )
        })
        output$summarise_large_scale_characteristics_tidy_download <- shiny::downloadHandler(
          filename = "tidy_summarise_large_scale_characteristics.csv",
          content = function(file) {
            getTidyDataSummariseLargeScaleCharacteristics() |>
              readr::write_csv(file = file)
          }
        )
        ## output summarise_large_scale_characteristics -----
        ## output 0 -----
        createOutput0 <- shiny::reactive({
          result <- data |>
            OmopViewer::filterData("summarise_large_scale_characteristics", input)
          OmopViewer::omopViewerTable(
            result,
            header = input$summarise_large_scale_characteristics_gt_0_header,
            group = input$summarise_large_scale_characteristics_gt_0_group,
            hide = input$summarise_large_scale_characteristics_gt_0_hide
          )
        })
        output$summarise_large_scale_characteristics_gt_0 <- gt::render_gt({
          createOutput0()
        })
        output$summarise_large_scale_characteristics_gt_0_download <- shiny::downloadHandler(
          filename = paste0("output_gt_summarise_large_scale_characteristics.", input$summarise_large_scale_characteristics_gt_0_download_type),
          content = function(file) {
            obj <- createOutput0()
            gt::gtsave(data = obj, filename = file)
          }
        )
      }

---

    Code
      cat(global, sep = "\n")
    Output
      # Generated by OmopViewer 0.1.0
      # Be careful editing this file
      
      library(CohortCharacteristics)
      library(DT)
      library(DiagrammeR)
      library(OmopViewer)
      library(bslib)
      library(dplyr)
      library(ggplot2)
      library(gt)
      library(here)
      library(readr)
      library(shiny)
      library(sortable)
      library(visOmopResults)
      
      data <- OmopViewer::importSummarisedResult(here::here("data")) |>
        OmopViewer::correctSettings()

---

    Code
      cat(ui, sep = "\n")
    Output
      # Generated by OmopViewer 0.1.0
      # Be careful editing this file
      
      ui <- bslib::page_navbar(
        title = shiny::tags$span(
          shiny::tags$img(
            src = "ohdsi_logo.svg",
            width = "auto",
            height = "46px",
            class = "me-3",
            alt = "logo"
          ),
          ""
        ),
        bslib::nav_panel(
          title = "Background",
          icon = shiny::icon("disease"),
          OmopViewer::cardFromMd("background.md")
        ),
        bslib::nav_panel(
          title = "Cohort characteristics",
          icon = shiny::icon("users-gear"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "Settings",
                  shiny::selectizeInput(
                    inputId = "summarise_characteristics_settings_table_name",
                    label = "Table name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "summarise_characteristics_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_characteristics_grouping_cohort_name",
                    label = "Cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "summarise_characteristics_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "summarise_characteristics_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "summarise_characteristics_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_characteristics_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "summarise_characteristics_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("summarise_characteristics_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table cohort characteristics",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "summarise_characteristics_gt_7_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "summarise_characteristics_gt_7_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      sortable::bucket_list(
                        header = NULL,
                        sortable::add_rank_list(
                          text = "none",
                          labels = c("variable_name", "variable_level", "estimate_name"),
                          input_id = "summarise_characteristics_gt_7_none"
                        ),
                        sortable::add_rank_list(
                          text = "header",
                          labels = c("cdm_name", "cohort_name"),
                          input_id = "summarise_characteristics_gt_7_header"
                        ),
                        sortable::add_rank_list(
                          text = "groupColumn",
                          labels = NULL,
                          input_id = "summarise_characteristics_gt_7_groupColumn"
                        ),
                        sortable::add_rank_list(
                          text = "hide",
                          labels = character(),
                          input_id = "summarise_characteristics_gt_7_hide"
                        )
                      ),
                      position = "right"
                    ),
                    gt::gt_output("summarise_characteristics_gt_7")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Plot characteristics",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::numericInput(
                        inputId = "summarise_characteristics_ggplot2_8_download_width",
                        label = "Width",
                        value = 15
                      ),
                      shiny::numericInput(
                        inputId = "summarise_characteristics_ggplot2_8_download_height",
                        label = "Height",
                        value = 10
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_characteristics_ggplot2_8_download_units",
                        label = "Units",
                        selected = "cm",
                        choices = c("px", "cm", "inch"),
                        multiple = FALSE
                      ),
                      shiny::numericInput(
                        inputId = "summarise_characteristics_ggplot2_8_download_dpi",
                        label = "dpi",
                        value = 300
                      ),
                      shiny::downloadButton(outputId = "summarise_characteristics_ggplot2_8_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_characteristics_ggplot2_8_plotType",
                        label = "plotType",
                        selected = NULL,
                        multiple = FALSE,
                        choices = c("boxplot", "barplot", "scatterplot"),
                        options = list(plugins = "remove_button")
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_characteristics_ggplot2_8_facet",
                        label = "facet",
                        selected = NULL,
                        multiple = TRUE,
                        choices = c("cdm_name", "cohort_name", "variable_name", "variable_level", "estimate_name", "table_name"),
                        options = list(plugins = "remove_button")
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_characteristics_ggplot2_8_colour",
                        label = "colour",
                        selected = NULL,
                        multiple = TRUE,
                        choices = c("cdm_name", "cohort_name", "variable_name", "variable_level", "estimate_name", "table_name"),
                        options = list(plugins = "remove_button")
                      ),
                      position = "right"
                    ),
                    shiny::plotOutput("summarise_characteristics_ggplot2_8")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_panel(
          title = "Cohort Attrition",
          icon = shiny::icon("layer-group"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "Settings",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_attrition_settings_table_name",
                    label = "Table name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_attrition_settings_cohort_definition_id",
                    label = "Cohort definition id",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_attrition_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_attrition_grouping_cohort_name",
                    label = "Cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_attrition_grouping_reason",
                    label = "Reason",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_attrition_grouping_reason_id",
                    label = "Reason id",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_attrition_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_attrition_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "summarise_cohort_attrition_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_attrition_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "summarise_cohort_attrition_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("summarise_cohort_attrition_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table cohort attrition",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_attrition_gt_3_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "summarise_cohort_attrition_gt_3_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      sortable::bucket_list(
                        header = NULL,
                        sortable::add_rank_list(
                          text = "none",
                          labels = "reason",
                          input_id = "summarise_cohort_attrition_gt_3_none"
                        ),
                        sortable::add_rank_list(
                          text = "header",
                          labels = "variable_name",
                          input_id = "summarise_cohort_attrition_gt_3_header"
                        ),
                        sortable::add_rank_list(
                          text = "groupColumn",
                          labels = c("cdm_name", "cohort_name"),
                          input_id = "summarise_cohort_attrition_gt_3_groupColumn"
                        ),
                        sortable::add_rank_list(
                          text = "hide",
                          labels = c("variable_level", "reason_id", "estimate_name"),
                          input_id = "summarise_cohort_attrition_gt_3_hide"
                        )
                      ),
                      position = "right"
                    ),
                    gt::gt_output("summarise_cohort_attrition_gt_3")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Diagram",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::numericInput(
                        inputId = "summarise_cohort_attrition_grViz_4_download_width",
                        label = "Width (px)",
                        value = 15
                      ),
                      shiny::numericInput(
                        inputId = "summarise_cohort_attrition_grViz_4_download_height",
                        label = "Height (px)",
                        value = 10
                      ),
                      shiny::downloadButton(outputId = "summarise_cohort_attrition_grViz_4_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(,
                      position = "right"
                    ),
                    DiagrammeR::grVizOutput("summarise_cohort_attrition_grViz_4")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_panel(
          title = "Cohort count",
          icon = shiny::icon("users"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "Settings",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_count_settings_table_name",
                    label = "Table name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_count_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_count_grouping_cohort_name",
                    label = "Cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_count_grouping_sex",
                    label = "Sex",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_count_grouping_age_group",
                    label = "Age group",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_count_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_count_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "summarise_cohort_count_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_count_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "summarise_cohort_count_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("summarise_cohort_count_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table cohort count",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_count_gt_9_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "summarise_cohort_count_gt_9_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      sortable::bucket_list(
                        header = NULL,
                        sortable::add_rank_list(
                          text = "none",
                          labels = c("cdm_name", "sex", "age_group", "variable_name", "estimate_name"),
                          input_id = "summarise_cohort_count_gt_9_none"
                        ),
                        sortable::add_rank_list(
                          text = "header",
                          labels = "cohort_name",
                          input_id = "summarise_cohort_count_gt_9_header"
                        ),
                        sortable::add_rank_list(
                          text = "groupColumn",
                          labels = NULL,
                          input_id = "summarise_cohort_count_gt_9_groupColumn"
                        ),
                        sortable::add_rank_list(
                          text = "hide",
                          labels = "variable_level",
                          input_id = "summarise_cohort_count_gt_9_hide"
                        )
                      ),
                      position = "right"
                    ),
                    gt::gt_output("summarise_cohort_count_gt_9")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Plot cohort count",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::numericInput(
                        inputId = "summarise_cohort_count_ggplot2_10_download_width",
                        label = "Width",
                        value = 15
                      ),
                      shiny::numericInput(
                        inputId = "summarise_cohort_count_ggplot2_10_download_height",
                        label = "Height",
                        value = 10
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_count_ggplot2_10_download_units",
                        label = "Units",
                        selected = "cm",
                        choices = c("px", "cm", "inch"),
                        multiple = FALSE
                      ),
                      shiny::numericInput(
                        inputId = "summarise_cohort_count_ggplot2_10_download_dpi",
                        label = "dpi",
                        value = 300
                      ),
                      shiny::downloadButton(outputId = "summarise_cohort_count_ggplot2_10_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_count_ggplot2_10_facet",
                        label = "facet",
                        selected = "cdm_name",
                        multiple = TRUE,
                        choices = c("cdm_name", "cohort_name", "sex", "age_group", "variable_name", "variable_level", "estimate_name"),
                        options = list(plugins = "remove_button")
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_count_ggplot2_10_colour",
                        label = "colour",
                        selected = NULL,
                        multiple = TRUE,
                        choices = c("cdm_name", "cohort_name", "sex", "age_group", "variable_name", "variable_level", "estimate_name"),
                        options = list(plugins = "remove_button")
                      ),
                      position = "right"
                    ),
                    shiny::plotOutput("summarise_cohort_count_ggplot2_10")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_panel(
          title = "Cohort overlap",
          icon = shiny::icon("circle-half-stroke"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("Cohort overlap shows the number of subjects that contribute to a pair of cohorts.")
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_overlap_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_overlap_grouping_cohort_name_reference",
                    label = "Cohort name reference",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_overlap_grouping_cohort_name_comparator",
                    label = "Cohort name comparator",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_overlap_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_overlap_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "summarise_cohort_overlap_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_overlap_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "summarise_cohort_overlap_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("summarise_cohort_overlap_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table cohort overlap",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_overlap_gt_1_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "summarise_cohort_overlap_gt_1_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      sortable::bucket_list(
                        header = NULL,
                        sortable::add_rank_list(
                          text = "none",
                          labels = c("cohort_name_reference", "cohort_name_comparator", "estimate_name"),
                          input_id = "summarise_cohort_overlap_gt_1_none"
                        ),
                        sortable::add_rank_list(
                          text = "header",
                          labels = "variable_name",
                          input_id = "summarise_cohort_overlap_gt_1_header"
                        ),
                        sortable::add_rank_list(
                          text = "groupColumn",
                          labels = "cdm_name",
                          input_id = "summarise_cohort_overlap_gt_1_groupColumn"
                        ),
                        sortable::add_rank_list(
                          text = "hide",
                          labels = "variable_level",
                          input_id = "summarise_cohort_overlap_gt_1_hide"
                        )
                      ),
                      shiny::checkboxInput(
                        inputId = "summarise_cohort_overlap_gt_1_uniqueCombinations",
                        label = "uniqueCombinations",
                        value = c(TRUE)
                      ),
                      position = "right"
                    ),
                    gt::gt_output("summarise_cohort_overlap_gt_1")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Plot cohort overlap",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::numericInput(
                        inputId = "summarise_cohort_overlap_ggplot2_2_download_width",
                        label = "Width",
                        value = 15
                      ),
                      shiny::numericInput(
                        inputId = "summarise_cohort_overlap_ggplot2_2_download_height",
                        label = "Height",
                        value = 10
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_overlap_ggplot2_2_download_units",
                        label = "Units",
                        selected = "cm",
                        choices = c("px", "cm", "inch"),
                        multiple = FALSE
                      ),
                      shiny::numericInput(
                        inputId = "summarise_cohort_overlap_ggplot2_2_download_dpi",
                        label = "dpi",
                        value = 300
                      ),
                      shiny::downloadButton(outputId = "summarise_cohort_overlap_ggplot2_2_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_overlap_ggplot2_2_facet",
                        label = "facet",
                        selected = c("cdm_name", "cohort_name_reference"),
                        multiple = TRUE,
                        choices = c("cdm_name", "cohort_name_reference", "cohort_name_comparator", "variable_name", "variable_level", "estimate_name"),
                        options = list(plugins = "remove_button")
                      ),
                      shiny::checkboxInput(
                        inputId = "summarise_cohort_overlap_ggplot2_2_uniqueCombinations",
                        label = "uniqueCombinations",
                        value = c(TRUE)
                      ),
                      position = "right"
                    ),
                    shiny::plotOutput("summarise_cohort_overlap_ggplot2_2")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_panel(
          title = "Cohort timing",
          icon = shiny::icon("chart-simple"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "Settings",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_timing_settings_restrict_to_first_entry",
                    label = "Restrict to first entry",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_timing_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_timing_grouping_cohort_name_reference",
                    label = "Cohort name reference",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_timing_grouping_cohort_name_comparator",
                    label = "Cohort name comparator",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_timing_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_timing_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "summarise_cohort_timing_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_timing_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "summarise_cohort_timing_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("summarise_cohort_timing_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table cohort timing",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_timing_gt_5_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "summarise_cohort_timing_gt_5_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      sortable::bucket_list(
                        header = NULL,
                        sortable::add_rank_list(
                          text = "none",
                          labels = c("cdm_name", "cohort_name_reference", "cohort_name_comparator", "variable_name", "estimate_name"),
                          input_id = "summarise_cohort_timing_gt_5_none"
                        ),
                        sortable::add_rank_list(
                          text = "header",
                          labels = character(),
                          input_id = "summarise_cohort_timing_gt_5_header"
                        ),
                        sortable::add_rank_list(
                          text = "groupColumn",
                          labels = NULL,
                          input_id = "summarise_cohort_timing_gt_5_groupColumn"
                        ),
                        sortable::add_rank_list(
                          text = "hide",
                          labels = "variable_level",
                          input_id = "summarise_cohort_timing_gt_5_hide"
                        )
                      ),
                      shiny::checkboxInput(
                        inputId = "summarise_cohort_timing_gt_5_uniqueCombinations",
                        label = "uniqueCombinations",
                        value = c(TRUE)
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_timing_gt_5_timeScale",
                        label = "timeScale",
                        selected = "days",
                        multiple = FALSE,
                        choices = c("days", "years"),
                        options = list(plugins = "remove_button")
                      ),
                      position = "right"
                    ),
                    gt::gt_output("summarise_cohort_timing_gt_5")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Plot cohort timing",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::numericInput(
                        inputId = "summarise_cohort_timing_ggplot2_6_download_width",
                        label = "Width",
                        value = 15
                      ),
                      shiny::numericInput(
                        inputId = "summarise_cohort_timing_ggplot2_6_download_height",
                        label = "Height",
                        value = 10
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_timing_ggplot2_6_download_units",
                        label = "Units",
                        selected = "cm",
                        choices = c("px", "cm", "inch"),
                        multiple = FALSE
                      ),
                      shiny::numericInput(
                        inputId = "summarise_cohort_timing_ggplot2_6_download_dpi",
                        label = "dpi",
                        value = 300
                      ),
                      shiny::downloadButton(outputId = "summarise_cohort_timing_ggplot2_6_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_timing_ggplot2_6_plotType",
                        label = "plotType",
                        selected = "boxplot",
                        multiple = FALSE,
                        choices = c("boxplot", "density"),
                        options = list(plugins = "remove_button")
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_timing_ggplot2_6_timeScale",
                        label = "timeScale",
                        selected = "days",
                        multiple = FALSE,
                        choices = c("days", "years"),
                        options = list(plugins = "remove_button")
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_timing_ggplot2_6_facet",
                        label = "facet",
                        selected = c("cdm_name", "cohort_name_reference"),
                        multiple = TRUE,
                        choices = c("cdm_name", "cohort_name_reference", "cohort_name_comparator", "variable_name", "variable_level", "estimate_name", "restrict_to_first_entry"),
                        options = list(plugins = "remove_button")
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_timing_ggplot2_6_colour",
                        label = "colour",
                        selected = "cohort_name_comparator",
                        multiple = TRUE,
                        choices = c("cdm_name", "cohort_name_reference", "cohort_name_comparator", "variable_name", "variable_level", "estimate_name", "restrict_to_first_entry"),
                        options = list(plugins = "remove_button")
                      ),
                      shiny::checkboxInput(
                        inputId = "summarise_cohort_timing_ggplot2_6_uniqueCombinations",
                        label = "uniqueCombinations",
                        value = c(TRUE)
                      ),
                      position = "right"
                    ),
                    shiny::plotOutput("summarise_cohort_timing_ggplot2_6")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_panel(
          title = "Large Scale Characteristics",
          icon = shiny::icon("arrow-up-right-dots"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "Settings",
                  shiny::selectizeInput(
                    inputId = "summarise_large_scale_characteristics_settings_table_name",
                    label = "Table name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_large_scale_characteristics_settings_type",
                    label = "Type",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_large_scale_characteristics_settings_analysis",
                    label = "Analysis",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "summarise_large_scale_characteristics_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_large_scale_characteristics_grouping_cohort_name",
                    label = "Cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_large_scale_characteristics_grouping_concept_id",
                    label = "Concept id",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "summarise_large_scale_characteristics_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "summarise_large_scale_characteristics_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "summarise_large_scale_characteristics_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_large_scale_characteristics_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "summarise_large_scale_characteristics_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("summarise_large_scale_characteristics_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Formatted",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "summarise_large_scale_characteristics_gt_0_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "summarise_large_scale_characteristics_gt_0_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      sortable::bucket_list(
                        header = NULL,
                        sortable::add_rank_list(
                          text = "none",
                          labels = c("concept_id", "variable_name", "variable_level", "estimate_name", "table_name", "type", "analysis"),
                          input_id = "summarise_large_scale_characteristics_gt_0_none"
                        ),
                        sortable::add_rank_list(
                          text = "header",
                          labels = "cdm_name",
                          input_id = "summarise_large_scale_characteristics_gt_0_header"
                        ),
                        sortable::add_rank_list(
                          text = "group",
                          labels = "cohort_name",
                          input_id = "summarise_large_scale_characteristics_gt_0_group"
                        ),
                        sortable::add_rank_list(
                          text = "hide",
                          labels = character(),
                          input_id = "summarise_large_scale_characteristics_gt_0_hide"
                        )
                      ),
                      position = "right"
                    ),
                    gt::gt_output("summarise_large_scale_characteristics_gt_0")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_spacer(),
        bslib::nav_item(
          bslib::popover(
            shiny::icon("download"),
            shiny::downloadButton(
              outputId = "download_raw",
              label = "Download raw data",
              icon = shiny::icon("download")
            )
          )
        ),
        bslib::nav_item(
          bslib::popover(
            shiny::icon("circle-info"),
            shiny::tags$img(
              src = "hds_logo.svg",
              class = "logo-img",
              alt = "Logo",
              height = "auto",
              width = "30%",
              style = "float:right"
            ),
            "This shiny app was generated with ",
            shiny::a(
              "OmopViewer",
              href = "https://github.com/OHDSI/OmopViewer",
              target = "_blank"
            ),
            shiny::strong("v0.1.0")
          )
        ),
        bslib::nav_item(bslib::input_dark_mode(id = "dark_mode", mode = "light"))
      )

# OmopSketch shiny

    Code
      cat(ui, sep = "\n")
    Output
      # Generated by OmopViewer 0.1.0
      # Be careful editing this file
      
      ui <- bslib::page_navbar(
        title = shiny::tags$span(
          shiny::tags$img(
            src = "ohdsi_logo.svg",
            width = "auto",
            height = "46px",
            class = "me-3",
            alt = "logo"
          ),
          ""
        ),
        bslib::nav_panel(
          title = "Background",
          icon = shiny::icon("disease"),
          OmopViewer::cardFromMd("background.md")
        ),
        bslib::nav_panel(
          title = "Observation period",
          icon = shiny::icon("eye"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "summarise_observation_period_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_observation_period_grouping_observation_period_ordinal",
                    label = "Observation period ordinal",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_observation_period_grouping_sex",
                    label = "Sex",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "summarise_observation_period_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "summarise_observation_period_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "summarise_observation_period_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_observation_period_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "summarise_observation_period_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("summarise_observation_period_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table observation period",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "summarise_observation_period_gt_15_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "summarise_observation_period_gt_15_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(,
                      position = "right"
                    ),
                    gt::gt_output("summarise_observation_period_gt_15")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Plot observation period",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::numericInput(
                        inputId = "summarise_observation_period_ggplot2_16_download_width",
                        label = "Width",
                        value = 15
                      ),
                      shiny::numericInput(
                        inputId = "summarise_observation_period_ggplot2_16_download_height",
                        label = "Height",
                        value = 10
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_observation_period_ggplot2_16_download_units",
                        label = "Units",
                        selected = "cm",
                        choices = c("px", "cm", "inch"),
                        multiple = FALSE
                      ),
                      shiny::numericInput(
                        inputId = "summarise_observation_period_ggplot2_16_download_dpi",
                        label = "dpi",
                        value = 300
                      ),
                      shiny::downloadButton(outputId = "summarise_observation_period_ggplot2_16_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_observation_period_ggplot2_16_variableName",
                        label = "variableName",
                        selected = "number subjects",
                        multiple = ,
                        choices = c("number subjects", "records per person", "duration in days", "days to next observation period"),
                        options = list(plugins = "remove_button")
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_observation_period_ggplot2_16_plotType",
                        label = "plotType",
                        selected = "barplot",
                        multiple = ,
                        choices = c("barplot", "boxplot", "densityplot"),
                        options = list(plugins = "remove_button")
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_observation_period_ggplot2_16_facet",
                        label = "facet",
                        selected = NULL,
                        multiple = TRUE,
                        choices = c("cdm_name", "observation_period_ordinal", "sex"),
                        options = list(plugins = "remove_button")
                      ),
                      position = "right"
                    ),
                    shiny::plotOutput("summarise_observation_period_ggplot2_16")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_panel(
          title = "Snapshot",
          icon = shiny::icon("clipboard-list"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "summarise_omop_snapshot_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "summarise_omop_snapshot_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "summarise_omop_snapshot_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "summarise_omop_snapshot_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_omop_snapshot_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "summarise_omop_snapshot_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("summarise_omop_snapshot_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Snapshot table",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "summarise_omop_snapshot_gt_17_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "summarise_omop_snapshot_gt_17_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(,
                      position = "right"
                    ),
                    gt::gt_output("summarise_omop_snapshot_gt_17")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_spacer(),
        bslib::nav_item(
          bslib::popover(
            shiny::icon("download"),
            shiny::downloadButton(
              outputId = "download_raw",
              label = "Download raw data",
              icon = shiny::icon("download")
            )
          )
        ),
        bslib::nav_item(
          bslib::popover(
            shiny::icon("circle-info"),
            shiny::tags$img(
              src = "hds_logo.svg",
              class = "logo-img",
              alt = "Logo",
              height = "auto",
              width = "30%",
              style = "float:right"
            ),
            "This shiny app was generated with ",
            shiny::a(
              "OmopViewer",
              href = "https://github.com/OHDSI/OmopViewer",
              target = "_blank"
            ),
            shiny::strong("v0.1.0")
          )
        ),
        bslib::nav_item(bslib::input_dark_mode(id = "dark_mode", mode = "light"))
      )

---

    Code
      cat(server, sep = "\n")
    Output
      # Generated by OmopViewer 0.1.0
      # Be careful editing this file
      
      server <- function(input, output, session) {
        # download raw data -----
        output$download_raw <- shiny::downloadHandler(
          filename = "results.csv",
          content = function(file) {
            OmopViewer::exportSummarisedResult(data, fileName = file)
          }
        )
        # fill selectise variables ----
        shiny::observe({
          choices <- OmopViewer::getChoices(data, flatten = TRUE)
          for (k in seq_along(choices)) {
            shiny::updateSelectizeInput(
              session,
              inputId = names(choices)[k],
              choices = choices[[k]],
              selected = choices[[k]],
              server = TRUE
            )
          }
        })
        # summarise_observation_period -----
        ## tidy summarise_observation_period -----
        getTidyDataSummariseObservationPeriod <- shiny::reactive({
          res <- data |>
            OmopViewer::filterData("summarise_observation_period", input) |>
            OmopViewer::tidyData()
      
          # columns to eliminate
          colsEliminate <- colnames(res)
          colsEliminate <- colsEliminate[!colsEliminate %in% c(
            input$summarise_observation_period_tidy_columns, "variable_name", "variable_level",
            "estimate_name", "estimate_type", "estimate_value"
          )]
      
          # pivot
          pivot <- input$summarise_observation_period_tidy_pivot
          if (pivot != "none") {
            vars <- switch(pivot,
              "estimates" = "estimate_name",
              "estimates and variables" = c("variable_name", "variable_level", "estimate_name")
            )
            res <- res |>
              visOmopResults::pivotEstimates(pivotEstimatesBy = vars)
          }
      
          res |>
            dplyr::select(!dplyr::all_of(colsEliminate))
        })
        output$summarise_observation_period_tidy <- DT::renderDT({
          DT::datatable(
            getTidyDataSummariseObservationPeriod(),
            options = list(scrollX = TRUE),
            rownames = FALSE
          )
        })
        output$summarise_observation_period_tidy_download <- shiny::downloadHandler(
          filename = "tidy_summarise_observation_period.csv",
          content = function(file) {
            getTidyDataSummariseObservationPeriod() |>
              readr::write_csv(file = file)
          }
        )
        ## output summarise_observation_period -----
        ## output 15 -----
        createOutput15 <- shiny::reactive({
          result <- data |>
            OmopViewer::filterData("summarise_observation_period", input)
          OmopSketch::tableObservationPeriod(
            result
          )
        })
        output$summarise_observation_period_gt_15 <- gt::render_gt({
          createOutput15()
        })
        output$summarise_observation_period_gt_15_download <- shiny::downloadHandler(
          filename = paste0("output_gt_summarise_observation_period.", input$summarise_observation_period_gt_15_download_type),
          content = function(file) {
            obj <- createOutput15()
            gt::gtsave(data = obj, filename = file)
          }
        )
      
        ## output 16 -----
        createOutput16 <- shiny::reactive({
          result <- data |>
            OmopViewer::filterData("summarise_observation_period", input)
          OmopSketch::plotObservationPeriod(
            result,
            variableName = input$summarise_observation_period_ggplot2_16_variableName,
            plotType = input$summarise_observation_period_ggplot2_16_plotType,
            facet = input$summarise_observation_period_ggplot2_16_facet
          )
        })
        output$summarise_observation_period_ggplot2_16 <- shiny::renderPlot({
          createOutput16()
        })
        output$summarise_observation_period_ggplot2_16_download <- shiny::downloadHandler(
          filename = paste0("output_ggplot2_summarise_observation_period.", "png"),
          content = function(file) {
            obj <- createOutput16()
            ggplot2::ggsave(
              filename = file,
              plot = obj,
              width = as.numeric(input$summarise_observation_period_ggplot2_16_download_width),
              height = as.numeric(input$summarise_observation_period_ggplot2_16_download_height),
              units = input$summarise_observation_period_ggplot2_16_download_units,
              dpi = as.numeric(input$summarise_observation_period_ggplot2_16_download_dpi)
            )
          }
        )
      
      
        # summarise_omop_snapshot -----
        ## tidy summarise_omop_snapshot -----
        getTidyDataSummariseOmopSnapshot <- shiny::reactive({
          res <- data |>
            OmopViewer::filterData("summarise_omop_snapshot", input) |>
            OmopViewer::tidyData()
      
          # columns to eliminate
          colsEliminate <- colnames(res)
          colsEliminate <- colsEliminate[!colsEliminate %in% c(
            input$summarise_omop_snapshot_tidy_columns, "variable_name", "variable_level",
            "estimate_name", "estimate_type", "estimate_value"
          )]
      
          # pivot
          pivot <- input$summarise_omop_snapshot_tidy_pivot
          if (pivot != "none") {
            vars <- switch(pivot,
              "estimates" = "estimate_name",
              "estimates and variables" = c("variable_name", "variable_level", "estimate_name")
            )
            res <- res |>
              visOmopResults::pivotEstimates(pivotEstimatesBy = vars)
          }
      
          res |>
            dplyr::select(!dplyr::all_of(colsEliminate))
        })
        output$summarise_omop_snapshot_tidy <- DT::renderDT({
          DT::datatable(
            getTidyDataSummariseOmopSnapshot(),
            options = list(scrollX = TRUE),
            rownames = FALSE
          )
        })
        output$summarise_omop_snapshot_tidy_download <- shiny::downloadHandler(
          filename = "tidy_summarise_omop_snapshot.csv",
          content = function(file) {
            getTidyDataSummariseOmopSnapshot() |>
              readr::write_csv(file = file)
          }
        )
        ## output summarise_omop_snapshot -----
        ## output 17 -----
        createOutput17 <- shiny::reactive({
          result <- data |>
            OmopViewer::filterData("summarise_omop_snapshot", input)
          OmopSketch::tableOmopSnapshot(
            result
          )
        })
        output$summarise_omop_snapshot_gt_17 <- gt::render_gt({
          createOutput17()
        })
        output$summarise_omop_snapshot_gt_17_download <- shiny::downloadHandler(
          filename = paste0("output_gt_summarise_omop_snapshot.", input$summarise_omop_snapshot_gt_17_download_type),
          content = function(file) {
            obj <- createOutput17()
            gt::gtsave(data = obj, filename = file)
          }
        )
      }

---

    Code
      cat(global, sep = "\n")
    Output
      # Generated by OmopViewer 0.1.0
      # Be careful editing this file
      
      library(DT)
      library(OmopSketch)
      library(OmopViewer)
      library(bslib)
      library(dplyr)
      library(ggplot2)
      library(gt)
      library(here)
      library(readr)
      library(shiny)
      library(visOmopResults)
      
      data <- OmopViewer::importSummarisedResult(here::here("data")) |>
        OmopViewer::correctSettings()

# CodelistGenerator shiny

    Code
      cat(ui, sep = "\n")
    Output
      # Generated by OmopViewer 0.1.0
      # Be careful editing this file
      
      ui <- bslib::page_navbar(
        title = shiny::tags$span(
          shiny::tags$img(
            src = "ohdsi_logo.svg",
            width = "auto",
            height = "46px",
            class = "me-3",
            alt = "logo"
          ),
          ""
        ),
        bslib::nav_panel(
          title = "Background",
          icon = shiny::icon("disease"),
          OmopViewer::cardFromMd("background.md")
        ),
        bslib::nav_panel(
          title = "Orphan codes",
          icon = shiny::icon("magnifying-glass-arrow-right"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "orphan_code_use_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "orphan_code_use_grouping_codelist_name",
                    label = "Codelist name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "orphan_code_use_grouping_domain_id",
                    label = "Domain id",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "orphan_code_use_grouping_standard_concept",
                    label = "Standard concept",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "orphan_code_use_grouping_vocabulary_id",
                    label = "Vocabulary id",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "orphan_code_use_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "orphan_code_use_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "orphan_code_use_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "orphan_code_use_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "orphan_code_use_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("orphan_code_use_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table orphan codes",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "orphan_code_use_gt_11_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "orphan_code_use_gt_11_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      sortable::bucket_list(
                        header = NULL,
                        sortable::add_rank_list(
                          text = "none",
                          labels = c("codelist_name", "domain_id", "standard_concept", "vocabulary_id", "variable_name", "variable_level"),
                          input_id = "orphan_code_use_gt_11_none"
                        ),
                        sortable::add_rank_list(
                          text = "header",
                          labels = c("cdm_name", "estimate_name"),
                          input_id = "orphan_code_use_gt_11_header"
                        ),
                        sortable::add_rank_list(
                          text = "groupColumn",
                          labels = NULL,
                          input_id = "orphan_code_use_gt_11_groupColumn"
                        ),
                        sortable::add_rank_list(
                          text = "hide",
                          labels = character(),
                          input_id = "orphan_code_use_gt_11_hide"
                        )
                      ),
                      position = "right"
                    ),
                    gt::gt_output("orphan_code_use_gt_11")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_panel(
          title = "Cohort code use",
          icon = shiny::icon("chart-column"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "Settings",
                  shiny::selectizeInput(
                    inputId = "cohort_code_use_settings_timing",
                    label = "Timing",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "cohort_code_use_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "cohort_code_use_grouping_cohort_name",
                    label = "Cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "cohort_code_use_grouping_codelist_name",
                    label = "Codelist name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "cohort_code_use_grouping_source_concept_name",
                    label = "Source concept name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "cohort_code_use_grouping_source_concept_id",
                    label = "Source concept id",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "cohort_code_use_grouping_domain_id",
                    label = "Domain id",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "cohort_code_use_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "cohort_code_use_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "cohort_code_use_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "cohort_code_use_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "cohort_code_use_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("cohort_code_use_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table cohort code use",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "cohort_code_use_gt_12_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "cohort_code_use_gt_12_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      sortable::bucket_list(
                        header = NULL,
                        sortable::add_rank_list(
                          text = "none",
                          labels = c("cohort_name", "codelist_name", "source_concept_name", "source_concept_id", "domain_id", "variable_name", "variable_level"),
                          input_id = "cohort_code_use_gt_12_none"
                        ),
                        sortable::add_rank_list(
                          text = "header",
                          labels = c("cdm_name", "estimate_name"),
                          input_id = "cohort_code_use_gt_12_header"
                        ),
                        sortable::add_rank_list(
                          text = "groupColumn",
                          labels = NULL,
                          input_id = "cohort_code_use_gt_12_groupColumn"
                        ),
                        sortable::add_rank_list(
                          text = "hide",
                          labels = character(),
                          input_id = "cohort_code_use_gt_12_hide"
                        )
                      ),
                      shiny::checkboxInput(
                        inputId = "cohort_code_use_gt_12_timing",
                        label = "timing",
                        value = c(FALSE)
                      ),
                      position = "right"
                    ),
                    gt::gt_output("cohort_code_use_gt_12")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_panel(
          title = "Code use",
          icon = shiny::icon("chart-column"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "code_use_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "code_use_grouping_codelist_name",
                    label = "Codelist name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "code_use_grouping_year",
                    label = "Year",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "code_use_grouping_sex",
                    label = "Sex",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "code_use_grouping_source_concept_name",
                    label = "Source concept name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "code_use_grouping_source_concept_id",
                    label = "Source concept id",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "code_use_grouping_domain_id",
                    label = "Domain id",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "code_use_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "code_use_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "code_use_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "code_use_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "code_use_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("code_use_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table code use",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "code_use_gt_13_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "code_use_gt_13_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      sortable::bucket_list(
                        header = NULL,
                        sortable::add_rank_list(
                          text = "none",
                          labels = c("codelist_name", "year", "sex", "source_concept_name", "source_concept_id", "domain_id", "variable_name", "variable_level"),
                          input_id = "code_use_gt_13_none"
                        ),
                        sortable::add_rank_list(
                          text = "header",
                          labels = c("cdm_name", "estimate_name"),
                          input_id = "code_use_gt_13_header"
                        ),
                        sortable::add_rank_list(
                          text = "groupColumn",
                          labels = NULL,
                          input_id = "code_use_gt_13_groupColumn"
                        ),
                        sortable::add_rank_list(
                          text = "hide",
                          labels = character(),
                          input_id = "code_use_gt_13_hide"
                        )
                      ),
                      position = "right"
                    ),
                    gt::gt_output("code_use_gt_13")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_panel(
          title = "Achilles code use",
          icon = shiny::icon("chart-column"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "achilles_code_use_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "achilles_code_use_grouping_codelist_name",
                    label = "Codelist name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "achilles_code_use_grouping_domain_id",
                    label = "Domain id",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "achilles_code_use_grouping_standard_concept",
                    label = "Standard concept",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "achilles_code_use_grouping_vocabulary_id",
                    label = "Vocabulary id",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "achilles_code_use_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "achilles_code_use_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "achilles_code_use_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "achilles_code_use_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "achilles_code_use_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("achilles_code_use_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table achilles code use",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "achilles_code_use_gt_14_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "achilles_code_use_gt_14_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      sortable::bucket_list(
                        header = NULL,
                        sortable::add_rank_list(
                          text = "none",
                          labels = c("codelist_name", "domain_id", "standard_concept", "vocabulary_id", "variable_name", "variable_level"),
                          input_id = "achilles_code_use_gt_14_none"
                        ),
                        sortable::add_rank_list(
                          text = "header",
                          labels = c("cdm_name", "estimate_name"),
                          input_id = "achilles_code_use_gt_14_header"
                        ),
                        sortable::add_rank_list(
                          text = "groupColumn",
                          labels = NULL,
                          input_id = "achilles_code_use_gt_14_groupColumn"
                        ),
                        sortable::add_rank_list(
                          text = "hide",
                          labels = character(),
                          input_id = "achilles_code_use_gt_14_hide"
                        )
                      ),
                      position = "right"
                    ),
                    gt::gt_output("achilles_code_use_gt_14")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_spacer(),
        bslib::nav_item(
          bslib::popover(
            shiny::icon("download"),
            shiny::downloadButton(
              outputId = "download_raw",
              label = "Download raw data",
              icon = shiny::icon("download")
            )
          )
        ),
        bslib::nav_item(
          bslib::popover(
            shiny::icon("circle-info"),
            shiny::tags$img(
              src = "hds_logo.svg",
              class = "logo-img",
              alt = "Logo",
              height = "auto",
              width = "30%",
              style = "float:right"
            ),
            "This shiny app was generated with ",
            shiny::a(
              "OmopViewer",
              href = "https://github.com/OHDSI/OmopViewer",
              target = "_blank"
            ),
            shiny::strong("v0.1.0")
          )
        ),
        bslib::nav_item(bslib::input_dark_mode(id = "dark_mode", mode = "light"))
      )

---

    Code
      cat(server, sep = "\n")
    Output
      # Generated by OmopViewer 0.1.0
      # Be careful editing this file
      
      server <- function(input, output, session) {
        # download raw data -----
        output$download_raw <- shiny::downloadHandler(
          filename = "results.csv",
          content = function(file) {
            OmopViewer::exportSummarisedResult(data, fileName = file)
          }
        )
        # fill selectise variables ----
        shiny::observe({
          choices <- OmopViewer::getChoices(data, flatten = TRUE)
          for (k in seq_along(choices)) {
            shiny::updateSelectizeInput(
              session,
              inputId = names(choices)[k],
              choices = choices[[k]],
              selected = choices[[k]],
              server = TRUE
            )
          }
        })
        # orphan_code_use -----
        ## tidy orphan_code_use -----
        getTidyDataOrphanCodeUse <- shiny::reactive({
          res <- data |>
            OmopViewer::filterData("orphan_code_use", input) |>
            OmopViewer::tidyData()
      
          # columns to eliminate
          colsEliminate <- colnames(res)
          colsEliminate <- colsEliminate[!colsEliminate %in% c(
            input$orphan_code_use_tidy_columns, "variable_name", "variable_level",
            "estimate_name", "estimate_type", "estimate_value"
          )]
      
          # pivot
          pivot <- input$orphan_code_use_tidy_pivot
          if (pivot != "none") {
            vars <- switch(pivot,
              "estimates" = "estimate_name",
              "estimates and variables" = c("variable_name", "variable_level", "estimate_name")
            )
            res <- res |>
              visOmopResults::pivotEstimates(pivotEstimatesBy = vars)
          }
      
          res |>
            dplyr::select(!dplyr::all_of(colsEliminate))
        })
        output$orphan_code_use_tidy <- DT::renderDT({
          DT::datatable(
            getTidyDataOrphanCodeUse(),
            options = list(scrollX = TRUE),
            rownames = FALSE
          )
        })
        output$orphan_code_use_tidy_download <- shiny::downloadHandler(
          filename = "tidy_orphan_code_use.csv",
          content = function(file) {
            getTidyDataOrphanCodeUse() |>
              readr::write_csv(file = file)
          }
        )
        ## output orphan_code_use -----
        ## output 11 -----
        createOutput11 <- shiny::reactive({
          result <- data |>
            OmopViewer::filterData("orphan_code_use", input)
          CodelistGenerator::tableOrphanCodes(
            result,
            header = input$orphan_code_use_gt_11_header,
            groupColumn = input$orphan_code_use_gt_11_groupColumn,
            hide = input$orphan_code_use_gt_11_hide
          )
        })
        output$orphan_code_use_gt_11 <- gt::render_gt({
          createOutput11()
        })
        output$orphan_code_use_gt_11_download <- shiny::downloadHandler(
          filename = paste0("output_gt_orphan_code_use.", input$orphan_code_use_gt_11_download_type),
          content = function(file) {
            obj <- createOutput11()
            gt::gtsave(data = obj, filename = file)
          }
        )
      
      
        # cohort_code_use -----
        ## tidy cohort_code_use -----
        getTidyDataCohortCodeUse <- shiny::reactive({
          res <- data |>
            OmopViewer::filterData("cohort_code_use", input) |>
            OmopViewer::tidyData()
      
          # columns to eliminate
          colsEliminate <- colnames(res)
          colsEliminate <- colsEliminate[!colsEliminate %in% c(
            input$cohort_code_use_tidy_columns, "variable_name", "variable_level",
            "estimate_name", "estimate_type", "estimate_value"
          )]
      
          # pivot
          pivot <- input$cohort_code_use_tidy_pivot
          if (pivot != "none") {
            vars <- switch(pivot,
              "estimates" = "estimate_name",
              "estimates and variables" = c("variable_name", "variable_level", "estimate_name")
            )
            res <- res |>
              visOmopResults::pivotEstimates(pivotEstimatesBy = vars)
          }
      
          res |>
            dplyr::select(!dplyr::all_of(colsEliminate))
        })
        output$cohort_code_use_tidy <- DT::renderDT({
          DT::datatable(
            getTidyDataCohortCodeUse(),
            options = list(scrollX = TRUE),
            rownames = FALSE
          )
        })
        output$cohort_code_use_tidy_download <- shiny::downloadHandler(
          filename = "tidy_cohort_code_use.csv",
          content = function(file) {
            getTidyDataCohortCodeUse() |>
              readr::write_csv(file = file)
          }
        )
        ## output cohort_code_use -----
        ## output 12 -----
        createOutput12 <- shiny::reactive({
          result <- data |>
            OmopViewer::filterData("cohort_code_use", input)
          CodelistGenerator::tableCohortCodeUse(
            result,
            timing = input$cohort_code_use_gt_12_timing,
            header = input$cohort_code_use_gt_12_header,
            groupColumn = input$cohort_code_use_gt_12_groupColumn,
            hide = input$cohort_code_use_gt_12_hide
          )
        })
        output$cohort_code_use_gt_12 <- gt::render_gt({
          createOutput12()
        })
        output$cohort_code_use_gt_12_download <- shiny::downloadHandler(
          filename = paste0("output_gt_cohort_code_use.", input$cohort_code_use_gt_12_download_type),
          content = function(file) {
            obj <- createOutput12()
            gt::gtsave(data = obj, filename = file)
          }
        )
      
      
        # code_use -----
        ## tidy code_use -----
        getTidyDataCodeUse <- shiny::reactive({
          res <- data |>
            OmopViewer::filterData("code_use", input) |>
            OmopViewer::tidyData()
      
          # columns to eliminate
          colsEliminate <- colnames(res)
          colsEliminate <- colsEliminate[!colsEliminate %in% c(
            input$code_use_tidy_columns, "variable_name", "variable_level",
            "estimate_name", "estimate_type", "estimate_value"
          )]
      
          # pivot
          pivot <- input$code_use_tidy_pivot
          if (pivot != "none") {
            vars <- switch(pivot,
              "estimates" = "estimate_name",
              "estimates and variables" = c("variable_name", "variable_level", "estimate_name")
            )
            res <- res |>
              visOmopResults::pivotEstimates(pivotEstimatesBy = vars)
          }
      
          res |>
            dplyr::select(!dplyr::all_of(colsEliminate))
        })
        output$code_use_tidy <- DT::renderDT({
          DT::datatable(
            getTidyDataCodeUse(),
            options = list(scrollX = TRUE),
            rownames = FALSE
          )
        })
        output$code_use_tidy_download <- shiny::downloadHandler(
          filename = "tidy_code_use.csv",
          content = function(file) {
            getTidyDataCodeUse() |>
              readr::write_csv(file = file)
          }
        )
        ## output code_use -----
        ## output 13 -----
        createOutput13 <- shiny::reactive({
          result <- data |>
            OmopViewer::filterData("code_use", input)
          CodelistGenerator::tableCodeUse(
            result,
            header = input$code_use_gt_13_header,
            groupColumn = input$code_use_gt_13_groupColumn,
            hide = input$code_use_gt_13_hide
          )
        })
        output$code_use_gt_13 <- gt::render_gt({
          createOutput13()
        })
        output$code_use_gt_13_download <- shiny::downloadHandler(
          filename = paste0("output_gt_code_use.", input$code_use_gt_13_download_type),
          content = function(file) {
            obj <- createOutput13()
            gt::gtsave(data = obj, filename = file)
          }
        )
      
      
        # achilles_code_use -----
        ## tidy achilles_code_use -----
        getTidyDataAchillesCodeUse <- shiny::reactive({
          res <- data |>
            OmopViewer::filterData("achilles_code_use", input) |>
            OmopViewer::tidyData()
      
          # columns to eliminate
          colsEliminate <- colnames(res)
          colsEliminate <- colsEliminate[!colsEliminate %in% c(
            input$achilles_code_use_tidy_columns, "variable_name", "variable_level",
            "estimate_name", "estimate_type", "estimate_value"
          )]
      
          # pivot
          pivot <- input$achilles_code_use_tidy_pivot
          if (pivot != "none") {
            vars <- switch(pivot,
              "estimates" = "estimate_name",
              "estimates and variables" = c("variable_name", "variable_level", "estimate_name")
            )
            res <- res |>
              visOmopResults::pivotEstimates(pivotEstimatesBy = vars)
          }
      
          res |>
            dplyr::select(!dplyr::all_of(colsEliminate))
        })
        output$achilles_code_use_tidy <- DT::renderDT({
          DT::datatable(
            getTidyDataAchillesCodeUse(),
            options = list(scrollX = TRUE),
            rownames = FALSE
          )
        })
        output$achilles_code_use_tidy_download <- shiny::downloadHandler(
          filename = "tidy_achilles_code_use.csv",
          content = function(file) {
            getTidyDataAchillesCodeUse() |>
              readr::write_csv(file = file)
          }
        )
        ## output achilles_code_use -----
        ## output 14 -----
        createOutput14 <- shiny::reactive({
          result <- data |>
            OmopViewer::filterData("achilles_code_use", input)
          CodelistGenerator::tableAchillesCodeUse(
            result,
            header = input$achilles_code_use_gt_14_header,
            groupColumn = input$achilles_code_use_gt_14_groupColumn,
            hide = input$achilles_code_use_gt_14_hide
          )
        })
        output$achilles_code_use_gt_14 <- gt::render_gt({
          createOutput14()
        })
        output$achilles_code_use_gt_14_download <- shiny::downloadHandler(
          filename = paste0("output_gt_achilles_code_use.", input$achilles_code_use_gt_14_download_type),
          content = function(file) {
            obj <- createOutput14()
            gt::gtsave(data = obj, filename = file)
          }
        )
      }

---

    Code
      cat(global, sep = "\n")
    Output
      # Generated by OmopViewer 0.1.0
      # Be careful editing this file
      
      library(CodelistGenerator)
      library(DT)
      library(OmopViewer)
      library(bslib)
      library(dplyr)
      library(gt)
      library(here)
      library(readr)
      library(shiny)
      library(sortable)
      library(visOmopResults)
      
      data <- OmopViewer::importSummarisedResult(here::here("data")) |>
        OmopViewer::correctSettings()

