% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blrm_formula_saturating.R
\name{blrm_formula_saturating}
\alias{blrm_formula_saturating}
\title{Build a BLRM formula with saturating interaction term in logit-space}
\usage{
blrm_formula_saturating(
  ref_doses,
  max_interaction_level = 2,
  specific_interaction_terms = NULL
)
}
\arguments{
\item{ref_doses}{Numeric vector of reference doses with names corresponding to drug names}

\item{max_interaction_level}{Highest interaction order to consider [1 - Inf]. Default: 2}

\item{specific_interaction_terms}{List of custom interaction terms to generate (e.g. list(c("drug1", "drug2"), c("drug1", "drug3"))). Default: NULL}
}
\value{
The function returns an object of class \code{blrm_formula}.
}
\description{
\code{blrm_formula_saturating} is a convenience function for generating
a formula for \code{blrm_trial} and \code{blrm_exnex} with an interaction of the form:

\deqn{2 \eta \, \frac{\prod_{i=1}^N (d_i \big / d_i^*)}{1 + \prod_{i=1}^N (d_i \big / d_i^*)}}
}
\examples{

ref_doses <- c(drug_A=10, drug_B=20)

# can be used with blrm_trial
blrm_formula_saturating(ref_doses)

}
