% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OneR.R
\name{bin}
\alias{bin}
\title{Binning function}
\usage{
bin(data, nbins = 5, labels = NULL, method = c("length", "content"),
  na.omit = TRUE)
}
\arguments{
\item{data}{dataframe which contains the data.}

\item{nbins}{number of bins (= levels).}

\item{labels}{character vector of labels for the resulting category.}

\item{method}{a character string specifying the binning method, see 'Details'; can be abbreviated.}

\item{na.omit}{boolean value whether instances with missing values should be removed.}
}
\description{
Discretizes all numerical data in a dataframe into categorical bins of equal length or content.
}
\details{
Character strings and logical strings are coerced into factors. Matrices are coerced into dataframes. When called with a single vector only the respective factor (and not a dataframe) is returned.
Method \code{"length"} gives intervals of equal length, method \code{"content"} gives intervals of equal content (via quantiles).

When \code{"na.omit = FALSE"} a new level \code{"NA"} is introduced into each factor.
}
\examples{
data <- iris
str(data)
str(bin(data))
str(bin(data, nbins = 3))
str(bin(data, nbins = 3, labels = c("small", "medium", "large")))

## Difference between methods "length" and "content"
set.seed(1); table(bin(rnorm(900), nbins = 3))
set.seed(1); table(bin(rnorm(900), nbins = 3, method = "content"))
}
\author{
Holger von Jouanne-Diedrich
}
\references{
\url{http://vonjd.github.io/OneR/}
}
\seealso{
\code{\link{OneR}}, \code{\link{optbin}}
}
\keyword{binning}
\keyword{discretization}
\keyword{discretize}

