% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulation.R
\name{Simulation}
\alias{Simulation}
\title{R6Class Simulation}
\description{
Simulation object to run the model and store data across
multiple simulations.
}
\examples{
# Create a model using the baseline parameters included in the package.
# Note: This initialisation can take a few seconds.
model <- Model.new( params = list( n_total = 10000 ) )

if (!is.null(model)) {
  # Begin simulation:
  env <- COVID19IBM$new( model )
  sim <- Simulation$new( env )
  sim$start_simulation()
  sim$steps(1) # Note: slow operation (takes a few seconds).

  # Make changes to the model (environment)
  model$seed_infect_by_idx(0)

  # Resume simulation
  sim$steps(1) # Note: slow operation (takes a few seconds).

  # Get results
  sim$results
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{env}}{Current environment
(\code{\link{Environment}} R6 class object)}

\item{\code{agent}}{Current agent
(\code{\link{Agent}} R6 class object)}

\item{\code{current_state}}{Current environment state.}

\item{\code{current_action}}{Current action from agent.}

\item{\code{simulation_number}}{Simulation Number.}

\item{\code{end_time}}{Time when the simulation should end.}

\item{\code{results}}{Results of current simulation (list of vectors).}

\item{\code{results_all_simulations}}{Results of all simulations
(list of list of vectors).}

\item{\code{verbose}}{Log verbosity.}

\item{\code{timestep}}{Current time step.}

\item{\code{sim_started}}{\code{TRUE} is the simulation has started,
\code{FALSE} otherwise.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Simulation$new()}}
\item \href{#method-start_simulation}{\code{Simulation$start_simulation()}}
\item \href{#method-end_simulation}{\code{Simulation$end_simulation()}}
\item \href{#method-steps}{\code{Simulation$steps()}}
\item \href{#method-collect_results}{\code{Simulation$collect_results()}}
\item \href{#method-is_terminal_state}{\code{Simulation$is_terminal_state()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Environment subclass representing a COVID19 outbreak as
defined in the COVID19-IBM model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$new(env, agent = Agent$new(), end_time = NULL, verbose = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{env}}{Instance of \code{\link{Environment}} R6Class}

\item{\code{agent}}{Instance of \code{\link{Agent}} R6Class}

\item{\code{end_time}}{End time for the simulation}

\item{\code{verbose}}{Log verbosity.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-start_simulation"></a>}}
\if{latex}{\out{\hypertarget{method-start_simulation}{}}}
\subsection{Method \code{start_simulation()}}{
Initialisation of the simulation; reset the model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$start_simulation()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-end_simulation"></a>}}
\if{latex}{\out{\hypertarget{method-end_simulation}{}}}
\subsection{Method \code{end_simulation()}}{
End the simulation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$end_simulation()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-steps"></a>}}
\if{latex}{\out{\hypertarget{method-steps}{}}}
\subsection{Method \code{steps()}}{
Run the model for a specific number of steps, starting from
the current state, save data as model progresses.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$steps(n_steps)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n_steps}}{Number of steps for which to call
\code{self$model.one_time_step()}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-collect_results"></a>}}
\if{latex}{\out{\hypertarget{method-collect_results}{}}}
\subsection{Method \code{collect_results()}}{
Collect model results at each step;
fixme action is not currently stored
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$collect_results(state, action)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{state}}{The state to collect results from.}

\item{\code{action}}{Currently unused.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_terminal_state"></a>}}
\if{latex}{\out{\hypertarget{method-is_terminal_state}{}}}
\subsection{Method \code{is_terminal_state()}}{
Get terminal state.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$is_terminal_state()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Is the current state the terminal state
}
}
}
