% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Vaccine.R
\name{Vaccine}
\alias{Vaccine}
\title{R6Class Vaccine}
\description{
Vaccine object has information about each new vaccine
}
\examples{
# Add new vaccine
model = Model.new( params = list(n_total = 10000) )
vaccine = model$add_vaccine()

}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{c_vaccine}}{the C vaccine R pointer object (SWIG wrapped)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Vaccine$new()}}
\item \href{#method-idx}{\code{Vaccine$idx()}}
\item \href{#method-n_strain}{\code{Vaccine$n_strain()}}
\item \href{#method-time_to_protect}{\code{Vaccine$time_to_protect()}}
\item \href{#method-vaccine_protection_period}{\code{Vaccine$vaccine_protection_period()}}
\item \href{#method-full_efficacy}{\code{Vaccine$full_efficacy()}}
\item \href{#method-symptoms_efficacy}{\code{Vaccine$symptoms_efficacy()}}
\item \href{#method-severe_efficacy}{\code{Vaccine$severe_efficacy()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Vaccine$new(model, vaccine_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{R6 Model object}

\item{\code{vaccine_id}}{The vaccine ID.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-idx"></a>}}
\if{latex}{\out{\hypertarget{method-idx}{}}}
\subsection{Method \code{idx()}}{
Wrapper for C API \code{vaccine$idx()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Vaccine$idx()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the index of the vaccine
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-n_strain"></a>}}
\if{latex}{\out{\hypertarget{method-n_strain}{}}}
\subsection{Method \code{n_strain()}}{
Wrapper for C API \code{vaccine$n_strains()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Vaccine$n_strain()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the number of strains the vaccine has efficacy for
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-time_to_protect"></a>}}
\if{latex}{\out{\hypertarget{method-time_to_protect}{}}}
\subsection{Method \code{time_to_protect()}}{
Wrapper for C API \code{vaccine$time_to_protect()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Vaccine$time_to_protect()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the time_to_protect of the vaccine
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vaccine_protection_period"></a>}}
\if{latex}{\out{\hypertarget{method-vaccine_protection_period}{}}}
\subsection{Method \code{vaccine_protection_period()}}{
Wrapper for C API \code{vaccine$vaccine_protection_period()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Vaccine$vaccine_protection_period()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the vaccine_protection_period of the vaccine
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-full_efficacy"></a>}}
\if{latex}{\out{\hypertarget{method-full_efficacy}{}}}
\subsection{Method \code{full_efficacy()}}{
Wrapper for C API \code{vaccine$full_efficacy()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Vaccine$full_efficacy()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the full_efficacy of vaccine by strain
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-symptoms_efficacy"></a>}}
\if{latex}{\out{\hypertarget{method-symptoms_efficacy}{}}}
\subsection{Method \code{symptoms_efficacy()}}{
Wrapper for C API \code{vaccine$symptoms_efficacy()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Vaccine$symptoms_efficacy()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the symptoms_efficacy of vaccine by strain
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-severe_efficacy"></a>}}
\if{latex}{\out{\hypertarget{method-severe_efficacy}{}}}
\subsection{Method \code{severe_efficacy()}}{
Wrapper for C API \code{vaccine$severe_efficacy()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Vaccine$severe_efficacy()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the severe_efficacy of vaccine by strain
}
}
}
