% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/open_image_rscript.R
\name{edge_detection}
\alias{edge_detection}
\title{edge detection (Frei_chen, LoG, Prewitt, Roberts_cross, Scharr, Sobel)}
\usage{
edge_detection(image, method = NULL, conv_mode = "same", approx = F,
  gaussian_dims = 5, sigma = 1, range_gauss = 2, laplacian_type = 1)
}
\arguments{
\item{image}{matrix or 3-dimensional array}

\item{method}{the method should be one of 'Frei_chen', 'LoG' (Laplacian of Gaussian), 'Prewitt', 'Roberts_cross', 'Scharr', 'Sobel'}

\item{conv_mode}{the convolution mode should be one of 'same', 'full'}

\item{approx}{if TRUE, approximate calculation of gradient (applies to all filters except for 'LoG')}

\item{gaussian_dims}{integer specifying the horizontal and vertical dimensions of the gaussian filter}

\item{sigma}{float parameter sigma for the gaussian filter}

\item{range_gauss}{float number specifying the range of values for the gaussian filter}

\item{laplacian_type}{integer value specifying the type for the laplacian kernel (one of 1, 2, 3, 4)}
}
\value{
depending on the input, either a matrix or an array
}
\description{
edge detection (Frei_chen, LoG, Prewitt, Roberts_cross, Scharr, Sobel)
}
\details{
This function takes either a matrix or a 3-dimensional array and it performs edge detection using one of the following filters : 'Frei_chen', 'LoG' (Laplacian of Gaussian),
'Prewitt', 'Roberts_cross', 'Scharr', 'Sobel'
}
\examples{

path = system.file("tmp_images", "1.png", package = "OpenImageR")

image = readImage(path)

res = edge_detection(image, method = 'Frei_chen', conv_mode = 'same')

}
\author{
Lampros Mouselimis
}
