% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intensityClass.R
\docType{class}
\name{Interval-class}
\alias{Interval-class}
\alias{Interval}
\title{Class Interval}
\description{
A S4 class for the Interval level result of an Intensity analysis.  Can be
plotted with the plot method \code{\link{plot}}.
}
\details{
The slot \code{intervalData} receives a table containing 4 columns
in the following format:
   \enumerate{
   \item Period: \code{<fct>}. The period of interest \emph{[Yt, Yt+1]}.
   \item PercentChange: \code{<dbl>}. Changed area on the Interval level (\%).
   \item St: \code{<dbl>}. Annual intensity of change for a time
   period [Yt, Yt+1].
   \item U: \code{<dbl>}. Uniform intensity for a LUC category change in a time
   period of interest.
   }
}
\section{Slots}{

\describe{
\item{\code{intervalData}}{tibble. A table with the results of an Intensity analysis
at the Interval level (\emph{St} and \emph{U} values).}
}}

