% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listOMLFlows.R
\name{listOMLFlows}
\alias{listOMLFlows}
\title{List all registered OpenML flows.}
\usage{
listOMLFlows(tag = NULL, limit = NULL, offset = NULL, verbosity = NULL)
}
\arguments{
\item{tag}{[\code{character}]\cr
If not \code{NULL} only entries with the corresponding \code{tag}s
are listed.}

\item{limit}{[\code{numeric(1)}]\cr
Optional. The maximum number of entries to return. 
Without specifying \code{offset}, it returns the first '\code{limit}' entries.
Setting \code{limit = NULL} returns all available entries.}

\item{offset}{[\code{numeric(1)}]\cr
Optional. The offset to start from. 
Should be indices starting from 0, which do not refer to IDs. 
Is ignored when no \code{limit} is given.}

\item{verbosity}{[\code{integer(1)}]\cr
Print verbose output on console? Possible values are:\cr
\code{0}: normal output,\cr
\code{1}: info output,\cr
\code{2}: debug output.\cr
Default is set via \code{\link{setOMLConfig}}.}
}
\value{
[\code{data.frame}].
}
\description{
The returned \code{data.frame} contains the flow id \dQuote{fid},
the flow name (\dQuote{full.name} and \dQuote{name}), version information
(\dQuote{version} and \dQuote{external.version}) and the uploader (\dQuote{uploader})
of all registered OpenML flows.
}
\note{
This function is memoised. I.e., if you call this function twice in a running R session,
the first call will query the server and store the results in memory while the second and all subsequent calls will return
the cached results from the first call.
You can reset the cache by calling \code{\link[memoise]{forget}} on the function manually.
}
\examples{
# \dontrun{
# 	flows = listOMLFlows()
# 	tail(flows)
# }
}
\seealso{
Other listing functions: \code{\link{chunkOMLlist}},
  \code{\link{listOMLDataSetQualities}},
  \code{\link{listOMLDataSets}},
  \code{\link{listOMLEstimationProcedures}},
  \code{\link{listOMLEvaluationMeasures}},
  \code{\link{listOMLRuns}}, \code{\link{listOMLSetup}},
  \code{\link{listOMLStudies}},
  \code{\link{listOMLTaskTypes}},
  \code{\link{listOMLTasks}}

Other flow-related functions: \code{\link{convertOMLFlowToMlr}},
  \code{\link{deleteOMLObject}}, \code{\link{getOMLFlow}},
  \code{\link{makeOMLFlowParameter}},
  \code{\link{makeOMLFlow}}, \code{\link{tagOMLObject}}
}
