% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listOMLSetup.R
\name{listOMLSetup}
\alias{listOMLSetup}
\title{List hyperparameter settings}
\usage{
listOMLSetup(setup.id = NULL, flow.id = NULL, limit = 1000,
  offset = NULL, verbosity = NULL)
}
\arguments{
\item{setup.id}{[\code{integer(1)}]\cr
ID of the setup (which is basically an ID for the parameter configuration).}

\item{flow.id}{[\code{integer(1)}]\cr
ID of the implementation of an OpenML flow.}

\item{limit}{[\code{numeric(1)}]\cr
Optional. The maximum number of entries to return. 
Without specifying \code{offset}, it returns the first '\code{limit}' entries.
Setting \code{limit = NULL} returns all available entries.}

\item{offset}{[\code{numeric(1)}]\cr
Optional. The offset to start from. 
Should be indices starting from 0, which do not refer to IDs. 
Is ignored when no \code{limit} is given.}

\item{verbosity}{[\code{integer(1)}]\cr
Print verbose output on console? Possible values are:\cr
\code{0}: normal output,\cr
\code{1}: info output,\cr
\code{2}: debug output.\cr
Default is set via \code{\link{setOMLConfig}}.}
}
\value{
[\code{data.frame}].
}
\description{
Each run has a \code{setup.id}, i.e. an ID for the hyperparameter settings of the flow that produced the run.
This function allows the listing of hyperparameter settings.
}
\note{
This function is memoised. I.e., if you call this function twice in a running R session,
the first call will query the server and store the results in memory while the second and all subsequent calls will return
the cached results from the first call.
You can reset the cache by calling \code{\link[memoise]{forget}} on the function manually.
}
\examples{
# \dontrun{
#   listOMLSetup(limit = 1)
# }
}
\seealso{
Other listing functions: \code{\link{chunkOMLlist}},
  \code{\link{listOMLDataSetQualities}},
  \code{\link{listOMLDataSets}},
  \code{\link{listOMLEstimationProcedures}},
  \code{\link{listOMLEvaluationMeasures}},
  \code{\link{listOMLFlows}}, \code{\link{listOMLRuns}},
  \code{\link{listOMLStudies}},
  \code{\link{listOMLTaskTypes}},
  \code{\link{listOMLTasks}}
}
