% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sig_noise.R
\name{sig_noise}
\alias{sig_noise}
\alias{sig_noise.default}
\alias{sig_noise.OpenSpecy}
\title{Calculate signal and noise metrics for OpenSpecy objects}
\usage{
sig_noise(x, ...)

\method{sig_noise}{default}(x, ...)

\method{sig_noise}{OpenSpecy}(x, metric = "run_sig_over_noise", na.rm = TRUE, ...)
}
\arguments{
\item{x}{an \code{OpenSpecy} object.}

\item{metric}{character; specifying the desired metric to calculate.
Options include \code{"sig"} (mean intensity), \code{"noise"} (standard
deviation of intensity), \code{"sig_times_noise"} (absolute value of
signal times noise), \code{"sig_over_noise"} (absolute value of signal /
noise), \code{"run_sig_over_noise"} (absolute value of signal /
noise where signal is estimated as the max intensity and noise is
estimated as the height of a low intensity region.),
\code{"log_tot_sig"} (sum of the inverse log intensities, useful for spectra  in log units),
or \code{"tot_sig"} (sum of intensities).}

\item{na.rm}{logical; indicating whether missing values should be removed
when calculating signal and noise. Default is \code{TRUE}.}

\item{\ldots}{further arguments passed to subfunctions; currently not used.}
}
\value{
A numeric vector containing the calculated metric for each spectrum in the
\code{OpenSpecy} object.
}
\description{
This function calculates common signal and noise metrics for \code{OpenSpecy}
objects.
}
\examples{
data("raman_hdpe")

sig_noise(raman_hdpe, metric = "sig")
sig_noise(raman_hdpe, metric = "noise")
sig_noise(raman_hdpe, metric = "sig_times_noise")

}
