% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/def_features.R
\name{collapse_spec}
\alias{collapse_spec}
\alias{collapse_spec.default}
\alias{collapse_spec.OpenSpecy}
\alias{def_features}
\alias{def_features.default}
\alias{def_features.OpenSpecy}
\title{Define features}
\usage{
collapse_spec(x, ...)

\method{collapse_spec}{default}(x, ...)

\method{collapse_spec}{OpenSpecy}(x, ...)

def_features(x, ...)

\method{def_features}{default}(x, ...)

\method{def_features}{OpenSpecy}(x, features, shape_kernel = c(3, 3), ...)
}
\arguments{
\item{x}{an \code{OpenSpecy} object}

\item{features}{a logical vector or character vector describing which of the
spectra are of features (\code{TRUE}) and which are not (\code{FALSE}).
If a character vector is provided, it should represent the different feature
types present in the spectra.}

\item{shape_kernel}{the width and height of the area in pixels to search for
connecting features, c(3,3) is typically used but larger numbers will smooth
connections between particles more.}

\item{\ldots}{additional arguments passed to subfunctions.}
}
\value{
An \code{OpenSpecy} object appended with metadata about the features or
collapsed for the features.
}
\description{
Functions for analyzing features, like particles, fragments, or fibers, in
spectral map oriented \code{OpenSpecy} object.
}
\details{
\code{def_features()} accepts an \code{OpenSpecy} object and a logical or
character vector describing which pixels correspond to particles.
\code{collapse_spec()} takes an \code{OpenSpecy} object with particle-specific
metadata (from \code{def_features()}) and collapses the spectra to median
intensities for each unique particle.
It also updates the metadata with centroid coordinates, while preserving the
feature information on area and Feret max.
}
\examples{
\dontshow{data.table::setDTthreads(2)}
tiny_map <- read_extdata("CA_tiny_map.zip") |> read_any()
identified_map <- def_features(tiny_map, tiny_map$metadata$x == 0)
collapse_spec(identified_map)

}
\author{
Win Cowger, Zacharias Steinmetz
}
