/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import java.io.IOException;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractOsmTileSource;

public class OsmTileSource {
    public static final String MAP_MAPNIK = "http://tile.openstreetmap.org";
    public static final String MAP_OSMA = "http://tah.openstreetmap.org/Tiles";

    public static class UrlTileSource
    extends AbstractOsmTileSource {
        public String url = "https://a.tiles.mapbox.com/v4/mapquest.streets-mb/{z}/{x}/{y}.png?access_token=pk.eyJ1IjoibWFwcXVlc3QiLCJhIjoiY2Q2N2RlMmNhY2NiZTRkMzlmZjJmZDk0NWU0ZGJlNTMifQ.mPRiEubbajc6a5y9ISgydg";

        public UrlTileSource(String string) {
            super("url", "");
            if (string != null) {
                this.url = string;
            }
        }

        public String getTilePath(int n, int n2, int n3) throws IOException {
            String string = this.url;
            string = string.replace("{z}", "" + n);
            string = string.replace("{x}", "" + n2);
            string = string.replace("{y}", "" + n3);
            return string;
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }

        public String getAttributionText(int n, Coordinate coordinate, Coordinate coordinate2) {
            return "";
        }

        public String getAttributionLinkURL() {
            return "";
        }

        public String getTermsOfUseURL() {
            return "";
        }
    }

    public static class HillShade
    extends AbstractOsmTileSource {
        public HillShade() {
            super("hillshade", "http://toolserver.org/~cmarqu/hill");
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }

        public String getAttributionText(int n, Coordinate coordinate, Coordinate coordinate2) {
            return "\u00a9 OpenStreetMap contributors, CC-BY-SA and http://toolserver.org/~cmarqu/";
        }

        public String getAttributionLinkURL() {
            return "http://toolserver.org/~cmarqu/";
        }

        public String getTermsOfUseURL() {
            return "http://toolserver.org/~cmarqu/";
        }
    }

    public static class Skobbler
    extends AbstractOsmTileSource {
        public Skobbler() {
            super("skobbler", "http://tiles1.skobbler.net/osm_tiles2");
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }

        public String getAttributionText(int n, Coordinate coordinate, Coordinate coordinate2) {
            return "\u00a9 OpenStreetMap contributors and skobbler.com, CC-BY-SA ";
        }

        public String getAttributionLinkURL() {
            return "http://skobbler.com";
        }

        public String getTermsOfUseURL() {
            return "http://skobbler.com";
        }
    }

    public static class Apple
    extends AbstractOsmTileSource {
        public Apple() {
            super("apple-iphoto", "");
        }

        public String getTilePath(int n, int n2, int n3) throws IOException {
            return "http://gsp2.apple.com/tile?api=1&style=slideshow&layers=default&lang=en_EN&z=" + n + "&x=" + n2 + "&y=" + n3 + "&v=9";
        }

        public String getTileType() {
            return "jpeg";
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }

        public String getAttributionText(int n, Coordinate coordinate, Coordinate coordinate2) {
            return "\u00a9 Apple with data from OpenStreetMap";
        }

        public String getAttributionLinkURL() {
            return "http://apple.com";
        }

        public String getTermsOfUseURL() {
            return "http://apple.com";
        }
    }

    public static class Nps
    extends AbstractOsmTileSource {
        public Nps() {
            super("nps", "http://services.arcgisonline.com/ArcGIS/rest/services/World_Physical_Map/MapServer/tile");
        }

        public String getTileType() {
            return "jpg";
        }

        public String getTilePath(int n, int n2, int n3) throws IOException {
            return "/" + n + "/" + n3 + "/" + n2 + "." + this.getExtension();
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }

        public String getAttributionText(int n, Coordinate coordinate, Coordinate coordinate2) {
            return "\u00a9 National Park Service";
        }

        public String getAttributionLinkURL() {
            return "http://www.arcgis.com/home/item.html?id=c4ec722a1cd34cf0a23904aadf8923a0";
        }

        public String getTermsOfUseURL() {
            return "http://goto.arcgisonline.com/maps/World_Physical_Map";
        }
    }

    public static class EsriTopo
    extends AbstractOsmTileSource {
        public EsriTopo() {
            super("esri-topo", "http://services.arcgisonline.com/ArcGIS/rest/services/World_Topo_Map/MapServer/tile");
        }

        public String getTileType() {
            return "jpg";
        }

        public String getExtension() {
            return "jpg";
        }

        public String getTilePath(int n, int n2, int n3) throws IOException {
            return "/" + n + "/" + n3 + "/" + n2 + "." + this.getExtension();
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.None;
        }

        public String getAttributionText(int n, Coordinate coordinate, Coordinate coordinate2) {
            return "\u00a9 ESRI";
        }

        public String getAttributionLinkURL() {
            return "http://www.arcgis.com/home/item.html?id=f2498e3d0ff642bfb4b155828351ef0e";
        }

        public String getTermsOfUseURL() {
            return "http://services.arcgisonline.com/ArcGIS/rest/services/ESRI_Imagery_World_2D/MapServer";
        }
    }

    public static class Esri
    extends AbstractOsmTileSource {
        public Esri() {
            super("esri", "http://server.arcgisonline.com/ArcGIS/rest/services/World_Street_Map/MapServer/tile");
        }

        public String getTileType() {
            return "jpg";
        }

        public String getExtension() {
            return "jpg";
        }

        public String getTilePath(int n, int n2, int n3) throws IOException {
            return "/" + n + "/" + n3 + "/" + n2 + "." + this.getExtension();
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.None;
        }

        public String getAttributionText(int n, Coordinate coordinate, Coordinate coordinate2) {
            return "\u00a9 ESRI";
        }

        public String getAttributionLinkURL() {
            return "http://www.arcgis.com/home/item.html?id=3b93337983e9436f8db950e38a8629af";
        }

        public String getTermsOfUseURL() {
            return "http://services.arcgisonline.com/ArcGIS/rest/services/ESRI_Imagery_World_2D/MapServer";
        }
    }

    public static class OSM2World
    extends AbstractOsmTileSource {
        public OSM2World() {
            super("osm2world-3d", "http://c.tiles.osm2world.org/osm/pngtiles/n");
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }

        public String getAttributionText(int n, Coordinate coordinate, Coordinate coordinate2) {
            return "";
        }

        public String getAttributionLinkURL() {
            return "http://osm2world.org/";
        }

        public String getTermsOfUseURL() {
            return "http://osm2world.org/";
        }
    }

    public static class MapBox
    extends AbstractOsmTileSource {
        public MapBox() {
            super("mapbox", "");
        }

        public String getTilePath(int n, int n2, int n3) throws IOException {
            String string = "http://api.tiles.mapbox.com/v4/examples.map-zr0njcqy/{z}/{x}/{y}.png?access_token=pk.eyJ1IjoidGhlZmVsbCIsImEiOiJjaXN1anNwODEwMWlrMnRvZHBhamRrZjlqIn0.Gf8qLSpZ6yo5yfQhEutFfQ";
            string = string.replace("{z}", "" + n);
            string = string.replace("{x}", "" + n2);
            string = string.replace("{y}", "" + n3);
            return string;
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }

        public String getAttributionText(int n, Coordinate coordinate, Coordinate coordinate2) {
            return "\u00a9 OpenStreetMap contributors and mapbox.com, CC-BY-SA ";
        }

        public String getAttributionLinkURL() {
            return "http://mapbox.com/";
        }

        public String getTermsOfUseURL() {
            return "http://mapbox.com";
        }
    }

    public static class Wanderreitkarte
    extends AbstractOsmTileSource {
        public Wanderreitkarte() {
            super("osm-wanderreitkarte", "http://www.wanderreitkarte.de/topo");
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }

        public String getAttributionText(int n, Coordinate coordinate, Coordinate coordinate2) {
            return "\u00a9 OpenStreetMap contributors and http://www.wanderreitkarte.de, CC-BY-SA ";
        }

        public String getAttributionLinkURL() {
            return "http://www.wanderreitkarte.de/";
        }

        public String getTermsOfUseURL() {
            return "http://www.wanderreitkarte.de/licence_de.php";
        }
    }

    public static class Transport
    extends AbstractOsmTileSource {
        public Transport() {
            super("osm-transport", "http://a.tile2.opencyclemap.org/transport");
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }

        public String getAttributionText(int n, Coordinate coordinate, Coordinate coordinate2) {
            return "\u00a9 OpenStreetMap contributors, CC-BY-SA ";
        }

        public String getAttributionLinkURL() {
            return "http://openstreetmap.org/";
        }

        public String getTermsOfUseURL() {
            return "http://www.openstreetmap.org/copyright";
        }
    }

    public static class PublicTransport
    extends AbstractOsmTileSource {
        public PublicTransport() {
            super("osm-public-transport", "http://tile.memomaps.de/tilegen");
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }

        public String getAttributionText(int n, Coordinate coordinate, Coordinate coordinate2) {
            return "\u00a9 OpenStreetMap contributors, CC-BY-SA ";
        }

        public String getAttributionLinkURL() {
            return "http://openstreetmap.org/";
        }

        public String getTermsOfUseURL() {
            return "http://www.openstreetmap.org/copyright";
        }
    }

    public static class Waze
    extends AbstractOsmTileSource {
        public Waze() {
            super("waze", "http://tiles1.waze.com/tiles");
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }

        public String getAttributionText(int n, Coordinate coordinate, Coordinate coordinate2) {
            return "www.waze.com";
        }

        public String getAttributionLinkURL() {
            return "http://waze.com";
        }

        public String getTermsOfUseURL() {
            return "http://www.waze.com/legal/tos/";
        }
    }

    public static class MapToolKitTopo
    extends AbstractOsmTileSource {
        public MapToolKitTopo() {
            super("maptoolkit-topo", "http://tile1.maptoolkit.net/terrain");
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }

        public String getAttributionText(int n, Coordinate coordinate, Coordinate coordinate2) {
            return "www.maptoolkit.net";
        }

        public String getAttributionLinkURL() {
            return "http://maptoolkit.net/";
        }

        public String getTermsOfUseURL() {
            return "http://www.maptoolkit.net";
        }
    }

    public static class BBBikeGerman
    extends AbstractOsmTileSource {
        public BBBikeGerman() {
            super("osm-bbike-german", "http://a.tile.bbbike.org/osm/mapnik-german");
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }

        public String getAttributionText(int n, Coordinate coordinate, Coordinate coordinate2) {
            return "\u00a9 OpenStreetMap contributors, CC-BY-SA ";
        }

        public String getAttributionLinkURL() {
            return "http://openstreetmap.org/";
        }

        public String getTermsOfUseURL() {
            return "http://www.openstreetmap.org/copyright";
        }
    }

    public static class BBBike
    extends AbstractOsmTileSource {
        public BBBike() {
            super("osm-bbike", "http://a.tile.bbbike.org/osm/mapnik");
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }

        public String getAttributionText(int n, Coordinate coordinate, Coordinate coordinate2) {
            return "\u00a9 OpenStreetMap contributors, CC-BY-SA ";
        }

        public String getAttributionLinkURL() {
            return "http://openstreetmap.org/";
        }

        public String getTermsOfUseURL() {
            return "http://www.openstreetmap.org/copyright";
        }
    }

    public static abstract class OsmaSource
    extends AbstractOsmTileSource {
        String osmaSuffix;

        public OsmaSource(String string, String string2) {
            super(string, OsmTileSource.MAP_OSMA);
            this.osmaSuffix = string2;
        }

        public int getMaxZoom() {
            return 17;
        }

        public String getBaseUrl() {
            return "http://tah.openstreetmap.org/Tiles/" + this.osmaSuffix;
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfModifiedSince;
        }
    }

    public static class CycleMap
    extends AbstractOsmTileSource {
        private static final String PATTERN = "http://%s.tile.opencyclemap.org/cycle";
        private static final String[] SERVER = new String[]{"a", "b", "c"};
        private int SERVER_NUM = 0;

        public CycleMap() {
            super("opencyclemap", PATTERN);
        }

        public String getBaseUrl() {
            String string = String.format(this.baseUrl, SERVER[this.SERVER_NUM]);
            this.SERVER_NUM = (this.SERVER_NUM + 1) % SERVER.length;
            return string;
        }

        public int getMaxZoom() {
            return 17;
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.LastModified;
        }
    }

    public static class MapnikGerman
    extends AbstractOsmTileSource {
        public MapnikGerman() {
            super("osm-german", "http://tile.openstreetmap.de/tiles/osmde");
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }
    }

    public static class MapnikBw
    extends AbstractOsmTileSource {
        public MapnikBw() {
            super("osm-bw", "http://a.www.toolserver.org/tiles/bw-mapnik");
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }
    }

    public static class Mapnik
    extends AbstractOsmTileSource {
        public Mapnik() {
            super("osm", OsmTileSource.MAP_MAPNIK);
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }
    }
}

