% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptimLM.R
\name{Optim.LM}
\alias{Optim.LM}
\title{Find out what is the transformation of the response variable that best fits a classification linear model to your data}
\usage{
Optim.LM(formula, data, p, seqthreshold = 0.05,
  criteria = c("success_rate", "error_ti", "error_tii"),
  includedata = FALSE, seed = NULL, ...)
}
\arguments{
\item{formula}{A formula of the form \code{y ~ x1 + x2 + \dots}}

\item{data}{Data frame from which variables specified in  \code{formula} are preferentially to be taken.}

\item{p}{A percentage of training elements}

\item{seqthreshold}{Linear models doesn't return a class, it returns probability because of he must cut by levels. This parameter allows you to select the percentage between one threshold and next evaluated.}

\item{criteria}{This variable selects the criteria to select the best threshold. The default value is \code{success_rate}}

\item{includedata}{logicals. If TRUE the training and testing datasets are returned.}

\item{seed}{a single value, interpreted as an integer, or \code{NULL}. The default value is \code{NULL}, but for future checks of the model or models generated it is advisable to set a random seed to be able to reproduce it.}

\item{...}{arguments passed to \code{\link[stats]{lm}}}
}
\value{
An object of class \code{Optim}. See \code{\link{Optim.object}}
}
\description{
\code{Optim.LM} is used to fit the best classification linear model to a dataset. For this purpose, we examine the variation of the precision using the root mean square error (RMSE) when transformations are applied on the response variable. In addition, several thresholds are applied to check which is the most optimal cut for the indicators derived from the confusion matrix (success rate, type I error and type II error) according to a given criterion.
}
\examples{
if(interactive()){
## Load a Dataset
data(AustralianCredit)

## Create the model
linearcreditscoring <- Optim.LM(Y~., AustralianCredit, p = 0.7, seed=2018)

#See a ranking of the models tested
print(linearcreditscoring)

#Access to summary of the best model
summary(linearcreditscoring)

#not sure of like the best model, you can access to the all model, for example the 2nd model
summary(linearcreditscoring,2)
}

}
