% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meanDifference.R
\name{meanDifference}
\alias{meanDifference}
\alias{meanDifference,RasterLayer-method}
\alias{meanDifference,numeric-method}
\title{Calculate mean difference between two datasets}
\source{
Wang \emph{et al.} (2012) Impact of sensor degradation on the MODIS NDVI time 
series. Remote Sensing of Environment 119, 55-61, 
doi:\href{https://doi.org/10.1016/j.rse.2011.12.001}{10.1016/j.rse.2011.12.001}.

Detsch \emph{et al.} (2016) A Comparative Study of Cross-Product NDVI 
Dynamics in the Kilimanjaro Region - A Matter of Sensor, Degradation 
Calibration, and Significance. Remote Sensing 8(2), 159, 
doi:\href{http://dx.doi.org/10.3390/rs8020159}{10.3390/rs8020159}.
}
\usage{
\S4method{meanDifference}{RasterLayer}(x, y)

\S4method{meanDifference}{numeric}(x, y)
}
\arguments{
\item{x, y}{Objects of class \code{RasterLayer} or \code{numeric}.}
}
\value{
The mean difference between the two inputs either as \code{RasterLayer} or 
\code{numeric}.
}
\description{
Calculate the mean difference between two datasets as suggested by 
Wang \emph{et al.} (2012).
}
\examples{
x <- 1:10
y <- 2:11
meanDifference(x, y)

}
