% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/opm.R
\name{opm}
\alias{opm}
\alias{opm.default}
\alias{opm.formula}
\title{Fitting orthogonal panel models}
\usage{
opm(x, ...)

\method{opm}{default}(x, y, n.samp, add.time.indicators = FALSE, ...)

\method{opm}{formula}(x, data = environment(x), subset = NULL,
  index = 1:2, n.samp, ...)
}
\arguments{
\item{x}{a formula (see description of parameter \code{formula}
below) or an array of dimension \code{time x variable x case} of terms.}

\item{...}{further arguments passed to other methods.}

\item{y}{a matrix of dimensions \code{time x case} of responses.}

\item{n.samp}{number of samples to use to estimate the parameters.}

\item{add.time.indicators}{(logical) if \code{TRUE}, adds dummy
variables for time.}

\item{data}{an optional data frame, list, or environment containing
the variables in the model. If not found in \code{data}, the
variables are taken from \code{environment(x)}, typically the
environment from which \code{opm} is called.}

\item{subset}{an optional vector specifying a subset of
observations to be used in the fitting process.}

\item{index}{a two-element vector containing the index of the case
and time variables, respectively. Variable indices can be specifed
by name or position. This argument is ignored if the model is not
specified by the formula, because the index is implicit in the
organization of the terms and response arrays.}
}
\value{
An object of class \code{opm} with the following elements:
\describe{
\item{\code{samples}}{parameter samples used to estimate the model,
as a list with following elements:}
\describe{
\item{\code{rho}}{a vector of \code{n.samp} samples of \eqn{\rho}.}
\item{\code{v}}{a vector of \code{n.samp} samples of \eqn{\frac{1}{\sigma^2}}.}
\item{\code{beta}}{an \code{n.samp x variable} matrix of samples of \eqn{\beta}.}
}
\item{\code{call}}{the matched call}
\item{\code{index}}{the index variables, when using the formula interface}
\item{\code{time.indicators}}{\code{TRUE} if dummy time variables are used (see Notes), \code{FALSE} otherwise}
\item{\code{terms}}{the \code{terms} object used}
}

The function \code{summary} (i.e., \code{summary.opm}) can be used
to obtain or print a summary of the results. The generic accessor
functions \code{coefficients}, \code{fitted.values},
\code{residuals}, \code{logLik}, and \code{df.residual} can be used
to extract various useful features of the value returned by \code{opm}.
}
\description{
\code{opm} is used to fit orthogonal panel models.
}
\details{
The model can be either specified symbolically with the formula
\code{response ~ term1 + term2 ...} or with the terms and response
given as a pair of 3- and 2-dimensional arrays, \code{x} and
\code{y} respectively. The arrays have to be in the format
\code{time x variable x case} for terms and \code{time x case} for
the response.

The lagged dependent variable does not need to be included in the
formula or data, as it is included automatically.
}
\note{
Dummy time variables exist as an additional column for each
wave of data, excluding the first and second wave (i.e., at
\eqn{t=0} and \eqn{t=1} using the terminology from Lancaster
(2000)). The new variables are named \code{tind.}\eqn{t}, where
\eqn{t = 2, ...}, and appear as such as elements of the estimated
\code{beta} coefficient.
}
\examples{
set.seed(123)
N <- 5
T <- 2
beta <- .5
rho <- .5
v <- 1

f <- runif(N, -2, 2)
K <- length(beta)
beta <- matrix(beta, K, 1)

## $x_i = 0.75 f + N(0, 1)$:
x <- array(.75*f, dim=c(N, K, (T+1))) + rnorm(N*K*(T+1))

## $y_{i,t} = \\rho y_{i,t-1} + \\beta x_{i,t} + f_i + N(0,1)$:
y <- matrix(0, N, T+1)
for (t in seq_len(T+1)) {
    yy <- if (t>1) y[,t-1] else 0
    y[,t] <- rho * yy + f  + x[,,t] \%*\% beta + rnorm(N, sd = sqrt(1/v))
}

d <- data.frame(i = rep(seq(N), T+1),
                t = rep(seq(T+1), each = N),
                as.data.frame(matrix(aperm(x, c(1, 3, 2)), N*(T+1), K,
                                     dimnames = list(NULL, paste0('x', seq(K))))),
                y = c(y))
opm(y~x1, d, n.samp = 10)
}

