% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opm.R
\name{hist.opm}
\alias{hist.opm}
\title{Histogram of an \code{opm} Object}
\usage{
\method{hist}{opm}(x, parm, ask = dev.interactive(), plot = TRUE,
  main = NULL, xlab = NULL, ...)
}
\arguments{
\item{x}{an instance of class \code{opm}}

\item{parm}{a specification of which parameters are to be plotted,
       either a vector of names ("\code{rho}", "\code{sig2}"
and "\code{beta}" are the only legal values) or a vector of positional
indices. If missing, all parameters are considered.}

\item{ask}{if "\code{TRUE}", and the R session is interactive, the
user is asked to press a key before a new figure (i.e., histogram
of the next model parameter) is drawn.}

\item{plot}{if "\code{TRUE}" (default), the resulting object of
class "\code{histogram}" is plotted by \code{plot.hist}.}

\item{main, xlab}{(optional) vector of titles and X-axis labels
for \emph{each} figure.}

\item{...}{further arguments passed to the \code{\link{hist}}
function operating on the individual parameter's samples}
}
\value{
A list of objects of class "\code{histogram}", one for each
requested model parameter. The elements are named after the
parameter.
}
\description{
Method for \code{\link{hist}} applied to \code{\link{opm}} objects.
Each parameter will be plotted in a separate figure.
}

