% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/depth.R
\name{depthout}
\alias{depthout}
\title{Outlier detection using depth based method}
\usage{
depthout(x, rnames = FALSE, cutoff = 0.05, boottimes = 100)
}
\arguments{
\item{x}{dataset for which outliers are to be found}

\item{rnames}{Logical value indicating whether the dataset has rownames, default value is False}

\item{cutoff}{Percentile threshold used for depth, default value is 0.05}

\item{boottimes}{Number of bootsrap samples to find the cutoff, default is 100 samples}
}
\value{
Outlier Observations: A matrix of outlier observations

Location of Outlier: Vector of Sr. no. of outliers

Outlier probability: Vector of proportion of times an outlier exceeds local bootstrap cutoff
}
\description{
Takes a dataset and find its outliers using depth-based method
}
\details{
depthout computes depth of an observation using depthTools package and based on the bootstrapped cutoff, label an observation as outlier. Outlierliness of the labelled 'Outlier' is also reported and it is the bootstrap estimate of probability of the observation being an outlier. For bivariate data, it also shows the scatterplot of the data with labelled outliers.
}
\examples{
#Create dataset
X=iris[,1:4]
#Outlier detection
depthout(X,cutoff=0.05)
}
\references{
Johnson, T., Kwok, I., and Ng, R.T. 1998. Fast computation of 2-dimensional depth contours. In Proc. Int. Conf. on Knowledge Discovery and Data Mining (KDD), New York, NY. Kno
}
