NBANFL=function(){
  #' Dataset of NBA and NFL.
  #'
  #' @export
  #' @return List. It contains Bayesian posterior samples of all the parameters and log-likelihood.
  #' \enumerate{
  #'   \item NBA: full ranking lists of NBA power ranking.
  #'   \item NBAPL: The partial lists of NBA power ranking
  #'   \item NFLdata: all the ranking lists of NFL data
  #'   \item NFLcov: covariates of NFL players
  #' }
  #' @examples
  #' NBANFL()
  tau = matrix(c(1,3,7,5,8,6,14,15,2,4,9,10,19,11,12,18,13,21,16,20,17,22,23,27,25,29,28,24,26,30,
                 2,3,10,11,5,7,13,16,1,4,6,8,9,12,18,23,14,15,17,22,19,21,20,28,25,24,27,26,29,30,
                 1,2,11,10,6,7,14,13,3,4,9,8,5,17,12,26,15,16,20,19,24,23,22,18,25,21,28,29,27,30,
                 1,3,5,9,10,6,14,15,2,4,8,7,13,11,18,27,12,16,17,21,20,19,22,23,24,26,25,28,29,30,
                 1,2,8,9,5,6,13,15,4,3,7,11,10,14,12,28,16,17,20,19,24,22,23,18,25,21,27,30,26,29,
                 1,3,7,5,6,8,12,15,4,2,13,10,9,11,18,19,14,17,16,21,23,20,24,25,22,26,27,28,29,30),6,30,1)
 # nba data
NBAdata=t(tau)
{
  Ptau = matrix(c(1,2,6,4,NA,3,8,NA,NA,5,rep(NA,4),7,rep(NA,15),
                 1,2,5,8,6,7,rep(NA,3),4,3,rep(NA,19),
                 2,3,5,1,NA,6,NA,NA,7,8,4,rep(NA,19),
                 3,2,5,4,8,1,NA,NA,7,6,rep(NA,20),
                 1,NA,NA,2,NA,3,rep(NA,3),4,5,NA,8,rep(NA,8),6,rep(NA,4),7,rep(NA,3),
                 3,2,6,5,7,1,NA,NA,8,4,rep(NA,20),
                 rep(NA,3),2,NA,1,rep(NA,3),3,rep(NA,3),6,NA,8,NA,5,rep(NA,5),7,NA,4,rep(NA,4),
                 1,NA,6,3,NA,2,NA,4,rep(NA,9),7,NA,8,rep(NA,5),5,rep(NA,4),
                 2,4,5,1,NA,7,NA,NA,8,3,rep(NA,7),6,rep(NA,12),
                 1,2,4,3,NA,7,NA,NA,6,rep(NA,5),5,rep(NA,12),8,NA,NA,
                 3,7,NA,4,NA,1,NA,8,6,NA,2,rep(NA,9),5,rep(NA,9),
                 1,4,NA,3,NA,2,NA,6,5,8,rep(NA,18),7,NA,
                 3,NA,5,NA,NA,1,rep(NA,3),4,rep(NA,7),2,NA,7,NA,6,rep(NA,3),8,rep(NA,4),
                 1,NA,NA,4,NA,2,NA,NA,8,rep(NA,4),5,NA,NA,NA,6,3,7,rep(NA,10),
                 4,NA,8,2,NA,1,NA,NA,3,rep(NA,10),6,NA,NA,7,NA,NA,5,rep(NA,4),
                 1,2,6,3,NA,4,rep(NA,13),8,NA,NA,7,NA,NA,5,rep(NA,4),
                 4,NA,3,2,NA,5,NA,NA,1,NA,NA,NA,7,rep(NA,6),8,rep(NA,9),6,
                 2,NA,6,NA,NA,1,NA,5,NA,NA,4,rep(NA,6),3,rep(NA,6),8,NA,7,rep(NA,3),
                 1,2,NA,4,NA,3,NA,6,NA,NA,7,NA,NA,5,8,rep(NA,15),
                 2,NA,NA,4,NA,1,NA,NA,NA,3,8,NA,NA,NA,7,NA,NA,5,rep(NA,10),6,NA,
                 rep(NA,4),2,5,6,7,3,rep(NA,4),4,rep(NA,7),1,rep(NA,5),8,NA,NA,
                 4,NA,NA,2,NA,1,NA,6,NA,3,rep(NA,7),5,rep(NA,6),8,NA,7,NA,NA,NA,
                 rep(NA,7),6,NA,3,2,8,NA,NA,5,rep(NA,5),7,NA,4,NA,NA,1,rep(NA,4),
                 NA,2,rep(NA,5),4,NA,5,8,rep(NA,6),3,6,NA,NA,NA,7,rep(NA,4),1,NA,NA,
                 1,rep(NA,4),8,5,3,4,rep(NA,4),6,rep(NA,5),7,rep(NA,4),2,rep(NA,5),
                 1,NA,NA,2,NA,4,8,3,NA,5,7,NA,NA,6,rep(NA,16),
                 1,NA,NA,NA,4,2,NA,NA,5,NA,7,NA,8,rep(NA,7),3,rep(NA,5),6,rep(NA,3),
                 2,rep(NA,8),1,6,NA,NA,NA,8,3,NA,7,NA,NA,5,NA,4,rep(NA,7)
                 ),28,30,1)
}
NBAPL=t(Ptau)

{
  NFLdata = matrix(c(1,2,3,4,9,10,6,5,8,22,12,7,18,17,21,15,16,11,24,13,14,20,23,19,
                 1,3,2,7,5,4,8,6,9,10,13,14,12,22,17,23,11,16,15,18,19,20,21,24,
                 1,4,5,3,6,2,7,13,11,9,17,15,8,18,19,14,21,16,12,10,22,23,20,24,
                 3,2,4,5,1,8,7,6,13,9,10,20,17,19,15,23,16,11,14,12,18,22,21,24,
                 3,1,2,4,5,9,7,11,8,16,10,6,19,14,20,17,18,12,24,13,15,22,23,21,
                 1,2,3,5,4,7,6,8,9,10,12,17,11,19,15,14,18,16,13,21,22,20,23,24,
                 1,3,2,4,5,7,6,8,9,10,11,17,14,12,15,16,18,21,13,19,22,20,23,24,
                 1,3,2,6,4,5,10,7,8,9,12,11,14,13,15,20,16,17,18,19,21,23,22,24,
                 1,2,3,4,5,7,6,9,8,10,11,16,14,12,13,15,20,19,18,17,21,22,23,24,
                 1,2,4,3,5,6,7,9,8,10,12,15,16,13,11,14,21,18,20,17,19,22,24,23,
                 1,3,4,6,7,2,5,8,9,12,11,14,21,16,20,19,13,22,15,23,18,10,17,24,
                 1,4,2,8,6,3,7,5,9,12,14,10,13,23,21,22,11,16,15,20,17,19,18,24,
                 1,3,2,4,6,5,7,8,9,12,15,10,14,11,13,16,17,21,19,18,23,20,22,24),13,24,1)

  NFLcovariates = matrix(c(11, 63.4, 42.2, 7.8, 331.0, 6.3, 2.2, 4.2, 4.2,17.5, 30.4,
                        11, 66.7, 31.1, 8.6, 268.8, 8.8, 0.9, 2.5, 6.4,16.2, 50.0,
                        11, 68.1, 40.2, 8.0, 323.5, 7.7, 2.0, 1.5,-0.5,-0.7,  0.0,
                        11, 65.0, 37.9, 7.2, 272.5, 6.2, 1.4, 1.7, 0.7, 1.3, 21.1,
                        10, 68.8, 29.5, 8.5, 251.9, 7.5, 2.0, 1.5, 2.5, 3.7, 20.0,
                        11, 70.3, 42.0, 7.6, 317.4, 4.8, 2.4, 1.7, 2.8, 4.9, 26.3,
                        11, 68.3, 37.5, 7.9, 297.3, 5.8, 1.5, 1.9, 1.1, 2.1, 19.0,
                        11, 66.1, 35.4, 6.6, 234.7, 5.1, 2.1, 3.7, 6.7,25.1, 36.6,
                        11, 58.8, 37.7, 7.1, 267.5, 3.1, 2.4, 2.8, 2.0, 5.6, 16.1,
                        4, 62.3, 36.5, 8.1, 296.8, 4.8, 4.1, 3.5, 0.6, 2.0,  7.1,
                        11, 63.6, 28.5, 7.1, 202.7, 4.5, 1.6, 7.6, 7.7,58.5, 45.2,
                        11, 68.3, 33.0, 7.8, 257.7, 6.1, 2.5, 2.5, 2.5, 6.4, 25.0,
                        10, 58.6, 33.3, 7.2, 239.2, 3.6, 3.0, 6.4, 4.6,29.3, 37.5,
                        11, 62.3, 36.9, 7.0, 257.5, 5.2, 3.0, 0.8, 3.8, 3.1, 33.3,
                        11, 65.1, 38.5, 7.2, 278.7, 4.5, 2.1, 1.6, 4.3, 7.1, 33.3,
                        11, 62.4, 30.7, 7.1, 219.4, 3.6, 3.0, 3.8, 2.5, 9.5, 33.3,
                        11, 65.1, 29.7, 6.8, 201.0, 4.0, 1.2, 3.2, 5.5,17.4, 25.7,
                        11, 61.7, 31.5, 7.5, 237.7, 4.3, 1.7, 6.8, 4.5,30.5, 22.7,
                        11, 63.2, 34.1, 7.4, 251.3, 4.8, 2.1, 2.0, 1.7, 3.4, 45.5,
                        11, 66.8, 36.4, 7.1, 256.8, 5.5, 3.0, 2.9, 3.9,11.3, 28.1,
                        6, 60.4, 30.3, 7.4, 225.0, 3.8, 4.4, 2.7, 5.8,15.3, 50.0,
                        6, 53.6, 25.2, 7.1, 178.2, 3.3, 2.0, 3.0, 2.0, 6.0, 22.2,
                        8, 60.3, 32.8, 6.4, 211.1, 2.3, 2.7, 3.5, 4.6,16.1, 32.1,
                        11, 55.9, 33.2, 7.8, 260.4, 3.0, 2.2, 1.8, 0.9, 1.5, 20.0),nrow=24,ncol=11,1)
  cov.name = c("G","Pct","Att/G","Avg","Yds/G","TD%","Int%","RAtt/G","RAvg","RYds/G","R1st/G")
  return(list(NBA=NBAdata,NBAPL=NBAPL,NFLdata=NFLdata,NFLcov=NFLcovariates))
  } # nfl data
}
