% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decimateWavFiles.R
\name{decimateWavFiles}
\alias{decimateWavFiles}
\title{Decimate Wave Files}
\usage{
decimateWavFiles(inDir, outDir, newSr, progress = TRUE)
}
\arguments{
\item{inDir}{directory of wave files to decimate. Can also be a single .wav file.}

\item{outDir}{directory to write wave files to}

\item{newSr}{sample rate to decimate the files to}

\item{progress}{logical flag to show progress bar}
}
\value{
Invisibly returns the names of all files that were successfully
  decimated
}
\description{
Decimate a folder of .wav files or a single .wav file
  to a new sample rate.
}
\details{
This code is based on R code written by Jay Barlow.
}
\examples{

origDir <- file.path(tempdir(), 'origSR')
decDir <- file.path(tempdir(), 'decSR')
writeClickWave('origWav.wav', outDir=origDir, signalLength = 1, clickLength = 100,
               clicksPerSecond = 200, frequency = 20000, sampleRate = 100000)
decWavs <- decimateWavFiles(origDir, decDir, 50000)
file.remove(paste0(origDir, 'origWav.wav'))
file.remove(decWavs)

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
