% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edinfoToURL.R
\name{edinfoToURL}
\alias{edinfoToURL}
\title{Create a URL for Downloading Data from a edinfo Object}
\usage{
edinfoToURL(edinfo, ranges)
}
\arguments{
\item{edinfo}{a edinfo class object, either from \link{getEdinfo} or created by
\link{erddapToEdinfo}}

\item{ranges}{list of ranges for Longitude, Latitude, and UTC. Must be a
named list with a vector of min/max values for each of the three dimensions}
}
\value{
a properly formatted URL that can be used to download environmental data
}
\description{
Creates a properly formatted URL (see \link{formatURL}) from
  a datalist either from the package's recommended sources or an ERDDAP
  dataset id
}
\examples{
sstEdi <- getEdinfo()[['jplMURSST41']]
# select all variables for download
sstEdi <- varSelect(sstEdi, TRUE)
edinfoToURL(sstEdi, ranges = list(Latitude = c(32, 33),
                                  Longitude = c(-118, -117),
                                  UTC = as.POSIXct(c('2000-01-01 00:00:00',
                                                     '2000-01-02 00:00:00'), tz='UTC')))
}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
