% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peakTrough.R
\name{peakTrough}
\alias{peakTrough}
\title{Find Peaks and Troughs in a Spectrum}
\usage{
peakTrough(spec, freqBounds = c(10, 30), dbMin = -15, smooth = 5, plot = FALSE)
}
\arguments{
\item{spec}{the spectrum of a signal, the first column must be frequency in
kilohertz, the second column must be dB}

\item{freqBounds}{a two element vector specifying the frequency range around
the highest peak to search for a second/third peak. Units are in kHz, a
value of c(f1, f2) requires a second peak to be at least f1 kHz away from
the first peak, but no further than f2 kHz away.}

\item{dbMin}{minimum dB level for second / third peaks, relative to maximum
dB. Any points lower than this dB level will not be considered a candidate
peak.}

\item{smooth}{the amount to smooth the spectrum before attempting to find
second / third peaks. Uses a simple local average, smooth is the total
number of points to use. A value of 1 applies no smoothing.}

\item{plot}{logical flag to plot image of peak/trough locations on spectrum.
Useful for finding appropriate settings for freqBounds and dbMin}
}
\value{
a dataframe with the frequencies (in kHz) of up to 3 peaks and 2
  troughs between those peaks. Also reports the peak-to-peak distance. Any
  peaks / troughs that were not able to be found (based on \code{freqBounds}
  and \code{dbMin} parameters) will be 0.
}
\description{
Finds up to three peaks in a spectrum, as well as the troughs
  between those peaks.
}
\details{
This uses a very simple algorithm to find second and third peaks
  in a spectrum. Peak candidates are identified with a few simple steps.
  \describe{
    \item{Step 1}{Use a local average of (\code{smooth}) points to smooth the
  spectrum.}
    \item{Step 2}{Check if a point is larger than both its neighbors.}
    \item{Step 3}{Check if points are within the frequency range specified by
  \code{freqBounds}. Points must be at least f1 kHz away from the frequency
  , but no further than f2 kHz away.}
    \item{Step 4}{Check if points are above the minimum dB level specified by
  \code{dbMin}.}
  }
  From the remaining points the point with the highest dB level is selected
  as the second peak, then the frequency range filter of Step 3 is applied
  again around this second peak before attempting to find a third peak. If
  no second or third peak is found (ie. no values fall within the specified
  frequency and dB search ranges), then it will be set to 0. The trough
  values are set as the frequency with the lowest dB level between any peaks
  that were found. The trough values will be 0 for any peaks that were not
  found.

  If you are unsure of what levels to specify for \code{freqBounds} and
  \code{dbMin}, setting \code{plot=TRUE} will show a visualization of the
  search range and selected peaks so you can easily see if the selected
  parameters are capturing the behavior you want.
}
\examples{

clickWave <- createClickWave(signalLength = .1, clickLength = 1000, clicksPerSecond = 200,
                             frequency = 3e3, sampleRate = 10e3)
peakTrough(seewave::spec(clickWave, plot=FALSE), plot=TRUE)

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
