context('Test data loading and formatting')

test_that('Test MANTA load', {
    mfile1 <- system.file('extdata/MANTAExampleSmall1.csv', package='PAMscapes')
    mfile2 <- system.file('extdata/MANTAExampleSmall2.csv', package='PAMscapes')
    base1 <- read.csv(mfile1, stringsAsFactors = FALSE)
    base2 <- read.csv(mfile2, stringsAsFactors = FALSE)
    readr1 <- read_csv(mfile1, show_col_types = FALSE)
    readr2 <- read_csv(mfile2, show_col_types = FALSE)
    base1 <- checkManta(base1)
    base2 <- checkManta(base2)
    readr1 <- checkManta(readr1)
    readr2 <- checkManta(readr2)
    expect_true(all(c('UTC', 'HMD_0', 'HMD_1', 'HMD_2') %in% colnames(base1)[1:4]))
    expect_true(all(c('UTC', 'HMD_0', 'HMD_1', 'HMD_2') %in% colnames(base2)[1:4]))
    expect_true(all(c('UTC', 'HMD_0', 'HMD_1', 'HMD_2') %in% colnames(readr1)[1:4]))
    expect_true(all(c('UTC', 'HMD_0', 'HMD_1', 'HMD_2') %in% colnames(readr2)[1:4]))
    base1 <- checkSoundscapeInput(base1)
    base2 <- checkSoundscapeInput(base2)
    readr1 <- checkSoundscapeInput(readr1)
    readr2 <- checkSoundscapeInput(readr2)
    expect_equal(base1, data.frame(readr1))
    expect_equal(base2, data.frame(readr2))
    readr1[3, 10] <- Inf
    expect_warning(readr1 <- checkSoundscapeInput(readr1))
    expect_true(is.na(readr1[3, 10, drop=TRUE]))
})

test_that('Test octave', {
    manta <- system.file('extdata/MANTAExampleSmall1.csv', package='PAMscapes')

    ol <- createOctaveLevel(manta, type='ol')
    tol <- createOctaveLevel(manta, type='tol')
    expect_true(all(grepl('^OL_', colnames(ol[2:ncol(ol)]))))
    expect_true(all(grepl('^TOL_', colnames(tol[2:ncol(tol)]))))

    filtOl <- createOctaveLevel(manta, type='ol', freqRange = c(250, 8000))
    expect_true(colnames(filtOl)[2] == 'OL_250')
    expect_true(colnames(filtOl)[ncol(filtOl)] == 'OL_8000')
    filtDiff <- createOctaveLevel(manta, type='ol', freqRange = c(200, 8000))
    expect_identical(filtOl[['OL_250']], filtDiff[['OL_250']])
})

test_that('Test long wide', {
    manta <- system.file('extdata/MANTAExampleSmall1.csv', package='PAMscapes')
    ol <- createOctaveLevel(manta, type='ol')
    expect_identical(ol, toWide(ol))
    expect_identical(ol, toWide(toLong(ol)))
    olLong <- toLong(ol)
    expect_identical(olLong, toLong(olLong))
    expect_identical(olLong, toLong(toWide(olLong)))
    ol$ADDSHIT <- runif(nrow(ol))
    expect_identical(ol, toWide(toLong(ol))[colnames(ol)])
})
