% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_parse_fit.R
\name{summary}
\alias{summary}
\alias{summary.parse_fit}
\title{summary of the clustering results}
\usage{
summary(output, y, eps.diff = 1e-5)
}
\arguments{
\item{output}{results from parse, apfp, apL1 or nopenalty functions. For the `nopenalty' function, the `short.output' should be FALSE.}

\item{y}{data.}

\item{eps.diff}{The lower bound of pairwise difference of two mean values. Any value lower than it is treated as 0.}
}
\value{
\item{num.info}{the number of globally informative variables}
\item{perc.info}{the percentage of globally informative variables}
\item{info.name}{the variable names of the globally informative variables, if the data have no variable name, 'info.name' is the index of the variable}
}
\description{
Summary of the globally informative variables
}
\examples{
y <- rbind(matrix(rnorm(120,0,1),ncol=4),
matrix(rnorm(120,4,1), ncol=4), matrix(rnorm(120,0,1),ncol=4))
output <- parse(K = c(1:2), lambda = c(0,1), y=y)
output$mu.hat.best
summary(output, y)

}

