% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_Poisson.R
\name{power_Poisson}
\alias{power_Poisson}
\title{Power Calculations for Test of Two Poisson Ratios}
\usage{
power_Poisson(n1 = NULL, n2 = NULL, power = NULL, sig.level = 0.05,
lambda1 = NULL, lambda2 = NULL, t1 = 1, t2 = 1, RR0 = 1,
equal.sample = TRUE, alternative = c("two.sided", "one.sided"))
}
\arguments{
\item{n1}{sample size in group 1, or sample size in each group if \code{equal.sample = TRUE}}

\item{n2}{sample size in group 2}

\item{power}{power of test (1 minus Type II error probability)}

\item{sig.level}{significance level (Type I error probability)}

\item{lambda1}{Poisson rate for group 1}

\item{lambda2}{Poisson rate for group 2}

\item{t1}{observed time period for group 1}

\item{t2}{observed time period for group 2}

\item{RR0}{the ratio of lambda2 and lambda1 under null hypothesis}

\item{equal.sample}{equal sample sizes for two groups, see details}

\item{alternative}{one- or two-sided test}
}
\value{
Object of class "power.htest", a list of the arguments (including the computed one) augmented with method element.
}
\description{
Compute the power for a test of two sample means with Poisson distributions, or determine parameters to obtain a target power.
}
\details{
Exactly one of the parameters \code{n1}, \code{n2}, \code{lambda1}, \code{lambda2}, \code{power}, and \code{sig.level} must be passed as NULL, and that parameter is determined from the others.
Notice that \code{sig.level} has non-NULL defaults, so NULL must be explicitly passed if you want to compute them.\cr\cr
If \code{equal.sample = TRUE} is used, \code{n2} would be ignored and N in output denotes the number in each group.
}
\note{
'uniroot' is used to solve power equation for unknowns, 
so you may see errors from it, notably about inability to bracket the root when invalid arguments are given.
}
\examples{
power_Poisson(lambda1 = 0.0005, lambda2 = 0.003, n1 = 2000, t1 = 2, t2 = 2)
power_Poisson(lambda1 = 0.0005, lambda2 = 0.003, power = 0.8, t1 = 2, t2 = 2)
power_Poisson(n1 = 2000, lambda1 = 0.0005, lambda2 = 0.003, power = 0.8, 
t1 = 2, t2 = 2, equal.sample = FALSE)
}
\references{
Gu et al. (2008). Testing the ratio of two poisson rates. \emph{Biometrical Journal: Journal of Mathematical Methods in Biosciences}. \bold{50}:283-298.
}
