% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCMTree.R
\name{PCMTreeSetRegimesForEdges}
\alias{PCMTreeSetRegimesForEdges}
\title{Set the regime for each individual edge in a tree explicitly}
\usage{
PCMTreeSetRegimesForEdges(tree, regimes, inplace = TRUE)
}
\arguments{
\item{tree}{a PCMTree or a phylo object.}

\item{regimes}{a vector of the length equal to `nrow(tree$edge)`.}

\item{inplace}{a logical indicating if the change should be done within the
tree in the calling environment or a copy of the tree with modified regime
assignment should be retrned.}
}
\value{
if inplace is TRUE, nothing, otherwise a modified copy of tree.
}
\description{
Set the regime for each individual edge in a tree explicitly
}
\note{
Calling this function overwrites the current partitioning of the tree.
}
\examples{
set.seed(1, kind = "Mersenne-Twister", normal.kind = "Inversion")
tree <- ape::rtree(10)
regimes <- sample(letters[1:3], nrow(tree$edge), replace = TRUE)
PCMTreeSetRegimesForEdges(tree, regimes)
\donttest{
PCMTreePlot(tree)
}

}
