% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/self.belonging.R
\encoding{UTF-8}
\name{self.belonging}
\alias{self.belonging}
\title{Degree of self belonging of species}
\usage{
self.belonging(dis, standardize = TRUE)
}
\arguments{
\item{dis}{Matrix containing distance between species.}

\item{standardize}{Logical argument (TRUE or FALSE) to specify if dis must be standardize
in values into range 0 from 1 (Default standardize = TRUE).}
}
\value{
The self-belonging for each species.
}
\description{
Define the degree of self belonging of species.
}
\details{
For the calculation of self-belonging of a set of species the dissimilarities between
the species are transformed into similarities and used to define degrees of belonging 
to fuzzy sets (Pillar et al. 2009; Pillar & Duarte 2010). Every species among all 
species specifies a fuzzy set in relation to all other species, with a certain degree
of belonging. The self-belonging of a given species i expresses its degree of 
belonging to the root node of the phylogenetic/functional tree, conditioned to the 
similarities between i and all other internal nodes connecting it to the root.
}
\examples{

data(ADRS)
self.belonging(ADRS$phylo)

}
\references{
Pillar, V.D.; Duarte, L.d.S. (2010). A framework for
metacommunity analysis of phylogenetic structure. Ecology Letters, 13,
587:596.

Pillar, V.D., Duarte, L.d.S., Sosinski, E.E. & Joner, F. (2009).
Discriminating trait-convergence and trait-divergence assembly patterns in
ecological community gradients. Journal of Vegetation Science, 20, 334:348.
}
\seealso{
\code{\link{belonging}}
}
\author{
Vanderlei Julio Debastiani <vanderleidebastiani@yahoo.com.br>
}
\keyword{PCPS}
