% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/moments.r
\name{moment2cumulant}
\alias{moment2cumulant}
\title{Convert moments to raw cumulants.}
\usage{
moment2cumulant(moms)
}
\arguments{
\item{moms}{a vector of the moments. The first element is the first moment.
If centered moments are given, the first cumulant shall be zero.}
}
\value{
a vector of the cumulants.
}
\description{
Conversion of a vector of moments to raw cumulants.
}
\details{
The 'raw' cumulants \eqn{\kappa_i}{kappa_i} are connected
to the 'raw' (uncentered) moments, \eqn{\mu_i'}{mu'_i} via
the equation
\deqn{\kappa_n = \mu_n' - \sum_{m=1}^{n-1} {n-1 \choose m-1} \kappa_m \mu_{n-m}'}

Note that this formula also works for central moments, assuming
the distribution has been normalized to zero mean.
}
\examples{
# normal distribution, mean 0, variance 1
n.cum <- moment2cumulant(c(0,1,0,3,0,15))
# normal distribution, mean 1, variance 1
n.cum <- moment2cumulant(c(1,2,4,10,26))
# exponential distribution
lambda <- 0.7
n <- 1:6
e.cum <- moment2cumulant(factorial(n) / (lambda^n))
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\seealso{
\code{\link{cumulant2moment}}
}
\keyword{distribution}

