##' @title A function to generate a four-panel power curve under specified
##' number of PDX lines and number of individuals per PDX lines per treatment
##' @param object object of class 'PowerTable'.
##' @param ylim limit of y axis.
##' @param n.breaks number of breaks of the x axis. Default is NULL.
##' @return a figure generated by ggplot.
##' @export
##'

plotpower <- function(object, ylim = c(0, 0.1), n.breaks = NULL) {

  if (!inherits(object, "PowerTable"))
    stop("Use only with 'PowerTable' objects.\n")

  print <- object$print
  fixed.effect <- object$fixed.effect

  if (fixed.effect) {
    if (print == "both") {
      object <- data.frame(object$NofLine, object$NofMice,
                           object$ANOVAfix,
                           object$Coxfix)

      colnames(object) <- c("PDOX lines", "Number of mice", "ANOVAfix", "Coxfix")

      object$`Number of mice` <- as.factor(object$`Number of mice`)

      a1 <- ggplot2::ggplot(object, ggplot2::aes(x = `PDOX lines`, y = ANOVAfix,
                                                 group = `Number of mice`,
                                                 color = `Number of mice`)) +
        ggplot2::geom_line() +
        ggplot2::ylab("Power for ANOVA fixed effects") +
        ggplot2::xlab("Number of PDX lines") +
        ggplot2::ylim(ylim) +
        ggplot2::theme_bw() +
        ggplot2::scale_x_continuous(n.breaks = n.breaks)

      a2 <- ggplot2::ggplot(object,
                            ggplot2::aes(x = `PDOX lines`, y = Coxfix,
                                         group = `Number of mice`,
                                         color = `Number of mice`)) +
        ggplot2::geom_line() +
        ggplot2::ylab("Power for Cox fixed effects") +
        ggplot2::xlab("Number of PDX lines") +
        ggplot2::ylim(ylim) +
        ggplot2::theme_bw() +
        ggplot2::scale_x_continuous(n.breaks = n.breaks)

      ggpubr::ggarrange(a1, a2, ncol = 2, nrow = 1, common.legend = TRUE,
                        legend = "right")


    } else if (print == "ANOVA") {

      object <- data.frame(object$NofLine, object$NofMice, object$ANOVAfix)

      colnames(object) <- c("PDOX lines", "Number of mice", "ANOVAfix")

      object$`Number of mice` <- as.factor(object$`Number of mice`)

      ggplot2::ggplot(object, ggplot2::aes(x = `PDOX lines`, y = ANOVAfix,
                                                 group = `Number of mice`,
                                                 color = `Number of mice`)) +
        ggplot2::geom_line() +
        ggplot2::ylab("Power for ANOVA fixed effects") +
        ggplot2::xlab("Number of PDX lines") +
        ggplot2::ylim(ylim) +
        ggplot2::theme_bw() +
        ggplot2::scale_x_continuous(n.breaks = n.breaks)

    } else {

      object <- data.frame(object$NofLine, object$NofMice, object$Coxfix)

      colnames(object) <- c("PDOX lines", "Number of mice", "Coxfix")

      object$`Number of mice` <- as.factor(object$`Number of mice`)

      ggplot2::ggplot(object, ggplot2::aes(x = `PDOX lines`, y = Coxfix,
                                         group = `Number of mice`,
                                         color = `Number of mice`)) +
        ggplot2::geom_line() +
        ggplot2::ylab("Power for Cox fixed effects") +
        ggplot2::xlab("Number of PDX lines") +
        ggplot2::ylim(ylim) +
        ggplot2::theme_bw() +
        ggplot2::scale_x_continuous(n.breaks = n.breaks)

    }
  } else {
    if (print == "both") {
      object <- data.frame(object$NofLine, object$NofMice,
                           object$ANOVArandom,
                           object$Coxrandom)

      colnames(object) <- c("PDOX lines", "Number of mice", "ANOVArandom", "Coxrandom")

      object$`Number of mice` <- as.factor(object$`Number of mice`)

      a1 <- ggplot2::ggplot(object,
                            ggplot2::aes(x = `PDOX lines`, y = ANOVArandom,
                                         group = `Number of mice`,
                                         color = `Number of mice`)) +
        ggplot2::geom_line() +
        ggplot2::ylab("Power for ANOVA mixed effects") +
        ggplot2::xlab("Number of PDX lines") +
        ggplot2::ylim(ylim) +
        ggplot2::theme_bw() +
        ggplot2::scale_x_continuous(n.breaks = n.breaks)

      a2 <- ggplot2::ggplot(object,
                            ggplot2::aes(x = `PDOX lines`, y = Coxrandom,
                                         group = `Number of mice`,
                                         color = `Number of mice`)) +
        ggplot2::geom_line() +
        ggplot2::ylab("Power for Cox frailty") +
        ggplot2::xlab("Number of PDX lines") +
        ggplot2::ylim(ylim) +
        ggplot2::theme_bw() +
        ggplot2::scale_x_continuous(n.breaks = n.breaks)

      ggpubr::ggarrange(a1, a2, ncol = 2, nrow = 1, common.legend = TRUE,
                        legend = "right")

    } else if (print == "ANOVA") {

      object <- data.frame(object$NofLine, object$NofMice,
                           object$ANOVArandom)

      colnames(object) <- c("PDOX lines", "Number of mice", "ANOVArandom")

      object$`Number of mice` <- as.factor(object$`Number of mice`)

      ggplot2::ggplot(object, ggplot2::aes(x = `PDOX lines`, y = ANOVArandom,
                                           group = `Number of mice`,
                                           color = `Number of mice`)) +
        ggplot2::geom_line() +
        ggplot2::ylab("Power for ANOVA") +
        ggplot2::xlab("Number of PDX lines") +
        ggplot2::ylim(ylim) +
        ggplot2::theme_bw() +
        ggplot2::scale_x_continuous(n.breaks = n.breaks)
    } else {

      object <- data.frame(object$NofLine, object$NofMice,
                           object$Coxrandom)

      colnames(object) <- c("PDOX lines", "Number of mice", "Coxrandom")

      object$`Number of mice` <- as.factor(object$`Number of mice`)

      ggplot2::ggplot(object,
                      ggplot2::aes(x = `PDOX lines`, y = Coxrandom,
                                   group = `Number of mice`,
                                   color = `Number of mice`)) +
        ggplot2::geom_line() +
        ggplot2::ylab("Power for Cox frailty") +
        ggplot2::xlab("Number of PDX lines") +
        ggplot2::ylim(ylim) +
        ggplot2::theme_bw() +
        ggplot2::scale_x_continuous(n.breaks = n.breaks)
    }

  }

}
